# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.object import Object


class AbstractContextItem(Object):
    """
    AbstractContextItem - base class for items that are part of a
    
    Superclass: Object
    
    This class is the common base for all context scene items. You should
    generally derive from ContextItem, rather than this class, as it
    provides most of the commonly used API.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAbstractContextItem, obj, update, **traits)
    
    visible = traits.Bool(True, help=\
        """
        Set the visibility of the item (should it be drawn). Visible by
        default.
        """
    )
    def _visible_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVisible,
                        self.visible)

    def _get_scene(self):
        return wrap_vtk(self._vtk_obj.GetScene())
    def _set_scene(self, arg):
        old_val = self._get_scene()
        self._wrap_call(self._vtk_obj.SetScene,
                        deref_vtk(arg))
        self.trait_property_changed('scene', old_val, arg)
    scene = traits.Property(_get_scene, _set_scene, help=\
        """
        Get the ContextScene for the item, always set for an item in a
        scene.
        """
    )

    def _get_parent(self):
        return wrap_vtk(self._vtk_obj.GetParent())
    def _set_parent(self, arg):
        old_val = self._get_parent()
        self._wrap_call(self._vtk_obj.SetParent,
                        deref_vtk(arg))
        self.trait_property_changed('parent', old_val, arg)
    parent = traits.Property(_get_parent, _set_parent, help=\
        """
        Get the parent item. The parent will be set for all items except
        top level items in a tree.
        """
    )

    interactive = traits.Bool(True, help=\
        """
        Set if the item is interactive (should respond to mouse events).
        """
    )
    def _interactive_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInteractive,
                        self.interactive)

    def get_item(self, *args):
        """
        V.get_item(int) -> AbstractContextItem
        C++: AbstractContextItem *GetItem(unsigned int index)
        Get the item at the specified index.
        \return the item at the specified index (null if index is
            invalid).
        """
        ret = self._wrap_call(self._vtk_obj.GetItem, *args)
        return wrap_vtk(ret)

    def get_item_index(self, *args):
        """
        V.get_item_index(AbstractContextItem) -> int
        C++: unsigned int GetItemIndex(AbstractContextItem *item)
        Get the index of the specified item.
        \return the index of the item (-1 if item is not a valid child).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetItemIndex, *my_args)
        return ret

    def _get_number_of_items(self):
        return self._vtk_obj.GetNumberOfItems()
    number_of_items = traits.Property(_get_number_of_items, help=\
        """
        Get the number of child items.
        """
    )

    def add_item(self, *args):
        """
        V.add_item(AbstractContextItem) -> int
        C++: unsigned int AddItem(AbstractContextItem *item)
        Add child items to this item. Increments reference count of item.
        \return the index of the child item.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddItem, *my_args)
        return ret

    def clear_items(self):
        """
        V.clear_items()
        C++: void ClearItems()
        Remove all child items from this item.
        """
        ret = self._vtk_obj.ClearItems()
        return ret
        

    def lower(self, *args):
        """
        V.lower(int) -> int
        C++: unsigned int Lower(unsigned int index)
        Lowers the child to the bottom of the item's stack.
        \return The new index of the item\sa stack_under(), Raise(),
            stack_above()
        """
        ret = self._wrap_call(self._vtk_obj.Lower, *args)
        return ret

    def map_from_parent(self, *args):
        """
        V.map_from_parent(Vector2f) -> Vector2f
        C++: virtual Vector2f MapFromParent(const Vector2f &point)
        Maps the point from the parent coordinate system.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.MapFromParent, *my_args)
        return wrap_vtk(ret)

    def map_from_scene(self, *args):
        """
        V.map_from_scene(Vector2f) -> Vector2f
        C++: virtual Vector2f MapFromScene(const Vector2f &point)
        Maps the point from the scene coordinate system.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.MapFromScene, *my_args)
        return wrap_vtk(ret)

    def map_to_parent(self, *args):
        """
        V.map_to_parent(Vector2f) -> Vector2f
        C++: virtual Vector2f MapToParent(const Vector2f &point)
        Maps the point to the parent coordinate system.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.MapToParent, *my_args)
        return wrap_vtk(ret)

    def map_to_scene(self, *args):
        """
        V.map_to_scene(Vector2f) -> Vector2f
        C++: virtual Vector2f MapToScene(const Vector2f &point)
        Maps the point to the scene coordinate system.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.MapToScene, *my_args)
        return wrap_vtk(ret)

    def paint(self, *args):
        """
        V.paint(Context2D) -> bool
        C++: virtual bool Paint(Context2D *painter)
        Paint event for the item, called whenever the item needs to be
        drawn.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Paint, *my_args)
        return ret

    def paint_children(self, *args):
        """
        V.paint_children(Context2D) -> bool
        C++: virtual bool PaintChildren(Context2D *painter)
        Paint the children of the item, should be called whenever the
        children need to be rendered.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PaintChildren, *my_args)
        return ret

    def raise_(self, *args):
        """
        V.raise(int) -> int
        C++: unsigned int Raise(unsigned int index)
        Raises the child to the top of the item's stack.
        \return The new index of the item\sa stack_above(), Lower(),
            lower_under()
        """
        ret = self._wrap_call(self._vtk_obj.Raise, *args)
        return ret

    def release_graphics_resources(self):
        """
        V.release_graphics_resources()
        C++: virtual void ReleaseGraphicsResources()
        Release graphics resources hold by the item. The default
        implementation is empty.
        """
        ret = self._vtk_obj.ReleaseGraphicsResources()
        return ret
        

    def remove_item(self, *args):
        """
        V.remove_item(AbstractContextItem) -> bool
        C++: bool RemoveItem(AbstractContextItem *item)
        V.remove_item(int) -> bool
        C++: bool RemoveItem(unsigned int index)
        Remove child item from this item. Decrements reference count of
        item.
        \param item the item to be removed.
        \return true on success, false otherwise.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveItem, *my_args)
        return ret

    def stack_above(self, *args):
        """
        V.stack_above(int, int) -> int
        C++: virtual unsigned int StackAbove(unsigned int index,
            unsigned int under)
        Raises the child above the under sibling. If under is invalid,
        the item is raised to the top of the item's stack.
        \return The new index of the item\sa Raise(), Lower(),
            stack_under()
        """
        ret = self._wrap_call(self._vtk_obj.StackAbove, *args)
        return ret

    def stack_under(self, *args):
        """
        V.stack_under(int, int) -> int
        C++: virtual unsigned int StackUnder(unsigned int child,
            unsigned int above)
        Lowers the child under the above sibling. If above is invalid,
        the item is lowered to the bottom of the item's stack
        \return The new index of the item\sa Lower(), Raise(),
            stack_above()
        """
        ret = self._wrap_call(self._vtk_obj.StackUnder, *args)
        return ret

    def update(self):
        """
        V.update()
        C++: virtual void Update()
        Perform any updates to the item that may be necessary before
        rendering. The scene should take care of calling this on all
        items before their Paint function is invoked.
        """
        ret = self._vtk_obj.Update()
        return ret
        

    _updateable_traits_ = \
    (('reference_count', 'GetReferenceCount'), ('visible', 'GetVisible'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('debug',
    'GetDebug'), ('interactive', 'GetInteractive'))
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'interactive', 'visible'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AbstractContextItem, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit AbstractContextItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], ['interactive', 'visible']),
            title='Edit AbstractContextItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AbstractContextItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

