# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.amr_base_particles_reader import AMRBaseParticlesReader


class AMREnzoParticlesReader(AMRBaseParticlesReader):
    """
    AMREnzoParticlesReader.h -- Reads AMR Enzo Particle datasets
    
    Superclass: AMRBaseParticlesReader
    
    A concrete instance of the AMRBaseParticlesReader which provides
     functionality for loading ENZO AMR particle datasets from ENZO.
    
    See Also:
    
    
     AMRBaseParticlesReader
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAMREnzoParticlesReader, obj, update, **traits)
    
    particle_type = traits.Int(-1, enter_set=True, auto_set=False, help=\
        """
        Returns the requested particle type.
        """
    )
    def _particle_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetParticleType,
                        self.particle_type)

    _updateable_traits_ = \
    (('particle_type', 'GetParticleType'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('file_name', 'GetFileName'),
    ('progress_text', 'GetProgressText'), ('debug', 'GetDebug'),
    ('frequency', 'GetFrequency'), ('release_data_flag',
    'GetReleaseDataFlag'), ('reference_count', 'GetReferenceCount'),
    ('progress', 'GetProgress'), ('abort_execute', 'GetAbortExecute'),
    ('filter_location', 'GetFilterLocation'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'filter_location',
    'global_warning_display', 'release_data_flag', 'file_name',
    'frequency', 'particle_type', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AMREnzoParticlesReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit AMREnzoParticlesReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['filter_location'], [], ['file_name', 'frequency',
            'particle_type']),
            title='Edit AMREnzoParticlesReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AMREnzoParticlesReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

