# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.amr_base_reader import AMRBaseReader


class AMREnzoReader(AMRBaseReader):
    """
    AMREnzoReader.h -- Reader for Enzo AMR datasets.
    
    Superclass: AMRBaseReader
    
    A concrete instance of AMRBaseReader that implements functionality
    for reading Enzo AMR datasets.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAMREnzoReader, obj, update, **traits)
    
    convert_to_cgs = tvtk_base.true_bool_trait(help=\
        """
        Set/Get whether data should be converted to CGS
        """
    )
    def _convert_to_cgs_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConvertToCGS,
                        self.convert_to_cgs_)

    _updateable_traits_ = \
    (('enable_caching', 'GetEnableCaching'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('file_name', 'GetFileName'),
    ('progress_text', 'GetProgressText'), ('debug', 'GetDebug'),
    ('convert_to_cgs', 'GetConvertToCGS'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('reference_count', 'GetReferenceCount'), ('progress', 'GetProgress'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'convert_to_cgs', 'debug', 'enable_caching',
    'global_warning_display', 'release_data_flag', 'file_name',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AMREnzoReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit AMREnzoReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['convert_to_cgs', 'enable_caching'], [],
            ['file_name']),
            title='Edit AMREnzoReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AMREnzoReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

