# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class AppendPoints(PolyDataAlgorithm):
    """
    AppendPoints - appends points of one or more PolyData data sets
    
    Superclass: PolyDataAlgorithm
    
    AppendPoints is a filter that appends the points and associated
    data of one or more polygonal (vtk_poly_data) datasets. This filter can
    optionally add a new array marking the input index that the point
    came from.
    
    See Also:
    
    AppendFilter AppendPolyData
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAppendPoints, obj, update, **traits)
    
    input_id_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), help=\
        """
        Sets the output array name to fill with the input connection
        index for each point. This provides a way to trace a point back
        to a particular input. If this is NULL (the default), the array
        is not generated.
        """
    )
    def _input_id_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInputIdArrayName,
                        self.input_id_array_name)

    output_points_precision = traits.Int(2, enter_set=True, auto_set=False, help=\
        """
        Set/get the desired precision for the output type. See the
        documentation for the Algorithm::DesiredOutputPrecision enum
        for an explanation of the available precision settings. If the
        desired precision is DEFAULT_PRECISION and any of the inputs are
        double precision, then the output precision will be double
        precision. Otherwise, if the desired precision is
        DEFAULT_PRECISION and all the inputs are single precision, then
        the output will be single precision.
        """
    )
    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    _updateable_traits_ = \
    (('global_warning_display', 'GetGlobalWarningDisplay'),
    ('progress_text', 'GetProgressText'), ('debug', 'GetDebug'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('input_id_array_name', 'GetInputIdArrayName'),
    ('reference_count', 'GetReferenceCount'), ('progress', 'GetProgress'),
    ('output_points_precision', 'GetOutputPointsPrecision'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'input_id_array_name', 'output_points_precision',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AppendPoints, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit AppendPoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], ['input_id_array_name',
            'output_points_precision']),
            title='Edit AppendPoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AppendPoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

