# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class ArcSource(PolyDataAlgorithm):
    """
    ArcSource - create an arc between two end points
    
    Superclass: PolyDataAlgorithm
    
    ArcSource is a source object that creates an arc defined by two
    endpoints and a center. The number of segments composing the polyline
    is controlled by setting the object resolution. Alternatively, one
    can use a better API (that does not allow for inconsistent nor
    ambiguous inputs), using a starting point, a normal, and an angle.
    The default API being the original one, in order to use the improved
    API, one must switch the use_normal_and_angle flag to TRUE.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkArcSource, obj, update, **traits)
    
    use_normal_and_angle = tvtk_base.false_bool_trait(help=\
        """
        Activate the API based on normal and radius. The previous API
        (which remains the default) allows for inconsistent (when Point1
        and Point2 are not equidistant from Center) or ambiguous (when
        Point1, Point2, and Center are aligned). Note: false by default.
        """
    )
    def _use_normal_and_angle_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseNormalAndAngle,
                        self.use_normal_and_angle_)

    negative = tvtk_base.false_bool_trait(help=\
        """
        Use the angle that is a negative coterminal of the vectors angle:
        the longest angle. Note: false by default.
        """
    )
    def _negative_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNegative,
                        self.negative_)

    output_points_precision = traits.Int(0, enter_set=True, auto_set=False, help=\
        """
        Set/get the desired precision for the output points.
        Algorithm::SINGLE_PRECISION - Output single-precision floating
        point. Algorithm::DOUBLE_PRECISION - Output double-precision
        floating point.
        """
    )
    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    angle = traits.Trait(90.0, traits.Range(-360.0, 360.0, enter_set=True, auto_set=False), help=\
        """
        Angular sector occupied by the arc, beginning at Point1. Note:
        This is only used when use_normal_and_radius is ON.
        """
    )
    def _angle_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAngle,
                        self.angle)

    center = traits.Array(shape=(3,), value=(0.0, 0.0, 0.0), dtype=float, enter_set=True, auto_set=False, cols=3, help=\
        """
        
        """
    )
    def _center_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCenter,
                        self.center)

    normal = traits.Array(shape=(3,), value=(1.0, 0.0, 0.0), dtype=float, enter_set=True, auto_set=False, cols=3, help=\
        """
        
        """
    )
    def _normal_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormal,
                        self.normal)

    polar_vector = traits.Array(shape=(3,), value=(0.0, 0.0, 1.0), dtype=float, enter_set=True, auto_set=False, cols=3, help=\
        """
        
        """
    )
    def _polar_vector_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarVector,
                        self.polar_vector)

    point1 = traits.Array(shape=(3,), value=(0.0, 0.5, 0.0), dtype=float, enter_set=True, auto_set=False, cols=3, help=\
        """
        
        """
    )
    def _point1_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPoint1,
                        self.point1)

    point2 = traits.Array(shape=(3,), value=(0.5, 0.0, 0.0), dtype=float, enter_set=True, auto_set=False, cols=3, help=\
        """
        
        """
    )
    def _point2_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPoint2,
                        self.point2)

    resolution = traits.Trait(1, traits.Range(1, 2147483647, enter_set=True, auto_set=False), help=\
        """
        Divide line into resolution number of pieces. Note: if Resolution
        is set to 1 (default), the arc is a straight line.
        """
    )
    def _resolution_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetResolution,
                        self.resolution)

    _updateable_traits_ = \
    (('angle', 'GetAngle'), ('center', 'GetCenter'), ('normal',
    'GetNormal'), ('debug', 'GetDebug'), ('progress_text',
    'GetProgressText'), ('negative', 'GetNegative'), ('point1',
    'GetPoint1'), ('point2', 'GetPoint2'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('use_normal_and_angle', 'GetUseNormalAndAngle'), ('reference_count',
    'GetReferenceCount'), ('progress', 'GetProgress'), ('resolution',
    'GetResolution'), ('output_points_precision',
    'GetOutputPointsPrecision'), ('polar_vector', 'GetPolarVector'),
    ('global_warning_display', 'GetGlobalWarningDisplay'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display', 'negative',
    'release_data_flag', 'use_normal_and_angle', 'angle', 'center',
    'normal', 'output_points_precision', 'point1', 'point2',
    'polar_vector', 'progress_text', 'resolution'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ArcSource, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit ArcSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['negative', 'use_normal_and_angle'], [], ['angle',
            'center', 'normal', 'output_points_precision', 'point1', 'point2',
            'polar_vector', 'resolution']),
            title='Edit ArcSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ArcSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

