# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.generic_movie_writer import GenericMovieWriter


class AVIWriter(GenericMovieWriter):
    """
    AVIWriter - Writes Windows AVI files.
    
    Superclass: GenericMovieWriter
    
    AVIWriter writes AVI files. Note that this class in only available
    on the Microsoft Windows platform. The data type of the file is
    unsigned char regardless of the input type.
    
    See Also:
    
    GenericMovieWriter MPEG2Writer
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAVIWriter, obj, update, **traits)
    
    prompt_compression_options = tvtk_base.false_bool_trait(help=\
        """
        Set/Get if the user should be prompted for compression options,
        i.e. pick a compressor, set the compression rate (override Rate),
        etc.). Default is OFF (legacy).
        """
    )
    def _prompt_compression_options_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPromptCompressionOptions,
                        self.prompt_compression_options_)

    rate = traits.Trait(1000, traits.Range(1, 5000, enter_set=True, auto_set=False), help=\
        """
        Set/Get the frame rate, in frame/s.
        """
    )
    def _rate_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRate,
                        self.rate)

    quality = traits.Trait(10000, 10000, traits.Range(0, 2, enter_set=True, auto_set=False), help=\
        """
        Set/Get the compression quality. 0 means worst quality and
        smallest file size 2 means best quality and largest file size
        """
    )
    def _quality_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetQuality,
                        self.quality)

    compressor_four_cc = traits.String(r"MSVC", enter_set=True, auto_set=False, help=\
        """
        Set/Get the compressor four_cc. A four_cc (literally,
        four-character code) is a sequence of four bytes used to uniquely
        identify data formats. [...] One of the most well-known uses of
        four_c_cs is to identify the video codec used in AVI files. Common
        identifiers include DIVX, XVID, and H264.
        http://en.wikipedia.org/wiki/_four_cc. Default value is:
        - MSVC Other examples include:
        - DIB: Full Frames (Uncompressed)
        - LAGS: Lagarith Lossless Codec
        - MJPG: M-JPG, aka Motion JPEG (say, Pegasus Imaging pic_video
          M-JPEG) Links:
        - http://www.fourcc.org/
        - http://www.microsoft.com/whdc/archive/fourcc.mspx
        - http://abcavi.kibi.ru/fourcc.php
        """
    )
    def _compressor_four_cc_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCompressorFourCC,
                        self.compressor_four_cc)

    _updateable_traits_ = \
    (('compressor_four_cc', 'GetCompressorFourCC'), ('file_name',
    'GetFileName'), ('progress_text', 'GetProgressText'), ('debug',
    'GetDebug'), ('rate', 'GetRate'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('reference_count', 'GetReferenceCount'), ('progress', 'GetProgress'),
    ('prompt_compression_options', 'GetPromptCompressionOptions'),
    ('quality', 'GetQuality'), ('global_warning_display',
    'GetGlobalWarningDisplay'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'prompt_compression_options', 'release_data_flag',
    'compressor_four_cc', 'file_name', 'progress_text', 'quality',
    'rate'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AVIWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit AVIWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['prompt_compression_options'], [],
            ['compressor_four_cc', 'file_name', 'quality', 'rate']),
            title='Edit AVIWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AVIWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

