# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.object import Object


class BackgroundColorMonitor(Object):
    """
    BackgroundColorMonitor -- A helper for painters that
    
    Superclass: Object
    
    BackgroundColorMonitor -- A helper for painters that tracks state
    of background color(s). A Painter could use this to skip expensive
    processing that is only needed when background color changes. This
    class queries VTK renderer rather than open_gl state in order to
    support VTK's gradient background.
    
    this is not intended to be shared. each object should use it's own
    instance of this class. it's intended to be called once per render.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkBackgroundColorMonitor, obj, update, **traits)
    
    def state_changed(self, *args):
        """
        V.state_changed(Renderer) -> bool
        C++: bool StateChanged(Renderer *ren)
        Fetches the current background color state and updates the
        internal copies of the data. returns true if any of the tracked
        colors or modes have changed. Typically this is the only function
        a user needs to call.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.StateChanged, *my_args)
        return ret

    def update(self, *args):
        """
        V.update(Renderer)
        C++: void Update(Renderer *ren)
        Update the internal state if anything changed. Note, this is done
        automatically in sate_changed.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Update, *my_args)
        return ret

    _updateable_traits_ = \
    (('reference_count', 'GetReferenceCount'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'))
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(BackgroundColorMonitor, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit BackgroundColorMonitor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], []),
            title='Edit BackgroundColorMonitor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit BackgroundColorMonitor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

