# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.painter_poly_data_mapper import PainterPolyDataMapper


class CompositePolyDataMapper2(PainterPolyDataMapper):
    """
    CompositePolyDataMapper2 - mapper for composite dataset consisting
    
    Superclass: PainterPolyDataMapper
    
    CompositePolyDataMapper2 is similar to CompositePolyDataMapper
    except that instead of creating individual mapper for each block in
    the composite dataset, it iterates over the blocks internally.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCompositePolyDataMapper2, obj, update, **traits)
    
    def _get_composite_data_display_attributes(self):
        return wrap_vtk(self._vtk_obj.GetCompositeDataDisplayAttributes())
    def _set_composite_data_display_attributes(self, arg):
        old_val = self._get_composite_data_display_attributes()
        self._wrap_call(self._vtk_obj.SetCompositeDataDisplayAttributes,
                        deref_vtk(arg))
        self.trait_property_changed('composite_data_display_attributes', old_val, arg)
    composite_data_display_attributes = traits.Property(_get_composite_data_display_attributes, _set_composite_data_display_attributes, help=\
        """
        Set/get the composite data set attributes.
        """
    )

    def get_block_opacity(self, *args):
        """
        V.get_block_opacity(int) -> float
        C++: double GetBlockOpacity(unsigned int index)
        Set/get the opacity for a block given its flat index.
        """
        ret = self._wrap_call(self._vtk_obj.GetBlockOpacity, *args)
        return ret

    def set_block_opacity(self, *args):
        """
        V.set_block_opacity(int, float)
        C++: void SetBlockOpacity(unsigned int index, double opacity)
        Set/get the opacity for a block given its flat index.
        """
        ret = self._wrap_call(self._vtk_obj.SetBlockOpacity, *args)
        return ret

    def get_block_visibility(self, *args):
        """
        V.get_block_visibility(int) -> bool
        C++: bool GetBlockVisibility(unsigned int index)
        Set/get the visibility for a block given its flat index.
        """
        ret = self._wrap_call(self._vtk_obj.GetBlockVisibility, *args)
        return ret

    def set_block_visibility(self, *args):
        """
        V.set_block_visibility(int, bool)
        C++: void SetBlockVisibility(unsigned int index, bool visible)
        Set/get the visibility for a block given its flat index.
        """
        ret = self._wrap_call(self._vtk_obj.SetBlockVisibility, *args)
        return ret

    def get_block_color(self, *args):
        """
        V.get_block_color(int) -> (float, ...)
        C++: double *GetBlockColor(unsigned int index)
        Set/get the color for a block given its flat index.
        """
        ret = self._wrap_call(self._vtk_obj.GetBlockColor, *args)
        return ret

    def set_block_color(self, *args):
        """
        V.set_block_color(int, [float, float, float])
        C++: void SetBlockColor(unsigned int index, double color[3])
        V.set_block_color(int, float, float, float)
        C++: void SetBlockColor(unsigned int index, double r, double g,
            double b)
        Set/get the color for a block given its flat index.
        """
        ret = self._wrap_call(self._vtk_obj.SetBlockColor, *args)
        return ret

    def remove_block_color(self, *args):
        """
        V.remove_block_color(int)
        C++: void RemoveBlockColor(unsigned int index)
        Set/get the color for a block given its flat index.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveBlockColor, *args)
        return ret

    def remove_block_colors(self):
        """
        V.remove_block_colors()
        C++: void RemoveBlockColors()
        Set/get the color for a block given its flat index.
        """
        ret = self._vtk_obj.RemoveBlockColors()
        return ret
        

    def remove_block_opacities(self):
        """
        V.remove_block_opacities()
        C++: void RemoveBlockOpacities()
        Set/get the opacity for a block given its flat index.
        """
        ret = self._vtk_obj.RemoveBlockOpacities()
        return ret
        

    def remove_block_opacity(self, *args):
        """
        V.remove_block_opacity(int)
        C++: void RemoveBlockOpacity(unsigned int index)
        Set/get the opacity for a block given its flat index.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveBlockOpacity, *args)
        return ret

    def remove_block_visibilites(self):
        """
        V.remove_block_visibilites()
        C++: void RemoveBlockVisibilites()
        Set/get the visibility for a block given its flat index.
        """
        ret = self._vtk_obj.RemoveBlockVisibilites()
        return ret
        

    def remove_block_visibility(self, *args):
        """
        V.remove_block_visibility(int)
        C++: void RemoveBlockVisibility(unsigned int index)
        Set/get the visibility for a block given its flat index.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveBlockVisibility, *args)
        return ret

    _updateable_traits_ = \
    (('immediate_mode_rendering', 'GetImmediateModeRendering'),
    ('resolve_coincident_topology_polygon_offset_faces',
    'GetResolveCoincidentTopologyPolygonOffsetFaces'), ('scalar_mode',
    'GetScalarMode'), ('debug', 'GetDebug'), ('static', 'GetStatic'),
    ('resolve_coincident_topology', 'GetResolveCoincidentTopology'),
    ('force_compile_only', 'GetForceCompileOnly'),
    ('resolve_coincident_topology_z_shift',
    'GetResolveCoincidentTopologyZShift'), ('ghost_level',
    'GetGhostLevel'), ('scalar_visibility', 'GetScalarVisibility'),
    ('field_data_tuple_id', 'GetFieldDataTupleId'), ('color_mode',
    'GetColorMode'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('interpolate_scalars_before_mapping',
    'GetInterpolateScalarsBeforeMapping'), ('progress_text',
    'GetProgressText'), ('global_immediate_mode_rendering',
    'GetGlobalImmediateModeRendering'), ('use_lookup_table_scalar_range',
    'GetUseLookupTableScalarRange'), ('abort_execute', 'GetAbortExecute'),
    ('number_of_sub_pieces', 'GetNumberOfSubPieces'),
    ('scalar_material_mode', 'GetScalarMaterialMode'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('reference_count',
    'GetReferenceCount'), ('progress', 'GetProgress'), ('piece',
    'GetPiece'), ('number_of_pieces', 'GetNumberOfPieces'),
    ('scalar_range', 'GetScalarRange'), ('render_time', 'GetRenderTime'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_immediate_mode_rendering',
    'global_warning_display', 'immediate_mode_rendering',
    'interpolate_scalars_before_mapping', 'release_data_flag',
    'scalar_visibility', 'static', 'use_lookup_table_scalar_range',
    'color_mode', 'resolve_coincident_topology', 'scalar_material_mode',
    'scalar_mode', 'field_data_tuple_id', 'force_compile_only',
    'ghost_level', 'number_of_pieces', 'number_of_sub_pieces', 'piece',
    'progress_text', 'render_time',
    'resolve_coincident_topology_polygon_offset_faces',
    'resolve_coincident_topology_z_shift', 'scalar_range'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CompositePolyDataMapper2, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit CompositePolyDataMapper2 properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['global_immediate_mode_rendering',
            'immediate_mode_rendering', 'interpolate_scalars_before_mapping',
            'scalar_visibility', 'static', 'use_lookup_table_scalar_range'],
            ['color_mode', 'resolve_coincident_topology', 'scalar_material_mode',
            'scalar_mode'], ['field_data_tuple_id', 'force_compile_only',
            'ghost_level', 'number_of_pieces', 'number_of_sub_pieces', 'piece',
            'render_time', 'resolve_coincident_topology_polygon_offset_faces',
            'resolve_coincident_topology_z_shift', 'scalar_range']),
            title='Edit CompositePolyDataMapper2 properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CompositePolyDataMapper2 properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

