# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.unstructured_grid_algorithm import UnstructuredGridAlgorithm


class DataSetTriangleFilter(UnstructuredGridAlgorithm):
    """
    DataSetTriangleFilter - triangulate any type of dataset
    
    Superclass: UnstructuredGridAlgorithm
    
    DataSetTriangleFilter generates n-dimensional simplices from any
    input dataset. That is, 3d cells are converted to tetrahedral meshes,
    2d cells to triangles, and so on. The triangulation is guaranteed to
    be compatible.
    
    This filter uses simple 1d and 2d triangulation techniques for cells
    that are of topological dimension 2 or less. For 3d cells--due to the
    issue of face compatibility across quadrilateral faces (which way to
    orient the diagonal?)--a fancier ordered Delaunay triangulation is
    used. This approach produces templates on the fly for triangulating
    the cells. The templates are then used to do the actual
    triangulation.
    
    See Also:
    
    OrderedTriangulator TriangleFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDataSetTriangleFilter, obj, update, **traits)
    
    tetrahedra_only = tvtk_base.false_bool_trait(help=\
        """
        When On this filter will cull all 1d and 2d cells from the
        output. The default is Off.
        """
    )
    def _tetrahedra_only_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTetrahedraOnly,
                        self.tetrahedra_only_)

    _updateable_traits_ = \
    (('global_warning_display', 'GetGlobalWarningDisplay'),
    ('progress_text', 'GetProgressText'), ('debug', 'GetDebug'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('reference_count', 'GetReferenceCount'),
    ('progress', 'GetProgress'), ('tetrahedra_only', 'GetTetrahedraOnly'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'tetrahedra_only', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DataSetTriangleFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit DataSetTriangleFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['tetrahedra_only'], [], []),
            title='Edit DataSetTriangleFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DataSetTriangleFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

