# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

class DenseArray(tvtk_base.TVTKBase):
    """
    DenseArray - Contiguous storage for N-way arrays.
    
    Superclass: TypedArray[T]
    
    DenseArray is a concrete Array implementation that stores
    values using a contiguous block of memory.  Values are stored with
    fortran ordering, meaning that if you iterated over the memory block,
    the left-most coordinates would vary the fastest.
    
    In addition to the retrieval and update methods provided by
    TypedArray, DenseArray provides methods to:
    
    Fill the entire array with a specific value.
    
    Retrieve a pointer to the storage memory block.
    
    See Also:
    
    Array, TypedArray, SparseArray
    
    Thanks:
    
    Developed by Timothy M. Shead (tshead@sandia.gov) at Sandia National
    Laboratories.
    
    
    Provided Types:
    
      DenseArray[char] => DenseArray<char>
      DenseArray[int8] => DenseArray<signed char>
      DenseArray[uint8] => DenseArray<unsigned char>
      DenseArray[int16] => DenseArray<short>
      DenseArray[uint16] => DenseArray<unsigned short>
      DenseArray[int32] => DenseArray<int>
      DenseArray[uint32] => DenseArray<unsigned int>
      DenseArray[int] => DenseArray<long>
      DenseArray[uint] => DenseArray<unsigned long>
      DenseArray[int64] => DenseArray<long long>
      DenseArray[uint64] => DenseArray<unsigned long long>
      DenseArray[float32] => DenseArray<float>
      DenseArray[float64] => DenseArray<double>
      DenseArray[str] => DenseArray<vtkStdString>
      DenseArray[unicode] => DenseArray<vtkUnicodeString>
      DenseArray[vtkVariant] => DenseArray<vtkVariant>
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDenseArray, obj, update, **traits)
    
    _updateable_traits_ = \
    ()
    
    _full_traitnames_list_ = \
    ([])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DenseArray, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit DenseArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], []),
            title='Edit DenseArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DenseArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

