# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.typed_array__i1_2vtk_std_string_e import TypedArray_I12vtkStdStringE


class DenseArray_I12vtkStdStringE(TypedArray_I12vtkStdStringE):
    """
    DenseArray - Contiguous storage for N-way arrays.
    
    Superclass: TypedArray[str]
    
    DenseArray is a concrete Array implementation that stores
    values using a contiguous block of memory.  Values are stored with
    fortran ordering, meaning that if you iterated over the memory block,
    the left-most coordinates would vary the fastest.
    
    In addition to the retrieval and update methods provided by
    TypedArray, DenseArray provides methods to:
    
    Fill the entire array with a specific value.
    
    Retrieve a pointer to the storage memory block.
    
    See Also:
    
    Array, TypedArray, SparseArray
    
    Thanks:
    
    Developed by Timothy M. Shead (tshead@sandia.gov) at Sandia National
    Laboratories.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDenseArray_I12vtkStdStringE, obj, update, **traits)
    
    value_n = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), help=\
        """
        
        """
    )
    def _value_n_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetValueN,
                        self.value_n)

    value = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), help=\
        """
        
        """
    )
    def _value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetValue,
                        self.value)

    def fill(self, *args):
        """
        V.fill(string)
        C++: void Fill(const StdString &value)
        Fills every element in the array with the given value.
        """
        ret = self._wrap_call(self._vtk_obj.Fill, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('value_n', 'GetValueN'), ('dimension_label',
    'GetDimensionLabel'), ('name', 'GetName'), ('reference_count',
    'GetReferenceCount'), ('value', 'GetValue'),
    ('global_warning_display', 'GetGlobalWarningDisplay'))
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'dimension_label', 'name',
    'value', 'value_n'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DenseArray_I12vtkStdStringE, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit DenseArray_I12vtkStdStringE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], ['dimension_label', 'name', 'value',
            'value_n']),
            title='Edit DenseArray_I12vtkStdStringE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DenseArray_I12vtkStdStringE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

