# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.typed_array__il_e import TypedArray_IlE


class DenseArray_IlE(TypedArray_IlE):
    """
    DenseArray - Contiguous storage for N-way arrays.
    
    Superclass: TypedArray[int]
    
    DenseArray is a concrete Array implementation that stores
    values using a contiguous block of memory.  Values are stored with
    fortran ordering, meaning that if you iterated over the memory block,
    the left-most coordinates would vary the fastest.
    
    In addition to the retrieval and update methods provided by
    TypedArray, DenseArray provides methods to:
    
    Fill the entire array with a specific value.
    
    Retrieve a pointer to the storage memory block.
    
    See Also:
    
    Array, TypedArray, SparseArray
    
    Thanks:
    
    Developed by Timothy M. Shead (tshead@sandia.gov) at Sandia National
    Laboratories.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDenseArray_IlE, obj, update, **traits)
    
    def get_value_n(self, *args):
        """
        V.get_value_n(int) -> int
        C++: const long &GetValueN(const SizeT n)"""
        ret = self._wrap_call(self._vtk_obj.GetValueN, *args)
        return ret

    def set_value_n(self, *args):
        """
        V.set_value_n(int, int)
        C++: void SetValueN(const SizeT n, const long &value)"""
        ret = self._wrap_call(self._vtk_obj.SetValueN, *args)
        return ret

    def get_value(self, *args):
        """
        V.get_value(int) -> int
        C++: const long &GetValue(CoordinateT i)
        V.get_value(int, int) -> int
        C++: const long &GetValue(CoordinateT i, CoordinateT j)
        V.get_value(int, int, int) -> int
        C++: const long &GetValue(CoordinateT i, CoordinateT j,
            CoordinateT k)
        V.get_value(ArrayCoordinates) -> int
        C++: const long &GetValue(const ArrayCoordinates &coordinates)"""
        my_args = deref_array(args, [['int'], ('int', 'int'), ('int', 'int', 'int'), ['vtkArrayCoordinates']])
        ret = self._wrap_call(self._vtk_obj.GetValue, *my_args)
        return ret

    def set_value(self, *args):
        """
        V.set_value(int, int)
        C++: void SetValue(CoordinateT i, const long &value)
        V.set_value(int, int, int)
        C++: void SetValue(CoordinateT i, CoordinateT j,
            const long &value)
        V.set_value(int, int, int, int)
        C++: void SetValue(CoordinateT i, CoordinateT j, CoordinateT k,
            const long &value)
        V.set_value(ArrayCoordinates, int)
        C++: void SetValue(const ArrayCoordinates &coordinates,
            const long &value)"""
        my_args = deref_array(args, [('int', 'int'), ('int', 'int', 'int'), ('int', 'int', 'int', 'int'), ('vtkArrayCoordinates', 'int')])
        ret = self._wrap_call(self._vtk_obj.SetValue, *my_args)
        return ret

    def _get_storage(self):
        return self._vtk_obj.GetStorage()
    storage = traits.Property(_get_storage, help=\
        """
        Returns a mutable reference to the underlying storage.  Values
        are stored contiguously with fortran ordering.  Use at your own
        risk!
        """
    )

    def fill(self, *args):
        """
        V.fill(int)
        C++: void Fill(const long &value)
        Fills every element in the array with the given value.
        """
        ret = self._wrap_call(self._vtk_obj.Fill, *args)
        return ret

    _updateable_traits_ = \
    (('reference_count', 'GetReferenceCount'), ('debug', 'GetDebug'),
    ('dimension_label', 'GetDimensionLabel'), ('name', 'GetName'),
    ('global_warning_display', 'GetGlobalWarningDisplay'))
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'dimension_label', 'name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DenseArray_IlE, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit DenseArray_IlE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], ['dimension_label', 'name']),
            title='Edit DenseArray_IlE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DenseArray_IlE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

