# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.dijkstra_graph_geodesic_path import DijkstraGraphGeodesicPath


class DijkstraImageGeodesicPath(DijkstraGraphGeodesicPath):
    """
    DijkstraImageGeodesicPath - Dijkstra algorithm to compute the
    graph geodesic.
    
    Superclass: DijkstraGraphGeodesicPath
    
    Takes as input a polyline and an image representing a 2d cost
    function and performs a single source shortest path calculation.
    Dijkstra's algorithm is used. The implementation is similar to the
    one described in Introduction to Algorithms (Second Edition) by
    Thomas H. Cormen, Charles E. Leiserson, Ronald L. Rivest, and Cliff
    Stein, published by MIT Press and mc_graw-_hill. Some minor enhancement
    are added though. All vertices are not pushed on the heap at start,
    instead a front set is maintained. The heap is implemented as a
    binary heap. The output of the filter is a set of lines describing
    the shortest path from start_vertex to end_vertex.  See parent class
    DijkstraGraphGeodesicPath for the implementation.
    
    Caveats:
    
    The input cost image must have only VTK_PIXEL cells: i.e., a 2d image
    or slice of a 3d volume. A cost function for a gray scale image might
    be generated by the following pipeline:
    ImageData->vtkImageGradientMagnitude->vtkImageShiftScale wherein
    the gradient magnitude image is inverted so that strong edges have
    low cost value.  Costs in moving from a vertex v to a vertex u are
    calculated using a weighted additive sheme: cost = Iw*f(I) +
    Ew*f(u,v) + Cw*f(t,u,v) where Iw is the weight associated with f(I):
    the normalized image cost, Ew is the weight associated with f(u,v):
    the normalized distance between vertices u and v, and Cw is the
    weight associated with f(t,u,v): the normalized curvature calculated
    from the vertex t which precedes vertex u, and vertices u and v.  All
    weights range from 0 to 1.
    
    Thanks:
    
    The class was contributed by Dean Inglis.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDijkstraImageGeodesicPath, obj, update, **traits)
    
    image_weight = traits.Float(1.0, enter_set=True, auto_set=False, help=\
        """
        Image cost weight.
        """
    )
    def _image_weight_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetImageWeight,
                        self.image_weight)

    edge_length_weight = traits.Float(0.0, enter_set=True, auto_set=False, help=\
        """
        Edge length cost weight.
        """
    )
    def _edge_length_weight_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEdgeLengthWeight,
                        self.edge_length_weight)

    curvature_weight = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), help=\
        """
        Curvature cost weight.
        """
    )
    def _curvature_weight_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCurvatureWeight,
                        self.curvature_weight)

    def _get_input_as_image_data(self):
        return wrap_vtk(self._vtk_obj.GetInputAsImageData())
    input_as_image_data = traits.Property(_get_input_as_image_data, help=\
        """
        Specify the image object which is used as a cost function.
        """
    )

    _updateable_traits_ = \
    (('global_warning_display', 'GetGlobalWarningDisplay'),
    ('image_weight', 'GetImageWeight'), ('debug', 'GetDebug'),
    ('stop_when_end_reached', 'GetStopWhenEndReached'), ('progress_text',
    'GetProgressText'), ('end_vertex', 'GetEndVertex'),
    ('repel_path_from_vertices', 'GetRepelPathFromVertices'),
    ('use_scalar_weights', 'GetUseScalarWeights'), ('curvature_weight',
    'GetCurvatureWeight'), ('abort_execute', 'GetAbortExecute'),
    ('start_vertex', 'GetStartVertex'), ('release_data_flag',
    'GetReleaseDataFlag'), ('reference_count', 'GetReferenceCount'),
    ('progress', 'GetProgress'), ('edge_length_weight',
    'GetEdgeLengthWeight'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'repel_path_from_vertices',
    'stop_when_end_reached', 'use_scalar_weights', 'curvature_weight',
    'edge_length_weight', 'end_vertex', 'image_weight', 'progress_text',
    'start_vertex'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DijkstraImageGeodesicPath, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit DijkstraImageGeodesicPath properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['repel_path_from_vertices', 'stop_when_end_reached',
            'use_scalar_weights'], [], ['curvature_weight', 'edge_length_weight',
            'end_vertex', 'image_weight', 'start_vertex']),
            title='Edit DijkstraImageGeodesicPath properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DijkstraImageGeodesicPath properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

