# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.writer import Writer


class EnSightWriter(Writer):
    """
    EnSightWriter - write vtk unstructured grid data as an en_sight file
    
    Superclass: Writer
    
    EnSightWriter is a source object that writes binary unstructured
    grid data files in en_sight format. See en_sight Manual for format
    details
    
    Caveats:
    
    Binary files written on one system may not be readable on other
    systems. Be sure to specify the endian-ness of the file when reading
    it into en_sight
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkEnSightWriter, obj, update, **traits)
    
    number_of_blocks = traits.Int(0, enter_set=True, auto_set=False, help=\
        """
        
        """
    )
    def _number_of_blocks_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfBlocks,
                        self.number_of_blocks)

    process_number = traits.Int(0, enter_set=True, auto_set=False, help=\
        """
        
        """
    )
    def _process_number_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetProcessNumber,
                        self.process_number)

    time_step = traits.Int(0, enter_set=True, auto_set=False, help=\
        """
        
        """
    )
    def _time_step_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTimeStep,
                        self.time_step)

    base_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), help=\
        """
        Specify base name of en_sight data files to write.
        """
    )
    def _base_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBaseName,
                        self.base_name)

    file_name = tvtk_base.vtk_file_name("", help=\
        """
        Specify the path and base name of the output files.
        """
    )
    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    transient_geometry = traits.Bool(False, help=\
        """
        
        """
    )
    def _transient_geometry_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTransientGeometry,
                        self.transient_geometry)

    path = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), help=\
        """
        Specify path of en_sight data files to write.
        """
    )
    def _path_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPath,
                        self.path)

    def _get_block_i_ds(self):
        return self._vtk_obj.GetBlockIDs()
    def _set_block_i_ds(self, arg):
        old_val = self._get_block_i_ds()
        self._wrap_call(self._vtk_obj.SetBlockIDs,
                        arg)
        self.trait_property_changed('block_i_ds', old_val, arg)
    block_i_ds = traits.Property(_get_block_i_ds, _set_block_i_ds, help=\
        """
        
        """
    )

    ghost_level = traits.Int(0, enter_set=True, auto_set=False, help=\
        """
        
        """
    )
    def _ghost_level_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGhostLevel,
                        self.ghost_level)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, help=\
        """
        Specify the input data or filter.
        """
    )

    def write_case_file(self, *args):
        """
        V.write_case_file(int)
        C++: virtual void WriteCaseFile(int TotalTimeSteps)"""
        ret = self._wrap_call(self._vtk_obj.WriteCaseFile, *args)
        return ret

    def write_sos_case_file(self, *args):
        """
        V.write_sos_case_file(int)
        C++: virtual void WriteSOSCaseFile(int NumProcs)"""
        ret = self._wrap_call(self._vtk_obj.WriteSOSCaseFile, *args)
        return ret

    _updateable_traits_ = \
    (('global_warning_display', 'GetGlobalWarningDisplay'), ('base_name',
    'GetBaseName'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('file_name', 'GetFileName'), ('time_step', 'GetTimeStep'),
    ('transient_geometry', 'GetTransientGeometry'), ('progress_text',
    'GetProgressText'), ('debug', 'GetDebug'), ('abort_execute',
    'GetAbortExecute'), ('number_of_blocks', 'GetNumberOfBlocks'),
    ('progress', 'GetProgress'), ('reference_count', 'GetReferenceCount'),
    ('ghost_level', 'GetGhostLevel'), ('path', 'GetPath'),
    ('process_number', 'GetProcessNumber'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'base_name', 'file_name', 'ghost_level',
    'number_of_blocks', 'path', 'process_number', 'progress_text',
    'time_step', 'transient_geometry'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(EnSightWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit EnSightWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], ['base_name', 'file_name', 'ghost_level',
            'number_of_blocks', 'path', 'process_number', 'time_step',
            'transient_geometry']),
            title='Edit EnSightWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit EnSightWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

