# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.extract_unstructured_grid_piece import ExtractUnstructuredGridPiece


class ExtractUserDefinedPiece(ExtractUnstructuredGridPiece):
    """
    ExtractUserDefinedPiece - Return user specified piece with ghost
    cells
    
    Superclass: ExtractUnstructuredGridPiece
    
    Provided a function that determines which cells are zero-level cells
    ("the piece"), this class outputs the piece with the requested number
    of ghost levels.  The only difference between this class and the
    class it is derived from is that the zero-level cells are specified
    by a function you provide, instead of determined by dividing up the
    cells based on cell Id.
    
    See Also:
    
    ExtractUnstructuredGridPiece
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkExtractUserDefinedPiece, obj, update, **traits)
    
    def set_constant_data(self, *args):
        """
        V.set_constant_data(, int)
        C++: void SetConstantData(void *data, int len)"""
        ret = self._wrap_call(self._vtk_obj.SetConstantData, *args)
        return ret

    _updateable_traits_ = \
    (('global_warning_display', 'GetGlobalWarningDisplay'),
    ('progress_text', 'GetProgressText'), ('create_ghost_cells',
    'GetCreateGhostCells'), ('debug', 'GetDebug'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('reference_count', 'GetReferenceCount'), ('progress', 'GetProgress'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'create_ghost_cells', 'debug',
    'global_warning_display', 'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ExtractUserDefinedPiece, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit ExtractUserDefinedPiece properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['create_ghost_cells'], [], []),
            title='Edit ExtractUserDefinedPiece properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ExtractUserDefinedPiece properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

