# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.polygonal_handle_representation3d import PolygonalHandleRepresentation3D


class FixedSizeHandleRepresentation3D(PolygonalHandleRepresentation3D):
    """
    FixedSizeHandleRepresentation - A marker that has the same size in
    pixels.
    
    Superclass: PolygonalHandleRepresentation3D
    
    This class is a concrete implementation of HandleRepresentation.
    It is meant to be used as a representation for HandleWidget.
    Unlike the other represenations, this can maintain a constant size in
    pixels, regardless of the camera zoom parameters. The size in pixels
    may be set via set_handle_size_in_pixels. This representation renders the
    markers as spherical blobs in 3d space with the width as specified
    above, defaults to 10 pixels. The handles will have the same size in
    pixels, give or take a certain tolerance, as specified by
    set_handle_size_tolerance_in_pixels. The tolerance defaults to half a
    pixel. point_placers may be used to specify constraints on the
    placement of markers. For instance a PolygonalSurfacePointPlacer
    will constrain placement of these spherical handles to a surface
    mesh.
    
    See Also:
    
    HandleRepresentation HandleWidget
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkFixedSizeHandleRepresentation3D, obj, update, **traits)
    
    handle_size_tolerance_in_pixels = traits.Float(0.5, enter_set=True, auto_set=False, help=\
        """
        Specify the acceptable handle size tolerance. During each render,
        the handle 3d source will be updated to automatically match a
        display size as specified by handle_size_in_pixels. This update will
        be done if the handle size is larger than a tolerance. Default
        value of this tolerance is half a pixel.
        """
    )
    def _handle_size_tolerance_in_pixels_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHandleSizeToleranceInPixels,
                        self.handle_size_tolerance_in_pixels)

    handle_size_in_pixels = traits.Float(10.0, enter_set=True, auto_set=False, help=\
        """
        Set/Get the required handle size in pixels. Defaults to a width
        of 10 pixels.
        """
    )
    def _handle_size_in_pixels_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHandleSizeInPixels,
                        self.handle_size_in_pixels)

    def _get_sphere_source(self):
        return wrap_vtk(self._vtk_obj.GetSphereSource())
    sphere_source = traits.Property(_get_sphere_source, help=\
        """
        Get the object used to render the spherical handle marker
        """
    )

    _updateable_traits_ = \
    (('display_position', 'GetDisplayPosition'), ('active_representation',
    'GetActiveRepresentation'), ('handle_size', 'GetHandleSize'),
    ('need_to_render', 'GetNeedToRender'), ('dragable', 'GetDragable'),
    ('visibility', 'GetVisibility'), ('debug', 'GetDebug'),
    ('smooth_motion', 'GetSmoothMotion'), ('offset', 'GetOffset'),
    ('render_time_multiplier', 'GetRenderTimeMultiplier'),
    ('place_factor', 'GetPlaceFactor'), ('constrained', 'GetConstrained'),
    ('use_bounds', 'GetUseBounds'), ('handle_size_tolerance_in_pixels',
    'GetHandleSizeToleranceInPixels'), ('handle_visibility',
    'GetHandleVisibility'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('estimated_render_time',
    'GetEstimatedRenderTime'), ('world_position', 'GetWorldPosition'),
    ('label_visibility', 'GetLabelVisibility'), ('picking_managed',
    'GetPickingManaged'), ('label_text', 'GetLabelText'),
    ('label_text_scale', 'GetLabelTextScale'), ('reference_count',
    'GetReferenceCount'), ('pickable', 'GetPickable'), ('tolerance',
    'GetTolerance'), ('handle_size_in_pixels', 'GetHandleSizeInPixels'))
    
    _full_traitnames_list_ = \
    (['active_representation', 'constrained', 'debug', 'dragable',
    'global_warning_display', 'handle_visibility', 'label_visibility',
    'need_to_render', 'pickable', 'picking_managed', 'smooth_motion',
    'use_bounds', 'visibility', 'display_position',
    'estimated_render_time', 'handle_size', 'handle_size_in_pixels',
    'handle_size_tolerance_in_pixels', 'label_text', 'label_text_scale',
    'offset', 'place_factor', 'render_time_multiplier', 'tolerance',
    'world_position'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(FixedSizeHandleRepresentation3D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit FixedSizeHandleRepresentation3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['active_representation', 'constrained',
            'handle_visibility', 'label_visibility', 'need_to_render',
            'picking_managed', 'smooth_motion', 'use_bounds', 'visibility'], [],
            ['display_position', 'estimated_render_time', 'handle_size',
            'handle_size_in_pixels', 'handle_size_tolerance_in_pixels',
            'label_text', 'label_text_scale', 'offset', 'place_factor',
            'render_time_multiplier', 'tolerance', 'world_position']),
            title='Edit FixedSizeHandleRepresentation3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit FixedSizeHandleRepresentation3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

