# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.object import Object


class GhostArray(Object):
    """
    GhostArray.h -- Encodes/Decodes ghost array information.
    
    Superclass: Object
    
    GhostArray provides functionality for manipulating a mesh entity
     property field, represented by an "unsigned char". Each mesh entity,
    e.g.,
     a vertex or cell is associated with an "unsigned char" where each
    individual
     bit represents the state of a particular property. This class
    provides
     the logic required to manipulate individual bits in the "unsigned
    char".
    
    Caveats:
    
    
     Since an unsigned char is used to represent a mesh entity property
    field, we
     are restricted to at most 8 properties, i.e., [0-7] that can be used
    to
     designate different states.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGhostArray, obj, update, **traits)
    
    def is_property_set(self, *args):
        """
        V.is_property_set(int, int) -> bool
        C++: static bool IsPropertySet(unsigned char &propertyField,
            const int property)
        Checks if a property is set in the given property field.
        """
        ret = self._wrap_call(self._vtk_obj.IsPropertySet, *args)
        return ret

    def reset(self, *args):
        """
        V.reset(int)
        C++: static void Reset(unsigned char &propertyField)
        Resets all the bits in the property field
        """
        ret = self._wrap_call(self._vtk_obj.Reset, *args)
        return ret

    def set_property(self, *args):
        """
        V.set_property(int, int)
        C++: static void SetProperty(unsigned char &propertyField,
            const int property)
        Sets the given property in the property_field.
        """
        ret = self._wrap_call(self._vtk_obj.SetProperty, *args)
        return ret

    def unset_property(self, *args):
        """
        V.unset_property(int, int)
        C++: static void UnsetProperty(unsigned char &propertyField,
            const int property)
        Unsets the property from the given property_field.
        """
        ret = self._wrap_call(self._vtk_obj.UnsetProperty, *args)
        return ret

    _updateable_traits_ = \
    (('reference_count', 'GetReferenceCount'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'))
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GhostArray, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit GhostArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], []),
            title='Edit GhostArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GhostArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

