# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.object import Object


class GL2PSUtilities(Object):
    """
    GL2PSUtilities - Helper functions for using gl2ps within VTK
    
    Superclass: Object
    
    GL2PSUtilities implements some static helper function that
    simplify calling gl2ps routines on VTK objects. This class is meant
    for internal use only and is subject to change.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGL2PSUtilities, obj, update, **traits)
    
    def _get_line_width_factor(self):
        return self._vtk_obj.GetLineWidthFactor()
    line_width_factor = traits.Property(_get_line_width_factor, help=\
        """
        Get a scaling factor for the point size or line width used by
        gl2ps. Default value: 5/7.
        """
    )

    def _get_point_size_factor(self):
        return self._vtk_obj.GetPointSizeFactor()
    point_size_factor = traits.Property(_get_point_size_factor, help=\
        """
        Get a scaling factor for the point size or line width used by
        gl2ps. Default value: 5/7.
        """
    )

    def _get_render_window(self):
        return wrap_vtk(self._vtk_obj.GetRenderWindow())
    render_window = traits.Property(_get_render_window, help=\
        """
        Get the current render_window that is being exported
        """
    )

    def _get_text_as_path(self):
        return self._vtk_obj.GetTextAsPath()
    text_as_path = traits.Property(_get_text_as_path, help=\
        """
        Get whether all text will be exported as paths.
        """
    )

    def draw3d_path(self, *args):
        """
        V.draw3d_path(Path, Matrix4x4, [float, float, float], [int,
            int, int, int], string)
        C++: static void Draw3DPath(Path *path,
            Matrix4x4 *actorMatrix, double rasterPos[3],
            unsigned char actorColor[4], const char *label=NULL)
        Transform the path using the actor's matrix and current GL state,
        then draw it to gl2ps. The label string is inserted into the
        gl2ps output at the beginning of the path specification as a
        comment on supported backends.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Draw3DPath, *my_args)
        return ret

    def draw_path(self, *args):
        """
        V.draw_path(Path, [float, float, float], [float, float], [int,
            int, int, int], [float, float], float, float, string)
        C++: static void DrawPath(Path *path, double rasterPos[3],
            double windowPos[2], unsigned char rgba[4],
            double scale[2]=NULL, double rotateAngle=0.0,
            float strokeWidth=-1, const char *label=NULL)
        Generate PS, EPS, or SVG markup from a Path object, and then
        inject it into the output using the gl_2ps_special command. The
        path is translated uniformly in the scene by window_pos. It is
        scaled by scale and rotated counter-clockwise by rotate_angle. The
        raster_pos is in world coordinates and determines clipping and
        depth. If scale is NULL, no scaling is done. If stroke_width is
        positive, the path will be stroked with the indicated width. If
        zero or negative, the path will be filled (default). The label
        string is inserted into the gl2ps output at the beginning of the
        path specification as a comment on supported backends.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DrawPath, *my_args)
        return ret

    def draw_string(self, *args):
        """
        V.draw_string(string, TextProperty, [float, float, float],
            float)
        C++: static void DrawString(const char *str,
            TextProperty *tprop, double pos[3], double backgroundDepth)
        Format the text in str according to tprop and instruct gl2ps to
        draw it at world coordinate pos. Background depth is the z value
        for the background quad, and should be in NDC space.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DrawString, *my_args)
        return ret

    def text_property_to_gl2ps_alignment(self, *args):
        """
        V.text_property_to_gl2ps_alignment(TextProperty) -> int
        C++: static int TextPropertyToGL2PSAlignment(
            TextProperty *tprop)
        Convert the alignment hint in tprop to a gl2ps text alignment
        constant.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TextPropertyToGL2PSAlignment, *my_args)
        return ret

    def text_property_to_ps_font_name(self, *args):
        """
        V.text_property_to_ps_font_name(TextProperty) -> string
        C++: static const char *TextPropertyToPSFontName(
            TextProperty *tprop)
        Translate the tprop's fontname into a Postscript font name.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TextPropertyToPSFontName, *my_args)
        return ret

    _updateable_traits_ = \
    (('reference_count', 'GetReferenceCount'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'))
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GL2PSUtilities, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit GL2PSUtilities properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], []),
            title='Edit GL2PSUtilities properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GL2PSUtilities properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

