# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.standard_poly_data_painter import StandardPolyDataPainter


class HardwareSelectionPolyDataPainter(StandardPolyDataPainter):
    """
    HardwareSelectionPolyDataPainter - painter used to render polydata
    
    Superclass: StandardPolyDataPainter
    
    HardwareSelectionPolyDataPainter is a painter for polydata used
    when rendering hardware selection passes.
    
    See Also:
    
    HardwareSelector
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHardwareSelectionPolyDataPainter, obj, update, **traits)
    
    enable_selection = tvtk_base.true_bool_trait(help=\
        """
        Enable/Disable HardwareSelector class. Useful when using this
        painter as an internal painter. Default is enabled.
        """
    )
    def _enable_selection_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnableSelection,
                        self.enable_selection_)

    composite_id_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), help=\
        """
        Generally, CompositePainter can render the composite id when
        iterating over composite datasets. However in some cases (as in
        AMR), the rendered structure may not correspond to the input
        data, in which case we need to provide a cell array that can be
        used to render in the composite id in selection passes. Set to
        NULL (default) to not override the composite id color set by
        CompositePainter if any. The array *MUST* be a cell array and
        of type UnsignedIntArray.
        """
    )
    def _composite_id_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCompositeIdArrayName,
                        self.composite_id_array_name)

    point_id_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), help=\
        """
        By default, this painters uses the dataset's point and cell ids
        during rendering. However, one can override those by specifying
        cell and point data arrays to use instead. Currently, only
        IdType array is supported. Set to NULL string (default) to use
        the point ids instead.
        """
    )
    def _point_id_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPointIdArrayName,
                        self.point_id_array_name)

    cell_id_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), help=\
        """
        By default, this painters uses the dataset's point and cell ids
        during rendering. However, one can override those by specifying
        cell and point data arrays to use instead. Currently, only
        IdType array is supported. Set to NULL string (default) to use
        the point ids instead.
        """
    )
    def _cell_id_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCellIdArrayName,
                        self.cell_id_array_name)

    process_id_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), help=\
        """
        If the painter should override the process id using a data-array,
        set this variable to the name of the array to use. It must be a
        point-array.
        """
    )
    def _process_id_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetProcessIdArrayName,
                        self.process_id_array_name)

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('composite_id_array_name',
    'GetCompositeIdArrayName'), ('process_id_array_name',
    'GetProcessIdArrayName'), ('point_id_array_name',
    'GetPointIdArrayName'), ('reference_count', 'GetReferenceCount'),
    ('progress', 'GetProgress'), ('enable_selection',
    'GetEnableSelection'), ('cell_id_array_name', 'GetCellIdArrayName'),
    ('global_warning_display', 'GetGlobalWarningDisplay'))
    
    _full_traitnames_list_ = \
    (['debug', 'enable_selection', 'global_warning_display',
    'cell_id_array_name', 'composite_id_array_name',
    'point_id_array_name', 'process_id_array_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HardwareSelectionPolyDataPainter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit HardwareSelectionPolyDataPainter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['enable_selection'], [], ['cell_id_array_name',
            'composite_id_array_name', 'point_id_array_name',
            'process_id_array_name']),
            title='Edit HardwareSelectionPolyDataPainter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HardwareSelectionPolyDataPainter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

