# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.statistics_algorithm import StatisticsAlgorithm


class HighestDensityRegionsStatistics(StatisticsAlgorithm):
    """
    HighestDensityRegionsStatistics - Compute a random vector of
    
    Superclass: StatisticsAlgorithm
    
    Given a selection of pairs of columns of interest, this class
    provides the following functionalities, depending on the chosen
    execution options:
    * Learn: calculates density estimator f of a random vector using a
      smooth gaussian kernel. The output metadata on port OUTPUT_MODEL is
    a multiblock dataset containing at one Table holding three columns
    which are for the first columns the input columns of interest and for
    the last columns the density estimators of each input pair of columns
    of interest.
    * Derive: calculate normalized (as a percentage) quantiles coming
      from Learn output. The second block of the multibloc dataset
      contains a Table holding some pairs of columns which are for the
    second one the quantiles ordered from the stronger to the lower and
      for the first one the correspondand quantile index.
    * Assess: not implemented.
    * Test: not implemented.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHighestDensityRegionsStatistics, obj, update, **traits)
    
    smooth_hc2 = traits.Array(shape=(2,), value=(0.0, 1.0), dtype=float, enter_set=True, auto_set=False, cols=3, help=\
        """
        Get Smooth H matrix parameter of the HDR.
        """
    )
    def _smooth_hc2_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSmoothHC2,
                        self.smooth_hc2)

    smooth_hc1 = traits.Array(shape=(2,), value=(1.0, 0.0), dtype=float, enter_set=True, auto_set=False, cols=3, help=\
        """
        Get Smooth H matrix parameter of the HDR.
        """
    )
    def _smooth_hc1_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSmoothHC1,
                        self.smooth_hc1)

    def set_sigma(self, *args):
        """
        V.set_sigma(float)
        C++: void SetSigma(double sigma)
        H is a positive matrix that defines the smooth direction. In a
        classical HDR, we don't set a specific smooth direction for the H
        matrix parameter (_smooth_hc1, smooth_hc2). That mean H will be in a
        diagonal form and equal to sigma * Id.
        """
        ret = self._wrap_call(self._vtk_obj.SetSigma, *args)
        return ret

    _updateable_traits_ = \
    (('assess_option', 'GetAssessOption'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('test_option', 'GetTestOption'),
    ('progress_text', 'GetProgressText'), ('learn_option',
    'GetLearnOption'), ('debug', 'GetDebug'), ('abort_execute',
    'GetAbortExecute'), ('smooth_hc2', 'GetSmoothHC2'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('reference_count',
    'GetReferenceCount'), ('progress', 'GetProgress'),
    ('number_of_primary_tables', 'GetNumberOfPrimaryTables'),
    ('smooth_hc1', 'GetSmoothHC1'), ('derive_option', 'GetDeriveOption'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'assess_option', 'derive_option', 'learn_option',
    'number_of_primary_tables', 'progress_text', 'smooth_hc1',
    'smooth_hc2', 'test_option'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HighestDensityRegionsStatistics, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit HighestDensityRegionsStatistics properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], ['assess_option', 'derive_option',
            'learn_option', 'number_of_primary_tables', 'smooth_hc1',
            'smooth_hc2', 'test_option']),
            title='Edit HighestDensityRegionsStatistics properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HighestDensityRegionsStatistics properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

