# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.image_algorithm import ImageAlgorithm


class ImageDataLIC2D(ImageAlgorithm):
    """
    ImageDataLIC2D
    
    Superclass: ImageAlgorithm
    
    GPU implementation of a Line Integral Convolution, a technique for
     imaging  vector fields.
    
    
     The input on port 0 is an ImageData with extents of a 2d image.
    It needs
     a vector field on point data. This filter only works on point
    vectors. One
     can use a CellDataToPointData filter to convert cell vectors to
    point
     vectors.
    
    
     Port 1 is a special port for customized noise input. It is an
    optional port.
     If noise input is not specified, then the filter using
    ImageNoiseSource to
     generate a 128x128 noise texture.
    
    See Also:
    
    
     SurfaceLICPainter LineIntegralConvolution2D
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImageDataLIC2D, obj, update, **traits)
    
    step_size = traits.Float(1.0, enter_set=True, auto_set=False, help=\
        """
        Step size. Specify the step size as a unit of the cell length of
        the input vector field. Cell lengthh is the length of the
        diagonal of a cell. Initial value is 1.0. class invariant:
        step_size>_0._0. In term of visual quality, the smaller the better.
        The type for the interface is double as VTK interface is double
        but GPU only supports float. This value will be converted to
        float in the execution of the algorithm.
        """
    )
    def _step_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStepSize,
                        self.step_size)

    magnification = traits.Int(1, enter_set=True, auto_set=False, help=\
        """
        The the magnification factor. Default is 1
        """
    )
    def _magnification_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMagnification,
                        self.magnification)

    steps = traits.Int(20, enter_set=True, auto_set=False, help=\
        """
        Number of steps. Initial value is 20. class invariant: Steps>0.
        In term of visual quality, the greater the better.
        """
    )
    def _steps_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSteps,
                        self.steps)

    def _get_context(self):
        return wrap_vtk(self._vtk_obj.GetContext())
    def _set_context(self, arg):
        old_val = self._get_context()
        self._wrap_call(self._vtk_obj.SetContext,
                        deref_vtk(arg))
        self.trait_property_changed('context', old_val, arg)
    context = traits.Property(_get_context, _set_context, help=\
        """
        Get/Set the context. Context must be a OpenGLRenderWindow.
        This does not increase the reference count of the context to
        avoid reference loops. set_context() may raise an error is the
        open_gl context does not support the required open_gl extensions.
        Return 0 upon failure and 1 upon success.
        """
    )

    def _get_open_gl_extensions_supported(self):
        return self._vtk_obj.GetOpenGLExtensionsSupported()
    open_gl_extensions_supported = traits.Property(_get_open_gl_extensions_supported, help=\
        """
        Check if the required open_gl extensions / GPU are supported.
        """
    )

    def translate_input_extent(self, *args):
        """
        V.translate_input_extent((int, ...), (int, ...), [int, ...])
        C++: void TranslateInputExtent(const int *inExt,
            const int *inWholeExtent, int *outExt)"""
        ret = self._wrap_call(self._vtk_obj.TranslateInputExtent, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('magnification', 'GetMagnification'),
    ('step_size', 'GetStepSize'), ('steps', 'GetSteps'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('reference_count',
    'GetReferenceCount'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('abort_execute', 'GetAbortExecute'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'magnification', 'progress_text', 'step_size',
    'steps'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImageDataLIC2D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit ImageDataLIC2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], ['magnification', 'step_size', 'steps']),
            title='Edit ImageDataLIC2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImageDataLIC2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

