# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.abstract_image_interpolator import AbstractImageInterpolator


class ImageInterpolator(AbstractImageInterpolator):
    """
    ImageInterpolator - interpolate data values from images
    
    Superclass: AbstractImageInterpolator
    
    ImageInterpolator provides a simple interface for interpolating
    image data.  It provides linear, cubic, and nearest-neighbor
    interpolation.
    
    Thanks:
    
    Thanks to David Gobbi at the Seaman Family MR Centre and Dept. of
    Clinical Neurosciences, Foothills Medical Centre, Calgary, for
    providing this class.
    
    See also:
    
    ImageReslice
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImageInterpolator, obj, update, **traits)
    
    interpolation_mode = traits.Trait('linear',
    tvtk_base.TraitRevPrefixMap({'nearest': 0, 'linear': 1, 'cubic': 2}), help=\
        """
        The interpolation mode for point scalars (default: linear). 
        Subclasses will provide additional interpolation modes, so this
        is a virtual method.
        """
    )
    def _interpolation_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolationMode,
                        self.interpolation_mode_)

    _updateable_traits_ = \
    (('component_offset', 'GetComponentOffset'), ('out_value',
    'GetOutValue'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('reference_count', 'GetReferenceCount'), ('debug', 'GetDebug'),
    ('component_count', 'GetComponentCount'), ('tolerance',
    'GetTolerance'), ('interpolation_mode', 'GetInterpolationMode'),
    ('border_mode', 'GetBorderMode'))
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'border_mode',
    'interpolation_mode', 'component_count', 'component_offset',
    'out_value', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImageInterpolator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit ImageInterpolator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], ['border_mode', 'interpolation_mode'],
            ['component_count', 'component_offset', 'out_value', 'tolerance']),
            title='Edit ImageInterpolator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImageInterpolator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

