# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.threaded_image_algorithm import ThreadedImageAlgorithm


class ImageResize(ThreadedImageAlgorithm):
    """
    ImageResize - High-quality image resizing filter
    
    Superclass: ThreadedImageAlgorithm
    
    ImageResize will magnify or shrink an image with interpolation and
    antialiasing.  The resizing is done with a 5-lobe Lanczos-windowed
    sinc filter that is bandlimited to the output sampling frequency in
    order to avoid aliasing when the image size is reduced.  This filter
    utilizes a O(n) algorithm to provide good effiency even though the
    filtering kernel is large.  The sinc interpolator can be turned off
    if nearest-neighbor interpolation is required, or it can be replaced
    with a different ImageInterpolator object.
    
    Thanks:
    
    Thanks to David Gobbi for contributing this class to VTK.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImageResize, obj, update, **traits)
    
    cropping = tvtk_base.false_bool_trait(help=\
        """
        Whether to crop the input image before resizing (Off by default).
         If this is On, then the cropping_region must be set.
        """
    )
    def _cropping_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCropping,
                        self.cropping_)

    border = tvtk_base.false_bool_trait(help=\
        """
        If Border is Off (the default), then the centers of each of the
        corner voxels will be considered to form the rectangular bounds
        of the image. This is the way that VTK normally computes image
        bounds.  If Border is On, then the image bounds will be defined
        by the outer corners of the voxels. This setting impacts how the
        resizing is done.  For example, if a magnification_factor of two
        is applied to a 256x256 image, the output image will be 512x512
        if Border is On, or 511x511 if Border is Off.
        """
    )
    def _border_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBorder,
                        self.border_)

    interpolate = tvtk_base.true_bool_trait(help=\
        """
        Turn interpolation on or off (by default, interpolation is on).
        """
    )
    def _interpolate_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolate,
                        self.interpolate_)

    resize_method = traits.Trait('output_dimensions',
    tvtk_base.TraitRevPrefixMap({'output_spacing': 1, 'output_dimensions': 0, 'magnification_factors': 2}), help=\
        """
        The resizing method to use.  The default is to set the output
        image dimensions, and allow the filter to resize the image to
        these new dimensions.  It is also possible to resize the image by
        setting the output image spacing or by setting a magnification
        factor.
        """
    )
    def _resize_method_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetResizeMethod,
                        self.resize_method_)

    cropping_region = traits.Array(shape=(6,), value=(0.0, 1.0, 0.0, 1.0, 0.0, 1.0), dtype=float, enter_set=True, auto_set=False, cols=3, help=\
        """
        
        """
    )
    def _cropping_region_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCroppingRegion,
                        self.cropping_region)

    magnification_factors = traits.Array(shape=(3,), value=(1.0, 1.0, 1.0), dtype=float, enter_set=True, auto_set=False, cols=3, help=\
        """
        
        """
    )
    def _magnification_factors_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMagnificationFactors,
                        self.magnification_factors)

    def _get_interpolator(self):
        return wrap_vtk(self._vtk_obj.GetInterpolator())
    def _set_interpolator(self, arg):
        old_val = self._get_interpolator()
        self._wrap_call(self._vtk_obj.SetInterpolator,
                        deref_vtk(arg))
        self.trait_property_changed('interpolator', old_val, arg)
    interpolator = traits.Property(_get_interpolator, _set_interpolator, help=\
        """
        Set the interpolator for resampling the data.
        """
    )

    output_spacing = traits.Array(shape=(3,), value=(0.0, 0.0, 0.0), dtype=float, enter_set=True, auto_set=False, cols=3, help=\
        """
        
        """
    )
    def _output_spacing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputSpacing,
                        self.output_spacing)

    output_dimensions = traits.Array(shape=(3,), value=(-1, -1, -1), dtype=int, enter_set=True, auto_set=False, cols=3, help=\
        """
        
        """
    )
    def _output_dimensions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputDimensions,
                        self.output_dimensions)

    _updateable_traits_ = \
    (('output_dimensions', 'GetOutputDimensions'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('output_spacing', 'GetOutputSpacing'), ('magnification_factors',
    'GetMagnificationFactors'), ('progress_text', 'GetProgressText'),
    ('resize_method', 'GetResizeMethod'), ('interpolate',
    'GetInterpolate'), ('debug', 'GetDebug'), ('abort_execute',
    'GetAbortExecute'), ('number_of_threads', 'GetNumberOfThreads'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('reference_count',
    'GetReferenceCount'), ('progress', 'GetProgress'), ('cropping',
    'GetCropping'), ('border', 'GetBorder'), ('cropping_region',
    'GetCroppingRegion'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'border', 'cropping', 'debug',
    'global_warning_display', 'interpolate', 'release_data_flag',
    'resize_method', 'cropping_region', 'magnification_factors',
    'number_of_threads', 'output_dimensions', 'output_spacing',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImageResize, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit ImageResize properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['border', 'cropping', 'interpolate'],
            ['resize_method'], ['cropping_region', 'magnification_factors',
            'number_of_threads', 'output_dimensions', 'output_spacing']),
            title='Edit ImageResize properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImageResize properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

