# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.abstract_widget import AbstractWidget


class ImplicitPlaneWidget2(AbstractWidget):
    """
    ImplicitPlaneWidget2 - 3d widget for manipulating an infinite plane
    
    Superclass: AbstractWidget
    
    This 3d widget defines an infinite plane that can be interactively
    placed in a scene. The widget is assumed to consist of four parts: 1)
    a plane contained in a 2) bounding box, with a 3) plane normal, which
    is rooted at a 4) point on the plane. (The representation paired with
    this widget determines the actual geometry of the widget.)
    
    To use this widget, you generally pair it with a
    ImplicitPlaneRepresentation (or a subclass). Variuos options are
    available for controlling how the representation appears, and how the
    widget functions.
    
    See Also:
    
    ThreeDWidget BoxWidget PlaneWidget LineWidget PointWidget
    SphereWidget ImagePlaneWidget
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImplicitPlaneWidget2, obj, update, **traits)
    
    def _get_implicit_plane_representation(self):
        return wrap_vtk(self._vtk_obj.GetImplicitPlaneRepresentation())
    implicit_plane_representation = traits.Property(_get_implicit_plane_representation, help=\
        """
        Return the representation as a ImplicitPlaneRepresentation.
        """
    )

    def set_lock_normal_to_camera(self, *args):
        """
        V.set_lock_normal_to_camera(int)
        C++: void SetLockNormalToCamera(int lock)
        Observe/Unobserve the camera if the widget is locked/unlocked to
        update the ImplicitePlaneRepresentation's normal.
        """
        ret = self._wrap_call(self._vtk_obj.SetLockNormalToCamera, *args)
        return ret

    def set_representation(self, *args):
        """
        V.set_representation(ImplicitPlaneRepresentation)
        C++: void SetRepresentation(ImplicitPlaneRepresentation *rep)
        Specify an instance of WidgetRepresentation used to represent
        this widget in the scene. Note that the representation is a
        subclass of Prop so it can be added to the renderer
        independent of the widget.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetRepresentation, *my_args)
        return ret

    _updateable_traits_ = \
    (('key_press_activation_value', 'GetKeyPressActivationValue'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('enabled',
    'GetEnabled'), ('manages_cursor', 'GetManagesCursor'), ('priority',
    'GetPriority'), ('debug', 'GetDebug'), ('picking_managed',
    'GetPickingManaged'), ('reference_count', 'GetReferenceCount'),
    ('key_press_activation', 'GetKeyPressActivation'), ('process_events',
    'GetProcessEvents'))
    
    _full_traitnames_list_ = \
    (['debug', 'enabled', 'global_warning_display',
    'key_press_activation', 'manages_cursor', 'picking_managed',
    'process_events', 'key_press_activation_value', 'priority'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImplicitPlaneWidget2, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit ImplicitPlaneWidget2 properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['enabled', 'key_press_activation', 'manages_cursor',
            'picking_managed', 'process_events'], [],
            ['key_press_activation_value', 'priority']),
            title='Edit ImplicitPlaneWidget2 properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImplicitPlaneWidget2 properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

