# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class IntersectionPolyDataFilter(PolyDataAlgorithm):
    """
    IntersectionPolyDataFilter
    
    Superclass: PolyDataAlgorithm
    
    IntersectionPolyDataFilter computes the intersection between two
    PolyData objects. The first output is a set of lines that marks
    the intersection of the input PolyData objects. The second and
    third outputs are the first and second input PolyData,
    respectively. Optionally, the two output PolyData can be split
    along the intersection lines.
    
    This code was contributed in the Insight Journal paper: "Boolean Operations on Surfaces in VTK Without External
    Libraries" by Cory Quammen, Chris Weigle C., Russ Taylor
    http://hdl.handle.net/10380/3262
    http://www.insight-journal.org/browse/publication/797
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkIntersectionPolyDataFilter, obj, update, **traits)
    
    split_second_output = tvtk_base.true_bool_trait(help=\
        """
        If on, the third output will be the second input mesh split by
        the intersection with the first input mesh. Defaults to on.
        """
    )
    def _split_second_output_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSplitSecondOutput,
                        self.split_second_output_)

    split_first_output = tvtk_base.true_bool_trait(help=\
        """
        If on, the second output will be the first input mesh split by
        the intersection with the second input mesh. Defaults to on.
        """
    )
    def _split_first_output_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSplitFirstOutput,
                        self.split_first_output_)

    def triangle_triangle_intersection(self, *args):
        """
        V.triangle_triangle_intersection([float, float, float], [float,
            float, float], [float, float, float], [float, float, float],
            [float, float, float], [float, float, float], int, [float,
            float, float], [float, float, float]) -> int
        C++: static int TriangleTriangleIntersection(double p1[3],
            double q1[3], double r1[3], double p2[3], double q2[3],
            double r2[3], int &coplanar, double pt1[3], double pt2[3])
        Given two triangles defined by points (p1, q1, r1) and (p2, q2,
        r2), returns whether the two triangles intersect. If they do, the
        endpoints of the line forming the intersection are returned in
        pt1 and pt2. The parameter coplanar is set to 1 if the triangles
        are coplanar and 0 otherwise.
        """
        ret = self._wrap_call(self._vtk_obj.TriangleTriangleIntersection, *args)
        return ret

    _updateable_traits_ = \
    (('global_warning_display', 'GetGlobalWarningDisplay'),
    ('progress_text', 'GetProgressText'), ('split_second_output',
    'GetSplitSecondOutput'), ('debug', 'GetDebug'), ('split_first_output',
    'GetSplitFirstOutput'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('reference_count', 'GetReferenceCount'), ('progress', 'GetProgress'),
    ('abort_execute', 'GetAbortExecute'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'split_first_output', 'split_second_output',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(IntersectionPolyDataFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit IntersectionPolyDataFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['split_first_output', 'split_second_output'], [], []),
            title='Edit IntersectionPolyDataFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit IntersectionPolyDataFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

