# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.undirected_graph import UndirectedGraph


class Molecule(UndirectedGraph):
    """
    Molecule - class describing a molecule
    
    Superclass: UndirectedGraph
    
    Molecule and the convenience classes Atom and Bond describe
    the geometry and connectivity of a molecule. The molecule can be
    constructed using the append_atom() and append_bond() methods in one of
    two ways; either by fully specifying the atom/bond in a single call,
    or by incrementally setting the various attributes using the
    convience Atom and Bond classes:
    
    Single call:vtk_molecule *mol = Molecule::New();
    Atom h1 = mol->_append_atom(_1, 0.0, 0.0, -0.5);
    Atom h2 = mol->_append_atom(_1, 0.0, 0.0,  0.5);
    Bond b  = mol->_append_bond(h_1, h2, 1);
    
    incremental:vtk_molecule *mol = Molecule::New();
    
    Atom h1 = mol->_append_atom(); h_1._set_atomic_number(_1);
    h_1._set_position(_0._0, 0.0, -0.5);
    
    Atom h2 = mol->_append_atom(); h_2._set_atomic_number(_1); Vector3d
    displacement (0.0, 0.0, 1.0);
    h_2._set_position(h_1._get_position_as_vector3d() + displacement);
    
    Bond b  = mol->_append_bond(h_1, h2, 1);
    
    Both of the above methods will produce the same molecule, two
    hydrogens connected with a 1.0 Angstrom single bond, aligned to the
    z-axis. The second example also demostrates the use of VTK's
    Vector class, which is fully supported by the Chemistry kit.
    
    The Molecule object is intended to be used with the
    MoleculeMapper class for visualizing molecular structure using
    common rendering techniques.
    
    \warning While direct use of the underlying UndirectedGraph
    structure is possible due to Molecule's public inheritance, this
    should not be relied upon and may change in the future.
    
    See Also:
    
    Atom Bond MoleculeMapper PeriodicTable
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMolecule, obj, update, **traits)
    
    def get_bond_order(self, *args):
        """
        V.get_bond_order(int) -> int
        C++: unsigned short GetBondOrder(IdType bondId)"""
        ret = self._wrap_call(self._vtk_obj.GetBondOrder, *args)
        return ret

    def set_bond_order(self, *args):
        """
        V.set_bond_order(int, int)
        C++: void SetBondOrder(IdType bondId, unsigned short order)"""
        ret = self._wrap_call(self._vtk_obj.SetBondOrder, *args)
        return ret

    def _get_electronic_data(self):
        return wrap_vtk(self._vtk_obj.GetElectronicData())
    def _set_electronic_data(self, arg):
        old_val = self._get_electronic_data()
        self._wrap_call(self._vtk_obj.SetElectronicData,
                        deref_vtk(arg))
        self.trait_property_changed('electronic_data', old_val, arg)
    electronic_data = traits.Property(_get_electronic_data, _set_electronic_data, help=\
        """
        Set/Get the abstract_electronic_data-subclassed object for this
        molecule.
        """
    )

    def get_atom_position(self, *args):
        """
        V.get_atom_position(int) -> Vector3f
        C++: Vector3f GetAtomPosition(IdType atomId)
        V.get_atom_position(int, [float, float, float])
        C++: void GetAtomPosition(IdType atomId, float pos[3])
        Get the position of the atom with the specified id.
        """
        ret = self._wrap_call(self._vtk_obj.GetAtomPosition, *args)
        return wrap_vtk(ret)

    def set_atom_position(self, *args):
        """
        V.set_atom_position(int, Vector3f)
        C++: void SetAtomPosition(IdType atomId,
            const Vector3f &pos)
        V.set_atom_position(int, float, float, float)
        C++: void SetAtomPosition(IdType atomId, double x, double y,
            double z)
        Set the position of the atom with the specified id.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetAtomPosition, *my_args)
        return ret

    def get_atom_atomic_number(self, *args):
        """
        V.get_atom_atomic_number(int) -> int
        C++: unsigned short GetAtomAtomicNumber(IdType atomId)
        Return the atomic number of the atom with the specified id.
        """
        ret = self._wrap_call(self._vtk_obj.GetAtomAtomicNumber, *args)
        return ret

    def set_atom_atomic_number(self, *args):
        """
        V.set_atom_atomic_number(int, int)
        C++: void SetAtomAtomicNumber(IdType atomId,
            unsigned short atomicNum)
        Set the atomic number of the atom with the specified id.
        """
        ret = self._wrap_call(self._vtk_obj.SetAtomAtomicNumber, *args)
        return ret

    def _get_atomic_number_array(self):
        return wrap_vtk(self._vtk_obj.GetAtomicNumberArray())
    atomic_number_array = traits.Property(_get_atomic_number_array, help=\
        """
        Access the raw arrays used in this Molecule instance
        """
    )

    def _get_atomic_position_array(self):
        return wrap_vtk(self._vtk_obj.GetAtomicPositionArray())
    atomic_position_array = traits.Property(_get_atomic_position_array, help=\
        """
        Access the raw arrays used in this Molecule instance
        """
    )

    def get_bond_length(self, *args):
        """
        V.get_bond_length(int) -> float
        C++: double GetBondLength(IdType bondId)"""
        ret = self._wrap_call(self._vtk_obj.GetBondLength, *args)
        return ret

    def _get_number_of_atoms(self):
        return self._vtk_obj.GetNumberOfAtoms()
    number_of_atoms = traits.Property(_get_number_of_atoms, help=\
        """
        Return the number of atoms in the molecule.
        """
    )

    def _get_number_of_bonds(self):
        return self._vtk_obj.GetNumberOfBonds()
    number_of_bonds = traits.Property(_get_number_of_bonds, help=\
        """
        Return the number of bonds in the molecule.
        """
    )

    def deep_copy_attributes(self, *args):
        """
        V.deep_copy_attributes(Molecule)
        C++: virtual void DeepCopyAttributes(Molecule *m)
        Deep copies attributes (i.e. everything besides atoms and bonds)
        fromm into this.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeepCopyAttributes, *my_args)
        return ret

    def deep_copy_structure(self, *args):
        """
        V.deep_copy_structure(Molecule)
        C++: virtual void DeepCopyStructure(Molecule *m)
        Deep copies the atoms and bonds from m into this.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeepCopyStructure, *my_args)
        return ret

    def shallow_copy_attributes(self, *args):
        """
        V.shallow_copy_attributes(Molecule)
        C++: virtual void ShallowCopyAttributes(Molecule *m)
        Shallow copies attributes (i.e. everything besides atoms and
        bonds) fromm into this.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ShallowCopyAttributes, *my_args)
        return ret

    def shallow_copy_structure(self, *args):
        """
        V.shallow_copy_structure(Molecule)
        C++: virtual void ShallowCopyStructure(Molecule *m)
        Shallow copies the atoms and bonds from m into this.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ShallowCopyStructure, *my_args)
        return ret

    _updateable_traits_ = \
    (('reference_count', 'GetReferenceCount'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('global_release_data_flag', 'GetGlobalReleaseDataFlag'))
    
    _full_traitnames_list_ = \
    (['debug', 'global_release_data_flag', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Molecule, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit Molecule properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['global_release_data_flag'], [], []),
            title='Edit Molecule properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Molecule properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

