# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.image_reader2 import ImageReader2


class NIFTIImageReader(ImageReader2):
    """
    NIFTIImageReader - Read n_if_ti-_1 and n_if_ti-_2 medical image files
    
    Superclass: ImageReader2
    
    This class reads NIFTI files, either in .nii format or as separate
    .img and .hdr files.  If two files are used, then they can be passed
    by using set_file_names() instead of set_file_name().  Files ending in
    .gz are decompressed on-the-fly while they are being read.  Files
    with complex numbers or vector dimensions will be read as
    multi-component images.  If a NIFTI file has a time dimension, then
    by default only the first image in the time series will be read, but
    the time_as_vector flag can be set to read the time steps as vector
    components.  Files in Analyze 7.5 format are also supported by this
    reader.
    
    Thanks:
    
    This class was contributed to VTK by the Calgary Image Processing and
    Analysis Centre (CIPAC).
    
    See Also:
    
    NIFTIImageWriter, NIFTIImageHeader
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkNIFTIImageReader, obj, update, **traits)
    
    time_as_vector = tvtk_base.false_bool_trait(help=\
        """
        Read the time dimension as scalar components (default: Off). If
        this is on, then each time point will be stored as a component in
        the image data.  If the file has both a time dimension and a
        vector dimension, then the number of components will be the
        product of these two dimensions, i.e. the components will store a
        sequence of vectors.
        """
    )
    def _time_as_vector_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTimeAsVector,
                        self.time_as_vector_)

    def _get_nifti_header(self):
        return wrap_vtk(self._vtk_obj.GetNIFTIHeader())
    nifti_header = traits.Property(_get_nifti_header, help=\
        """
        Get the raw header information from the n_if_ti file.
        """
    )

    def _get_q_fac(self):
        return self._vtk_obj.GetQFac()
    q_fac = traits.Property(_get_q_fac, help=\
        """
        QFac gives the slice order in the NIFTI file versus the VTK
        image. If QFac is -1, then the VTK slice index J is related to
        the NIFTI slice index j by the equation J = (num_slices - j - 1).
         VTK requires the slices to be ordered so that the voxel indices
        (I,J,K) provide a right-handed coordinate system, whereas NIFTI
        does not.  Instead, NIFTI stores a factor called "qfac" in the
        header to signal when the (i,j,k) indices form a left-handed
        coordinate system.  QFac will only ever have values of +1 or -1.
        """
    )

    def _get_q_form_matrix(self):
        return wrap_vtk(self._vtk_obj.GetQFormMatrix())
    q_form_matrix = traits.Property(_get_q_form_matrix, help=\
        """
        Get a matrix that gives the "qform" orientation and offset for
        the data. If no qform matrix was stored in the file, the return
        value is NULL. This matrix will transform VTK data coordinates
        into the NIFTI oriented data coordinates, where +X points right,
        +Y points anterior (toward the front), and +Z points superior
        (toward the head). The qform matrix will always have a positive
        determinant. The offset that is stored in the matrix gives the
        position of the first pixel in the first slice of the VTK image
        data.  Note that if QFac is -1, then the first slice in the VTK
        image data is the last slice in the NIFTI file, and the Z offset
        will automatically be adjusted to compensate for this.
        """
    )

    def _get_rescale_intercept(self):
        return self._vtk_obj.GetRescaleIntercept()
    rescale_intercept = traits.Property(_get_rescale_intercept, help=\
        """
        Get the slope and intercept for rescaling the scalar values.
        These values allow calibration of the data to real values. Use
        the equation v = u*_rescale_slope + rescale_intercept. This directly
        returns the values stored in the scl_slope and scl_inter fields
        in the NIFTI header.
        """
    )

    def _get_rescale_slope(self):
        return self._vtk_obj.GetRescaleSlope()
    rescale_slope = traits.Property(_get_rescale_slope, help=\
        """
        Get the slope and intercept for rescaling the scalar values.
        These values allow calibration of the data to real values. Use
        the equation v = u*_rescale_slope + rescale_intercept. This directly
        returns the values stored in the scl_slope and scl_inter fields
        in the NIFTI header.
        """
    )

    def _get_s_form_matrix(self):
        return wrap_vtk(self._vtk_obj.GetSFormMatrix())
    s_form_matrix = traits.Property(_get_s_form_matrix, help=\
        """
        Get a matrix that gives the "sform" orientation and offset for
        the data. If no sform matrix was stored in the file, the return
        value is NULL. Like the qform matrix, this matrix will transform
        VTK data coordinates into a NIFTI coordinate system.  Unlike the
        qform matrix, the sform matrix can contain scaling information
        and can even (rarely) have a negative determinant, i.e. a flip. 
        This matrix is modified slightly as compared to the sform matrix
        stored in the NIFTI header: the pixdim pixel spacing is factored
        out.  Also, if QFac is -1, then the VTK slices are in reverse
        order as compared to the NIFTI slices, hence as compared to the
        sform matrix stored in the header, the third column of this
        matrix is multiplied by -1 and the Z offset is shifted to
        compensate for the fact that the last slice has become the first.
        """
    )

    def _get_time_dimension(self):
        return self._vtk_obj.GetTimeDimension()
    time_dimension = traits.Property(_get_time_dimension, help=\
        """
        Get the time dimension that was stored in the NIFTI header.
        """
    )

    def _get_time_spacing(self):
        return self._vtk_obj.GetTimeSpacing()
    time_spacing = traits.Property(_get_time_spacing, help=\
        """
        Get the time dimension that was stored in the NIFTI header.
        """
    )

    _updateable_traits_ = \
    (('number_of_scalar_components', 'GetNumberOfScalarComponents'),
    ('file_name', 'GetFileName'), ('data_byte_order', 'GetDataByteOrder'),
    ('file_pattern', 'GetFilePattern'), ('file_prefix', 'GetFilePrefix'),
    ('debug', 'GetDebug'), ('header_size', 'GetHeaderSize'),
    ('data_spacing', 'GetDataSpacing'), ('swap_bytes', 'GetSwapBytes'),
    ('data_origin', 'GetDataOrigin'), ('file_lower_left',
    'GetFileLowerLeft'), ('file_name_slice_offset',
    'GetFileNameSliceOffset'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('data_extent', 'GetDataExtent'),
    ('progress_text', 'GetProgressText'), ('file_name_slice_spacing',
    'GetFileNameSliceSpacing'), ('abort_execute', 'GetAbortExecute'),
    ('time_as_vector', 'GetTimeAsVector'), ('release_data_flag',
    'GetReleaseDataFlag'), ('reference_count', 'GetReferenceCount'),
    ('progress', 'GetProgress'), ('memory_buffer_length',
    'GetMemoryBufferLength'), ('file_dimensionality',
    'GetFileDimensionality'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'file_lower_left',
    'global_warning_display', 'release_data_flag', 'swap_bytes',
    'time_as_vector', 'data_byte_order', 'data_extent', 'data_origin',
    'data_spacing', 'file_dimensionality', 'file_name',
    'file_name_slice_offset', 'file_name_slice_spacing', 'file_pattern',
    'file_prefix', 'header_size', 'memory_buffer_length',
    'number_of_scalar_components', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(NIFTIImageReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit NIFTIImageReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['file_lower_left', 'swap_bytes', 'time_as_vector'],
            ['data_byte_order'], ['data_extent', 'data_origin', 'data_spacing',
            'file_dimensionality', 'file_name', 'file_name_slice_offset',
            'file_name_slice_spacing', 'file_pattern', 'file_prefix',
            'header_size', 'memory_buffer_length',
            'number_of_scalar_components']),
            title='Edit NIFTIImageReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit NIFTIImageReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

