# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.generic_movie_writer import GenericMovieWriter


class OggTheoraWriter(GenericMovieWriter):
    """
    OggTheoraWriter - Uses the ogg and theora libraries to write video
    
    Superclass: GenericMovieWriter
    
    OggTheoraWriter is an adapter that allows VTK to use the ogg and
    theora libraries to write movie files.  This class creates .ogv files
    containing theora encoded video without audio.
    
    This implementation is based on FFMPEGWriter and uses some code
    derived from the encoder example distributed with libtheora.
    
    See Also:
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOggTheoraWriter, obj, update, **traits)
    
    subsampling = tvtk_base.false_bool_trait(help=\
        """
        Is the video to be encoded using 4:2:0 subsampling?
        """
    )
    def _subsampling_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSubsampling,
                        self.subsampling_)

    rate = traits.Trait(25, traits.Range(1, 5000, enter_set=True, auto_set=False), help=\
        """
        Set/Get the frame rate, in frame/s.
        """
    )
    def _rate_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRate,
                        self.rate)

    quality = traits.Trait(2, traits.Range(0, 2, enter_set=True, auto_set=False), help=\
        """
        Set/Get the compression quality. 0 means worst quality and
        smallest file size 2 means best quality and largest file size
        """
    )
    def _quality_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetQuality,
                        self.quality)

    _updateable_traits_ = \
    (('global_warning_display', 'GetGlobalWarningDisplay'), ('file_name',
    'GetFileName'), ('progress_text', 'GetProgressText'), ('debug',
    'GetDebug'), ('rate', 'GetRate'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('reference_count', 'GetReferenceCount'), ('progress', 'GetProgress'),
    ('subsampling', 'GetSubsampling'), ('quality', 'GetQuality'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'subsampling', 'file_name', 'progress_text',
    'quality', 'rate'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OggTheoraWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit OggTheoraWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['subsampling'], [], ['file_name', 'quality', 'rate']),
            title='Edit OggTheoraWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OggTheoraWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

