# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.object import Object


class OpenGLLightMonitor(Object):
    """
    OpenGLLightMonitor -- A helper for painters that
    
    Superclass: Object
    
    OpenGLLightMonitor -- A helper for painters that tracks state of
    open_gl lights. A Painter could use this to skip expensive processing
    that is only needed when lights change.
    
    this is not intended to be shared. each object should use it's own
    instance of this class. it's intended to be called once per render.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLLightMonitor, obj, update, **traits)
    
    light_id = traits.Int(0, enter_set=True, auto_set=False, help=\
        """
        Set/Get the light id of the open_gl light to track. The light id
        must be set prior to use. Default value 0.
        """
    )
    def _light_id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLightId,
                        self.light_id)

    def set_ambient(self, *args):
        """
        V.set_ambient([float, ...])
        C++: void SetAmbient(float *val)
        Setters for internal state.
        """
        ret = self._wrap_call(self._vtk_obj.SetAmbient, *args)
        return ret

    def set_attenuation(self, *args):
        """
        V.set_attenuation([float, ...])
        C++: void SetAttenuation(float *val)
        Setters for internal state.
        """
        ret = self._wrap_call(self._vtk_obj.SetAttenuation, *args)
        return ret

    def set_diffuse(self, *args):
        """
        V.set_diffuse([float, ...])
        C++: void SetDiffuse(float *val)
        Setters for internal state.
        """
        ret = self._wrap_call(self._vtk_obj.SetDiffuse, *args)
        return ret

    def set_enabled(self, *args):
        """
        V.set_enabled(int)
        C++: void SetEnabled(int val)
        Setters for internal state.
        """
        ret = self._wrap_call(self._vtk_obj.SetEnabled, *args)
        return ret

    def set_position(self, *args):
        """
        V.set_position([float, ...])
        C++: void SetPosition(float *val)
        Setters for internal state.
        """
        ret = self._wrap_call(self._vtk_obj.SetPosition, *args)
        return ret

    def set_specular(self, *args):
        """
        V.set_specular([float, ...])
        C++: void SetSpecular(float *val)
        Setters for internal state.
        """
        ret = self._wrap_call(self._vtk_obj.SetSpecular, *args)
        return ret

    def set_spot_cutoff(self, *args):
        """
        V.set_spot_cutoff(float)
        C++: void SetSpotCutoff(float val)
        Setters for internal state.
        """
        ret = self._wrap_call(self._vtk_obj.SetSpotCutoff, *args)
        return ret

    def set_spot_direction(self, *args):
        """
        V.set_spot_direction([float, ...])
        C++: void SetSpotDirection(float *val)
        Setters for internal state.
        """
        ret = self._wrap_call(self._vtk_obj.SetSpotDirection, *args)
        return ret

    def set_spot_exponent(self, *args):
        """
        V.set_spot_exponent(float)
        C++: void SetSpotExponent(float val)
        Setters for internal state.
        """
        ret = self._wrap_call(self._vtk_obj.SetSpotExponent, *args)
        return ret

    def state_changed(self):
        """
        V.state_changed() -> bool
        C++: bool StateChanged()
        Fetches the current GL state and updates the internal copies of
        the data. returns true if any of the tracked open_gl lights have
        changed. Typically this is the only function a user needs to
        call.
        """
        ret = self._vtk_obj.StateChanged()
        return ret
        

    def update(self):
        """
        V.update()
        C++: void Update()
        Fetch and save open_gl light state. Note, this is done
        automatically in sate_changed.
        """
        ret = self._vtk_obj.Update()
        return ret
        

    _updateable_traits_ = \
    (('reference_count', 'GetReferenceCount'), ('debug', 'GetDebug'),
    ('light_id', 'GetLightId'), ('global_warning_display',
    'GetGlobalWarningDisplay'))
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'light_id'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLLightMonitor, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLLightMonitor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], ['light_id']),
            title='Edit OpenGLLightMonitor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLLightMonitor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

