# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.object import Object


class OpenGLModelViewProjectionMonitor(Object):
    """
    OpenGLModelViewProjectionMonitor -- A helper for painters that
    
    Superclass: Object
    
    OpenGLModelViewProjectionMonitor -- A helper for painters that
    tracks state of open_gl model-view and projection matrices. A Painter
    could use this to skip expensive processing that is only needed when
    the model-view or projection matrices change.
    
    this is not intended to be shared. each object should use it's own
    instance of this class. it's intended to be called once per render.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLModelViewProjectionMonitor, obj, update, **traits)
    
    def set_model_view(self, *args):
        """
        V.set_model_view([float, ...])
        C++: void SetModelView(float *val)
        Set the matrix data.
        """
        ret = self._wrap_call(self._vtk_obj.SetModelView, *args)
        return ret

    def set_projection(self, *args):
        """
        V.set_projection([float, ...])
        C++: void SetProjection(float *val)
        Set the matrix data.
        """
        ret = self._wrap_call(self._vtk_obj.SetProjection, *args)
        return ret

    def state_changed(self):
        """
        V.state_changed() -> bool
        C++: bool StateChanged()
        Fetches the current GL state and updates the internal copies of
        the data. returns true if any of the tracked open_gl matrices have
        changed. Typically this is the only function a user needs to
        call.
        """
        ret = self._vtk_obj.StateChanged()
        return ret
        

    def update(self):
        """
        V.update()
        C++: void Update()
        Fetch and store open_gl model view matrix. Note, this is done
        automatically in sate_changed.
        """
        ret = self._vtk_obj.Update()
        return ret
        

    _updateable_traits_ = \
    (('reference_count', 'GetReferenceCount'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'))
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLModelViewProjectionMonitor, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLModelViewProjectionMonitor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], []),
            title='Edit OpenGLModelViewProjectionMonitor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLModelViewProjectionMonitor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

