# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.chaco_reader import ChacoReader


class PChacoReader(ChacoReader):
    """
    PChacoReader - Read Chaco files
    
    Superclass: ChacoReader
    
    PChacoReader is a unstructured grid source object that reads Chaco
    files.  The file is read by process 0 and converted into a
    UnstructuredGrid.  The DistributedDataFilter is invoked to
    divide the grid among the processes.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPChacoReader, obj, update, **traits)
    
    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, help=\
        """
        Set/Get the communicator object (we'll use global World
        controller
          if you don't set a different one).
        """
    )

    _updateable_traits_ = \
    (('generate_global_node_id_array', 'GetGenerateGlobalNodeIdArray'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('base_name',
    'GetBaseName'), ('generate_edge_weight_arrays',
    'GetGenerateEdgeWeightArrays'), ('progress_text', 'GetProgressText'),
    ('debug', 'GetDebug'), ('generate_global_element_id_array',
    'GetGenerateGlobalElementIdArray'), ('generate_vertex_weight_arrays',
    'GetGenerateVertexWeightArrays'), ('release_data_flag',
    'GetReleaseDataFlag'), ('reference_count', 'GetReferenceCount'),
    ('progress', 'GetProgress'), ('abort_execute', 'GetAbortExecute'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'generate_edge_weight_arrays',
    'generate_global_element_id_array', 'generate_global_node_id_array',
    'generate_vertex_weight_arrays', 'global_warning_display',
    'release_data_flag', 'base_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PChacoReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit PChacoReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['generate_edge_weight_arrays',
            'generate_global_element_id_array', 'generate_global_node_id_array',
            'generate_vertex_weight_arrays'], [], ['base_name']),
            title='Edit PChacoReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PChacoReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

