# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.mask_points import MaskPoints


class PMaskPoints(MaskPoints):
    """
    PMaskPoints - parallel Mask Points
    
    Superclass: MaskPoints
    
    The difference between this implementation and MaskPoints is the
    use of the MultiProcessController and that
    proportional_maximum_number_of_points is obeyed.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPMaskPoints, obj, update, **traits)
    
    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, help=\
        """
        Set the communicator object for interprocess communication
        """
    )

    _updateable_traits_ = \
    (('random_mode', 'GetRandomMode'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('progress_text', 'GetProgressText'),
    ('abort_execute', 'GetAbortExecute'), ('maximum_number_of_points',
    'GetMaximumNumberOfPoints'), ('single_vertex_per_cell',
    'GetSingleVertexPerCell'), ('proportional_maximum_number_of_points',
    'GetProportionalMaximumNumberOfPoints'), ('on_ratio', 'GetOnRatio'),
    ('generate_vertices', 'GetGenerateVertices'), ('release_data_flag',
    'GetReleaseDataFlag'), ('offset', 'GetOffset'), ('reference_count',
    'GetReferenceCount'), ('progress', 'GetProgress'),
    ('random_mode_type', 'GetRandomModeType'), ('output_points_precision',
    'GetOutputPointsPrecision'), ('debug', 'GetDebug'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'generate_vertices',
    'global_warning_display', 'proportional_maximum_number_of_points',
    'random_mode', 'release_data_flag', 'single_vertex_per_cell',
    'maximum_number_of_points', 'offset', 'on_ratio',
    'output_points_precision', 'progress_text', 'random_mode_type'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PMaskPoints, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit PMaskPoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['generate_vertices',
            'proportional_maximum_number_of_points', 'random_mode',
            'single_vertex_per_cell'], [], ['maximum_number_of_points', 'offset',
            'on_ratio', 'output_points_precision', 'random_mode_type']),
            title='Edit PMaskPoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PMaskPoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

