# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.image_algorithm import ImageAlgorithm


class PResampleFilter(ImageAlgorithm):
    """
    PResampleFilter - probe dataset in parallel using a ImageData
    
    Superclass: ImageAlgorithm
    
    
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPResampleFilter, obj, update, **traits)
    
    use_input_bounds = tvtk_base.true_bool_trait(help=\
        """
        Set/Get if the filter should use Input bounds to sub-sample the
        data. By default it is set to 1.
        """
    )
    def _use_input_bounds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseInputBounds,
                        self.use_input_bounds_)

    sampling_dimension = traits.Array(shape=(3,), value=(10, 10, 10), dtype=int, enter_set=True, auto_set=False, cols=3, help=\
        """
        
        """
    )
    def _sampling_dimension_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSamplingDimension,
                        self.sampling_dimension)

    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, help=\
        """
        Set and get the controller.
        """
    )

    custom_sampling_bounds = traits.Array(shape=(6,), value=(0.0, 1.0, 0.0, 1.0, 0.0, 1.0), dtype=float, enter_set=True, auto_set=False, cols=3, help=\
        """
        
        """
    )
    def _custom_sampling_bounds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCustomSamplingBounds,
                        self.custom_sampling_bounds)

    _updateable_traits_ = \
    (('global_warning_display', 'GetGlobalWarningDisplay'),
    ('sampling_dimension', 'GetSamplingDimension'), ('debug', 'GetDebug'),
    ('progress_text', 'GetProgressText'), ('use_input_bounds',
    'GetUseInputBounds'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('reference_count',
    'GetReferenceCount'), ('progress', 'GetProgress'),
    ('custom_sampling_bounds', 'GetCustomSamplingBounds'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'use_input_bounds', 'custom_sampling_bounds',
    'progress_text', 'sampling_dimension'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PResampleFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit PResampleFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['use_input_bounds'], [], ['custom_sampling_bounds',
            'sampling_dimension']),
            title='Edit PResampleFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PResampleFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

