# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.plot_points import PlotPoints


class PlotBag(PlotPoints):
    """
    PlotBag - Class for drawing an a bagplot.
    
    Superclass: PlotPoints
    
    This class allows to draw a bagplot given three columns from a
    Table. The first two columns will represent X,Y as it is for
    PlotPoints. The third one will have to specify if the density
    assigned to each point (generally obtained by the
    HighestDensityRegionsStatistics filter). Points are drawn in a
    plot points fashion and 2 convex hull polygons are drawn around the
    median and the 3 quartile of the density field.
    
    See Also:
    
    HighestDensityRegionsStatistics
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPlotBag, obj, update, **traits)
    
    def _get_line_pen(self):
        return wrap_vtk(self._vtk_obj.GetLinePen())
    def _set_line_pen(self, arg):
        old_val = self._get_line_pen()
        self._wrap_call(self._vtk_obj.SetLinePen,
                        deref_vtk(arg))
        self.trait_property_changed('line_pen', old_val, arg)
    line_pen = traits.Property(_get_line_pen, _set_line_pen, help=\
        """
        Set/get the Pen object that controls how this plot draws
        boundary lines.
        """
    )

    def _get_point_pen(self):
        return wrap_vtk(self._vtk_obj.GetPointPen())
    def _set_point_pen(self, arg):
        old_val = self._get_point_pen()
        self._wrap_call(self._vtk_obj.SetPointPen,
                        deref_vtk(arg))
        self.trait_property_changed('point_pen', old_val, arg)
    point_pen = traits.Property(_get_point_pen, _set_point_pen, help=\
        """
        Set/get the Pen object that controls how this plot draws
        points. Those are just helpers functions:
         this pen is actually the default Plot pen.
        """
    )

    _updateable_traits_ = \
    (('opacity', 'GetOpacity'), ('use_index_for_x_series',
    'GetUseIndexForXSeries'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('width', 'GetWidth'), ('marker_size',
    'GetMarkerSize'), ('tooltip_label_format', 'GetTooltipLabelFormat'),
    ('label', 'GetLabel'), ('visible', 'GetVisible'), ('tooltip_notation',
    'GetTooltipNotation'), ('valid_point_mask_name',
    'GetValidPointMaskName'), ('reference_count', 'GetReferenceCount'),
    ('tooltip_precision', 'GetTooltipPrecision'), ('scalar_visibility',
    'GetScalarVisibility'), ('marker_style', 'GetMarkerStyle'), ('debug',
    'GetDebug'), ('interactive', 'GetInteractive'))
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'scalar_visibility',
    'interactive', 'label', 'marker_size', 'marker_style', 'opacity',
    'tooltip_label_format', 'tooltip_notation', 'tooltip_precision',
    'use_index_for_x_series', 'valid_point_mask_name', 'visible',
    'width'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PlotBag, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit PlotBag properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['scalar_visibility'], [], ['interactive', 'label',
            'marker_size', 'marker_style', 'opacity', 'tooltip_label_format',
            'tooltip_notation', 'tooltip_precision', 'use_index_for_x_series',
            'valid_point_mask_name', 'visible', 'width']),
            title='Edit PlotBag properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PlotBag properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

