# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.plot import Plot


class PlotFunctionalBag(Plot):
    """
    PlotFunctionalBag - Class for drawing an XY line plot or bag
    
    Superclass: Plot
    
    Depending on the number of components, this class will draw either a
    line plot (for 1 component column) or, for two components columns, a
    filled polygonal band (the bag) going from the first to the second
    component on the Y-axis along the X-axis. The filter
    ExtractFunctionalBagPlot is intended to create such "bag" columns.
    
    See Also:
    
    ExtractFunctionalBagPlot
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPlotFunctionalBag, obj, update, **traits)
    
    def _get_lookup_table(self):
        return wrap_vtk(self._vtk_obj.GetLookupTable())
    def _set_lookup_table(self, arg):
        old_val = self._get_lookup_table()
        self._wrap_call(self._vtk_obj.SetLookupTable,
                        deref_vtk(arg))
        self.trait_property_changed('lookup_table', old_val, arg)
    lookup_table = traits.Property(_get_lookup_table, _set_lookup_table, help=\
        """
        Specify a lookup table for the mapper to use.
        """
    )

    def create_default_lookup_table(self):
        """
        V.create_default_lookup_table()
        C++: virtual void CreateDefaultLookupTable()
        Create default lookup table. Generally used to create one when
        none is available with the scalar data.
        """
        ret = self._vtk_obj.CreateDefaultLookupTable()
        return ret
        

    def is_bag(self):
        """
        V.is_bag() -> bool
        C++: virtual bool IsBag()
        Returns true if the plot is a functional bag, false if it is a
        simple line.
        """
        ret = self._vtk_obj.IsBag()
        return ret
        

    _updateable_traits_ = \
    (('opacity', 'GetOpacity'), ('use_index_for_x_series',
    'GetUseIndexForXSeries'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('visible', 'GetVisible'), ('debug',
    'GetDebug'), ('label', 'GetLabel'), ('width', 'GetWidth'),
    ('tooltip_notation', 'GetTooltipNotation'), ('reference_count',
    'GetReferenceCount'), ('tooltip_precision', 'GetTooltipPrecision'),
    ('tooltip_label_format', 'GetTooltipLabelFormat'), ('interactive',
    'GetInteractive'))
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'interactive', 'label',
    'opacity', 'tooltip_label_format', 'tooltip_notation',
    'tooltip_precision', 'use_index_for_x_series', 'visible', 'width'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PlotFunctionalBag, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit PlotFunctionalBag properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], ['interactive', 'label', 'opacity',
            'tooltip_label_format', 'tooltip_notation', 'tooltip_precision',
            'use_index_for_x_series', 'visible', 'width']),
            title='Edit PlotFunctionalBag properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PlotFunctionalBag properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

