# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.actor import Actor


class PolarAxesActor(Actor):
    """
    PolarAxesActor - create an actor of a polar axes -
    
    Superclass: Actor
    
    PolarAxesActor is a composite actor that draws polar axes in a
    specified plane for a give pole. Currently the plane has to be the xy
    plane.
    
    Thanks:
    
    This class was written by Philippe Pebay, Kitware SAS 2011. This work
    was supported by CEA/DIF - Commissariat a l'Energie Atomique, Centre
    DAM Ile-De-France, BP12, F-91297 Arpajon, France.
    
    .section See Also Actor AxisActor PolarAxesActor
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPolarAxesActor, obj, update, **traits)
    
    polar_tick_visibility = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the visibility of ticks for polar axis.
        """
    )
    def _polar_tick_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarTickVisibility,
                        self.polar_tick_visibility_)

    auto_subdivide_polar_axis = tvtk_base.true_bool_trait(help=\
        """
        Set/Get whether the number of polar axis ticks and arcs should be
        automatically calculated Default: true
        """
    )
    def _auto_subdivide_polar_axis_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAutoSubdividePolarAxis,
                        self.auto_subdivide_polar_axis_)

    polar_arcs_visibility = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the visibility of arcs for polar axis.
        """
    )
    def _polar_arcs_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarArcsVisibility,
                        self.polar_arcs_visibility_)

    radial_axes_visibility = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the visibility of non-polar radial axes.
        """
    )
    def _radial_axes_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRadialAxesVisibility,
                        self.radial_axes_visibility_)

    polar_axis_visibility = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the visibility of the polar axis.
        """
    )
    def _polar_axis_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarAxisVisibility,
                        self.polar_axis_visibility_)

    polar_title_visibility = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the visibility of titles for polar axis.
        """
    )
    def _polar_title_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarTitleVisibility,
                        self.polar_title_visibility_)

    radial_title_visibility = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the visibility of titles for non-polar radial
        axes.
        """
    )
    def _radial_title_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRadialTitleVisibility,
                        self.radial_title_visibility_)

    polar_label_visibility = tvtk_base.true_bool_trait(help=\
        """
        Turn on and off the visibility of labels for polar axis.
        """
    )
    def _polar_label_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarLabelVisibility,
                        self.polar_label_visibility_)

    polar_axis_title = traits.String(r"Radial Distance", enter_set=True, auto_set=False, help=\
        """
        Set/Get the labels for the polar axis. Default: "Radial
        Distance".
        """
    )
    def _polar_axis_title_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarAxisTitle,
                        self.polar_axis_title)

    def _get_radial_axes_property(self):
        return wrap_vtk(self._vtk_obj.GetRadialAxesProperty())
    def _set_radial_axes_property(self, arg):
        old_val = self._get_radial_axes_property()
        self._wrap_call(self._vtk_obj.SetRadialAxesProperty,
                        deref_vtk(arg))
        self.trait_property_changed('radial_axes_property', old_val, arg)
    radial_axes_property = traits.Property(_get_radial_axes_property, _set_radial_axes_property, help=\
        """
        Get/Set radial axes actors properties.
        """
    )

    def _get_polar_arcs_property(self):
        return wrap_vtk(self._vtk_obj.GetPolarArcsProperty())
    def _set_polar_arcs_property(self, arg):
        old_val = self._get_polar_arcs_property()
        self._wrap_call(self._vtk_obj.SetPolarArcsProperty,
                        deref_vtk(arg))
        self.trait_property_changed('polar_arcs_property', old_val, arg)
    polar_arcs_property = traits.Property(_get_polar_arcs_property, _set_polar_arcs_property, help=\
        """
        Get/Set polar arcs actors property
        """
    )

    def _get_polar_axis_property(self):
        return wrap_vtk(self._vtk_obj.GetPolarAxisProperty())
    def _set_polar_axis_property(self, arg):
        old_val = self._get_polar_axis_property()
        self._wrap_call(self._vtk_obj.SetPolarAxisProperty,
                        deref_vtk(arg))
        self.trait_property_changed('polar_axis_property', old_val, arg)
    polar_axis_property = traits.Property(_get_polar_axis_property, _set_polar_axis_property, help=\
        """
        Get/Set polar axis actor properties.
        """
    )

    def _get_camera(self):
        return wrap_vtk(self._vtk_obj.GetCamera())
    def _set_camera(self, arg):
        old_val = self._get_camera()
        self._wrap_call(self._vtk_obj.SetCamera,
                        deref_vtk(arg))
        self.trait_property_changed('camera', old_val, arg)
    camera = traits.Property(_get_camera, _set_camera, help=\
        """
        Set/Get the camera to perform scaling and translation of the
        PolarAxesActor.
        """
    )

    screen_size = traits.Float(10.0, enter_set=True, auto_set=False, help=\
        """
        Explicitly specify the screen size of title and label text.
        screen_size detemines the size of the text in terms of screen
        pixels. Default: 10.0.
        """
    )
    def _screen_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScreenSize,
                        self.screen_size)

    number_of_polar_axis_ticks = traits.Trait(-1, traits.Range(-1L, 200L, enter_set=True, auto_set=False), help=\
        """
        Gets/Sets the number of ticks and labels along polar axis NB:
        will be overriden if auto_subdivide_polar_axis is true
        """
    )
    def _number_of_polar_axis_ticks_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfPolarAxisTicks,
                        self.number_of_polar_axis_ticks)

    minimum_angle = traits.Float(0.0, enter_set=True, auto_set=False, help=\
        """
        Set/Get the minimum radius of the polar coordinates (in degrees).
        """
    )
    def _minimum_angle_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMinimumAngle,
                        self.minimum_angle)

    maximum_angle = traits.Float(90.0, enter_set=True, auto_set=False, help=\
        """
        Set/Get the maximum radius of the polar coordinates (in degrees).
        """
    )
    def _maximum_angle_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumAngle,
                        self.maximum_angle)

    distance_lod_threshold = traits.Trait(0.7, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), help=\
        """
        Set distance LOD threshold [0.0 - 1.0] for titles and labels.
        """
    )
    def _distance_lod_threshold_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDistanceLODThreshold,
                        self.distance_lod_threshold)

    bounds = traits.String(r"_00000000079a8700_p_void", enter_set=True, auto_set=False, help=\
        """
        
        """
    )
    def _bounds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBounds,
                        self.bounds)

    polar_label_format = traits.String(r"%-#6.3g", enter_set=True, auto_set=False, help=\
        """
        Set/Get the format with which to print the polar axis labels.
        """
    )
    def _polar_label_format_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolarLabelFormat,
                        self.polar_label_format)

    enable_view_angle_lod = traits.Int(1, enter_set=True, auto_set=False, help=\
        """
        Enable and disable the use of view angle based LOD for titles and
        labels.
        """
    )
    def _enable_view_angle_lod_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnableViewAngleLOD,
                        self.enable_view_angle_lod)

    def _get_polar_axis_title_text_property(self):
        return wrap_vtk(self._vtk_obj.GetPolarAxisTitleTextProperty())
    def _set_polar_axis_title_text_property(self, arg):
        old_val = self._get_polar_axis_title_text_property()
        self._wrap_call(self._vtk_obj.SetPolarAxisTitleTextProperty,
                        deref_vtk(arg))
        self.trait_property_changed('polar_axis_title_text_property', old_val, arg)
    polar_axis_title_text_property = traits.Property(_get_polar_axis_title_text_property, _set_polar_axis_title_text_property, help=\
        """
        Set/Get the polar axis title text property.
        """
    )

    auto_scale_radius = traits.Bool(False, help=\
        """
        Turn on and off the auto-scaling of the maximum radius. Default:
        false
        """
    )
    def _auto_scale_radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAutoScaleRadius,
                        self.auto_scale_radius)

    maximum_radius = traits.Float(1.0, enter_set=True, auto_set=False, help=\
        """
        Set/Get the maximum radius of the polar coordinates.
        """
    )
    def _maximum_radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumRadius,
                        self.maximum_radius)

    enable_distance_lod = traits.Int(1, enter_set=True, auto_set=False, help=\
        """
        Enable and disable the use of distance based LOD for titles and
        labels.
        """
    )
    def _enable_distance_lod_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnableDistanceLOD,
                        self.enable_distance_lod)

    def _get_polar_axis_label_text_property(self):
        return wrap_vtk(self._vtk_obj.GetPolarAxisLabelTextProperty())
    def _set_polar_axis_label_text_property(self, arg):
        old_val = self._get_polar_axis_label_text_property()
        self._wrap_call(self._vtk_obj.SetPolarAxisLabelTextProperty,
                        deref_vtk(arg))
        self.trait_property_changed('polar_axis_label_text_property', old_val, arg)
    polar_axis_label_text_property = traits.Property(_get_polar_axis_label_text_property, _set_polar_axis_label_text_property, help=\
        """
        Set/Get the polar axis labels text property.
        """
    )

    view_angle_lod_threshold = traits.Trait(0.3, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), help=\
        """
        Set view angle LOD threshold [0.0 - 1.0] for titles and labels.
        """
    )
    def _view_angle_lod_threshold_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetViewAngleLODThreshold,
                        self.view_angle_lod_threshold)

    smallest_visible_polar_angle = traits.Trait(0.5, traits.Range(0.0, 5.0, enter_set=True, auto_set=False), help=\
        """
        Set/Get the minimum radial angle distinguishable from polar axis
        NB: This is used only when polar axis is visible Default: 0.5
        """
    )
    def _smallest_visible_polar_angle_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSmallestVisiblePolarAngle,
                        self.smallest_visible_polar_angle)

    number_of_radial_axes = traits.Long(5, enter_set=True, auto_set=False, help=\
        """
        Gets/Sets the number of radial axes
        """
    )
    def _number_of_radial_axes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfRadialAxes,
                        self.number_of_radial_axes)

    radial_units = traits.Bool(True, help=\
        """
        Default: true
        """
    )
    def _radial_units_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRadialUnits,
                        self.radial_units)

    pole = traits.Array(shape=(3,), value=(0.0, 0.0, 0.0), dtype=float, enter_set=True, auto_set=False, cols=3, help=\
        """
        Explicitly specify the coordinate of the pole.
        """
    )
    def _pole_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPole,
                        self.pole)

    _updateable_traits_ = \
    (('origin', 'GetOrigin'), ('minimum_angle', 'GetMinimumAngle'),
    ('maximum_radius', 'GetMaximumRadius'), ('polar_arcs_visibility',
    'GetPolarArcsVisibility'), ('polar_label_format',
    'GetPolarLabelFormat'), ('enable_distance_lod',
    'GetEnableDistanceLOD'), ('screen_size', 'GetScreenSize'),
    ('visibility', 'GetVisibility'), ('view_angle_lod_threshold',
    'GetViewAngleLODThreshold'), ('debug', 'GetDebug'), ('pole',
    'GetPole'), ('polar_axis_title', 'GetPolarAxisTitle'),
    ('radial_units', 'GetRadialUnits'), ('radial_title_visibility',
    'GetRadialTitleVisibility'), ('render_time_multiplier',
    'GetRenderTimeMultiplier'), ('auto_subdivide_polar_axis',
    'GetAutoSubdividePolarAxis'), ('number_of_radial_axes',
    'GetNumberOfRadialAxes'), ('polar_title_visibility',
    'GetPolarTitleVisibility'), ('use_bounds', 'GetUseBounds'),
    ('enable_view_angle_lod', 'GetEnableViewAngleLOD'), ('orientation',
    'GetOrientation'), ('scale', 'GetScale'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('estimated_render_time',
    'GetEstimatedRenderTime'), ('dragable', 'GetDragable'),
    ('number_of_polar_axis_ticks', 'GetNumberOfPolarAxisTicks'),
    ('bounds', 'GetBounds'), ('auto_scale_radius', 'GetAutoScaleRadius'),
    ('polar_label_visibility', 'GetPolarLabelVisibility'),
    ('polar_axis_visibility', 'GetPolarAxisVisibility'),
    ('distance_lod_threshold', 'GetDistanceLODThreshold'), ('pickable',
    'GetPickable'), ('smallest_visible_polar_angle',
    'GetSmallestVisiblePolarAngle'), ('reference_count',
    'GetReferenceCount'), ('position', 'GetPosition'), ('maximum_angle',
    'GetMaximumAngle'), ('polar_tick_visibility',
    'GetPolarTickVisibility'), ('radial_axes_visibility',
    'GetRadialAxesVisibility'))
    
    _full_traitnames_list_ = \
    (['auto_subdivide_polar_axis', 'debug', 'dragable',
    'global_warning_display', 'pickable', 'polar_arcs_visibility',
    'polar_axis_visibility', 'polar_label_visibility',
    'polar_tick_visibility', 'polar_title_visibility',
    'radial_axes_visibility', 'radial_title_visibility', 'use_bounds',
    'visibility', 'auto_scale_radius', 'bounds', 'distance_lod_threshold',
    'enable_distance_lod', 'enable_view_angle_lod',
    'estimated_render_time', 'maximum_angle', 'maximum_radius',
    'minimum_angle', 'number_of_polar_axis_ticks',
    'number_of_radial_axes', 'orientation', 'origin', 'polar_axis_title',
    'polar_label_format', 'pole', 'position', 'radial_units',
    'render_time_multiplier', 'scale', 'screen_size',
    'smallest_visible_polar_angle', 'view_angle_lod_threshold'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PolarAxesActor, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit PolarAxesActor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['auto_subdivide_polar_axis', 'polar_arcs_visibility',
            'polar_axis_visibility', 'polar_label_visibility',
            'polar_tick_visibility', 'polar_title_visibility',
            'radial_axes_visibility', 'radial_title_visibility', 'use_bounds',
            'visibility'], [], ['auto_scale_radius', 'bounds',
            'distance_lod_threshold', 'enable_distance_lod',
            'enable_view_angle_lod', 'estimated_render_time', 'maximum_angle',
            'maximum_radius', 'minimum_angle', 'number_of_polar_axis_ticks',
            'number_of_radial_axes', 'orientation', 'origin', 'polar_axis_title',
            'polar_label_format', 'pole', 'position', 'radial_units',
            'render_time_multiplier', 'scale', 'screen_size',
            'smallest_visible_polar_angle', 'view_angle_lod_threshold']),
            title='Edit PolarAxesActor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PolarAxesActor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

