# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.multi_process_controller import MultiProcessController


class SocketController(MultiProcessController):
    """
    SocketController - Process communication using Sockets
    
    Superclass: MultiProcessController
    
    This is a concrete implementation of MultiProcessController. It
    supports one-to-one communication using sockets. Note that process 0
    will always correspond to self and process 1 to the remote process.
    This class is best used with ports.
    
    See Also:
    
    MultiProcessController SocketCommunicator InputPort
    OutputPort
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSocketController, obj, update, **traits)
    
    def _get_swap_bytes_in_received_data(self):
        return self._vtk_obj.GetSwapBytesInReceivedData()
    swap_bytes_in_received_data = traits.Property(_get_swap_bytes_in_received_data, help=\
        """
        
        """
    )

    def close_connection(self):
        """
        V.close_connection()
        C++: virtual void CloseConnection()
        Close a connection, forwarded to the communicator
        """
        ret = self._vtk_obj.CloseConnection()
        return ret
        

    def connect_to(self, *args):
        """
        V.connect_to(string, int) -> int
        C++: virtual int ConnectTo(const char *hostName, int port)
        Open a connection to a give machine, forwarded to the
        communicator
        """
        ret = self._wrap_call(self._vtk_obj.ConnectTo, *args)
        return ret

    def create_compliant_controller(self):
        """
        V.create_compliant_controller() -> MultiProcessController
        C++: MultiProcessController *CreateCompliantController()
        FOOLISH MORTALS!  Thou hast forsaken the sacred laws of ad-hoc
        polymorphism when thou broke a critical assumption of the
        superclass (namely, each process has thine own id).  The time
        frame to fix thy error has passed. Too much code has come to rely
        on this abhorrent behavior.  Instead, we offer this gift: a
        method for creating an equivalent communicator with correct
        process id semantics.  The calling code is responsible for
        deleting this controller.
        """
        ret = wrap_vtk(self._vtk_obj.CreateCompliantController())
        return ret
        

    def initialize(self):
        """
        V.initialize()
        C++: virtual void Initialize()
        This method is for initialiazing sockets. One of these is
        REQUIRED for Windows.
        """
        ret = self._vtk_obj.Initialize()
        return ret
        

    def set_communicator(self, *args):
        """
        V.set_communicator(SocketCommunicator)
        C++: void SetCommunicator(SocketCommunicator *comm)
        Set the communicator used in normal and rmi communications.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetCommunicator, *my_args)
        return ret

    def wait_for_connection(self, *args):
        """
        V.wait_for_connection(int) -> int
        C++: virtual int WaitForConnection(int port)
        Wait for connection on a given port, forwarded to the
        communicator
        """
        ret = self._wrap_call(self._vtk_obj.WaitForConnection, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('broadcast_trigger_rmi',
    'GetBroadcastTriggerRMI'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'),
    ('break_flag', 'GetBreakFlag'), ('number_of_processes',
    'GetNumberOfProcesses'))
    
    _full_traitnames_list_ = \
    (['broadcast_trigger_rmi', 'debug', 'global_warning_display',
    'break_flag', 'number_of_processes'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SocketController, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit SocketController properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['broadcast_trigger_rmi'], [], ['break_flag',
            'number_of_processes']),
            title='Edit SocketController properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SocketController properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

