# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

class SparseArray(tvtk_base.TVTKBase):
    """
    SparseArray - Sparse, independent coordinate storage for N-way
    arrays.
    
    Superclass: TypedArray[T]
    
    SparseArray is a concrete Array implementation that stores
    values using sparse independent coordinate storage.  This means that
    the array stores the complete set of coordinates and the value for
    each non-null value in the array. While this approach requires
    slightly more storage than other sparse storage schemes (such as
    Compressed-Row or Compressed-Column), it is easier and more efficient
    to work with when implementing algorithms, and  it generalizes well
    for arbitrary numbers of dimensions.
    
    In addition to the value retrieval and update methods provided by
    TypedArray, SparseArray provides methods to:
    
    Get and set a special 'null' value that will be returned when
    retrieving values for undefined coordinates.
    
    Clear the contents of the array so that every set of coordinates is
    undefined.
    
    Sort the array contents so that value coordinates can be visited in a
    specific order.
    
    Retrieve pointers to the value- and coordinate-storage memory blocks.
    
    Reserve storage for a specific number of non-null values, for
    efficiency when the number of non-null values is known in advance.
    
    Recompute the array extents so that they bound the largest set of
    non-NULL values along each dimension.
    
    Specify arbitrary array extents.
    
    Add values to the array in amortized-constant time.
    
    Validate that the array does not contain duplicate coordinates.
    
    See Also:
    
    Array, TypedArray, DenseArray
    
    Thanks:
    
    Developed by Timothy M. Shead (tshead@sandia.gov) at Sandia National
    Laboratories.
    
    
    Provided Types:
    
      SparseArray[char] => SparseArray<char>
      SparseArray[int8] => SparseArray<signed char>
      SparseArray[uint8] => SparseArray<unsigned char>
      SparseArray[int16] => SparseArray<short>
      SparseArray[uint16] => SparseArray<unsigned short>
      SparseArray[int32] => SparseArray<int>
      SparseArray[uint32] => SparseArray<unsigned int>
      SparseArray[int] => SparseArray<long>
      SparseArray[uint] => SparseArray<unsigned long>
      SparseArray[int64] => SparseArray<long long>
      SparseArray[uint64] => SparseArray<unsigned long long>
      SparseArray[float32] => SparseArray<float>
      SparseArray[float64] => SparseArray<double>
      SparseArray[str] => SparseArray<vtkStdString>
      SparseArray[unicode] => SparseArray<vtkUnicodeString>
      SparseArray[vtkVariant] => SparseArray<vtkVariant>
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSparseArray, obj, update, **traits)
    
    _updateable_traits_ = \
    ()
    
    _full_traitnames_list_ = \
    ([])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SparseArray, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit SparseArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], []),
            title='Edit SparseArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SparseArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

