# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.painter import Painter


class SurfaceLICPainter(Painter):
    """
    SurfaceLICPainter - painter that performs LIC on the surface of
    
    Superclass: Painter
    
    SurfaceLICPainter painter performs LIC on the surface of arbitrary
     geometry. Point vectors are used as the vector field for generating
    the LIC.
     The implementation was originallu  based on "Image Space Based
    Visualization
     on Unsteady Flow on Surfaces" by Laramee, Jobard and Hauser appeared
    in
     proceedings of IEEE Visualization '03, pages 131-138.
    
    
     Internal pipeline:
    
    noise
        |
        [ PROJ (GAT) (COMP) lic2d (SCAT) SHADE (CCE) DEP]
        |                                               | vectors        
                                    surface LIC  PROj  - prject vectors
    onto surface GAT   - gather data for compositing and guard pixel
    generation  (parallel only) COMP  - composite gathered data lic2d -
    line intengral convolution, see LineIntegralConvolution2D. SCAT  -
    scatter result (parallel only, not all compositors use it) SHADE -
    combine LIC and scalar colors CCE   - color contrast enhancement
    (optional) DEP   - depth test and copy to back buffer
    
    The result of each stage is cached in a texture so that during
    interaction a stage may be skipped if the user has not modified its
    paramters or input data.
    
    The parallel parts of algorithm are implemented in
    PSurfaceLICPainter. Note that for MPI enabled builds this class
    will be automatically created by the object factory.
    
    See also:
    
    SurfaceLICDefaultPainter LineIntegralConvolution2D
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSurfaceLICPainter, obj, update, **traits)
    
    enhanced_lic = tvtk_base.true_bool_trait(help=\
        """
        enhanced_lic mean compute the LIC twice with the second pass using
        the edge-enhanced result of the first pass as a noise texture.
        Edge enhancedment is made by a simple Laplace convolution.
        """
    )
    def _enhanced_lic_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnhancedLIC,
                        self.enhanced_lic_)

    normalize_vectors = tvtk_base.true_bool_trait(help=\
        """
        Normalize vectors during integration. When set(the default) the
        input vector field is normalized during integration, and each
        integration occurs over the same arclength. When not set each
        integration occurs over an arc length proportional to the field
        magnitude as is customary in traditional numerical methods. See, "Imaging Vector Fields Using Line Integral
        Convolution" for an axample where normalization is used. See,
        "Image Space Based Visualization of Unsteady Flow on Surfaces"
        for an example of where no normalization is used.
        """
    )
    def _normalize_vectors_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormalizeVectors,
                        self.normalize_vectors_)

    anti_alias = tvtk_base.false_bool_trait(help=\
        """
        Enable/Disable the anti-aliasing pass. This optional pass
        (disabled by default) can be enabled to reduce jagged patterns in
        the final LIC image. Values greater than 0 control the number of
        iterations, 1 is typically sufficient.
        """
    )
    def _anti_alias_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAntiAlias,
                        self.anti_alias_)

    mask_on_surface = tvtk_base.false_bool_trait(help=\
        """
        When set mask_on_surface computes |V| for use in the fragment
        masking tests on the surface. When not set the original
        un-projected un-transformed |V| is used.
        """
    )
    def _mask_on_surface_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaskOnSurface,
                        self.mask_on_surface_)

    lic_intensity = traits.Float(0.8, enter_set=True, auto_set=False, help=\
        """
        Factor used when blend mode is set to COLOR_MODE_BLEND. This
        controls the contribution of the LIC in the final output image as
        follows:
        
        
          c = LIC * LICIntensity + scalar * (1 - LICIntensity);
        
        0.0 produces same result as disabling LIC altogether, while 1.0
        implies show LIC result alone.
        """
    )
    def _lic_intensity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLICIntensity,
                        self.lic_intensity)

    noise_generator_seed = traits.Int(1, enter_set=True, auto_set=False, help=\
        """
        Set/Get the seed value used by the random number generator.
        """
    )
    def _noise_generator_seed_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNoiseGeneratorSeed,
                        self.noise_generator_seed)

    color_mode = traits.Int(0, enter_set=True, auto_set=False, help=\
        """
        Set/Get the color mode. The color mode controls how scalar colors
        are combined with the LIC in the final image. The BLEND mode
        combines scalar colors with LIC intensities with proportional
        blending controled by the LICIntensity parameter. The MAP mode
        combines scalar colors with LIC, by multiplication the HSL
        represntation of color's lightness.
        
        The default is COLOR_MODE_BLEND.
        """
    )
    def _color_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetColorMode,
                        self.color_mode)

    mask_intensity = traits.Float(0.0, enter_set=True, auto_set=False, help=\
        """
        The mask_intensity controls the blending of the mask color and the
        geometry color. The color of masked fragments is given by:
        
        
            c = mask_color * mask_intensity + geom_color * (1 -
        mask_intensity)
        
        The default value of 0.0 results in the geometry color being
        used.
        """
    )
    def _mask_intensity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaskIntensity,
                        self.mask_intensity)

    number_of_noise_levels = traits.Int(256, enter_set=True, auto_set=False, help=\
        """
        Set/Get the number of discrete values a noise pixel may take on.
        Default 1024.
        """
    )
    def _number_of_noise_levels_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfNoiseLevels,
                        self.number_of_noise_levels)

    noise_type = traits.Int(1, enter_set=True, auto_set=False, help=\
        """
        Select the statistical distribution of randomly generated noise
        values. With uniform noise there is greater control over the
        range of values in the noise texture. The Default is
        NOISE_TYPE_GAUSSIAN.
        """
    )
    def _noise_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNoiseType,
                        self.noise_type)

    enable = traits.Int(1, enter_set=True, auto_set=False, help=\
        """
        Enable/Disable this painter.
        """
    )
    def _enable_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnable,
                        self.enable)

    number_of_steps = traits.Int(20, enter_set=True, auto_set=False, help=\
        """
        Get/Set the number of integration steps in each direction.
        """
    )
    def _number_of_steps_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfSteps,
                        self.number_of_steps)

    low_color_contrast_enhancement_factor = traits.Float(0.0, enter_set=True, auto_set=False, help=\
        """
        
        """
    )
    def _low_color_contrast_enhancement_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLowColorContrastEnhancementFactor,
                        self.low_color_contrast_enhancement_factor)

    mask_color = tvtk_base.vtk_color_trait((0.5, 0.5, 0.5), help=\
        """
        The mask_color is used on masked fragments. The default of (0.5,
        0.5, 0.5) makes the masked fragments look similar to the LIC'd
        fragments. The mask color is applied only when mask_intensity > 0.
        """
    )
    def _mask_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaskColor,
                        self.mask_color, False)

    high_color_contrast_enhancement_factor = traits.Float(0.0, enter_set=True, auto_set=False, help=\
        """
        
        """
    )
    def _high_color_contrast_enhancement_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHighColorContrastEnhancementFactor,
                        self.high_color_contrast_enhancement_factor)

    enhance_contrast = traits.Int(0, enter_set=True, auto_set=False, help=\
        """
        Enable/Disable contrast and dynamic range correction stages.
        Contrast enhancement can be enabled during LIC computations (See
        LineINtegralComvolution2D) and after the scalar colors have
        been combined with the LIC.
        
        The best appraoch for using this feature is to enable LIC
        enhancement, and only if the image is to dark or dull enable
        COLOR enhancement.
        
        Both stages are implemented by a histogram stretching algorithm.
        During LIC stages the contrast enhancement is applied to gray
        scale LIC image. During the scalar coloring stage the contrast
        enhancement is applied to the lightness channel of the color
        image in HSL color space. The histogram stretching is implemented
        as follows:
        
        
            L = (L-m)/(M-m)
        
        where, L is the fragment intensity/lightness, m is the
        intensity/lightness to map to 0, M is the intensity/lightness to
        map to 1. The default values of m and M are the min and max taken
        over all fragments.
        
        This increase the dynamic range and contrast in the LIC'd image,
        both of which are natuarly attenuated by the convolution
        proccess.
        
        Values
        
        
          ENHANCE_CONTRAST_OFF   -- don't enhance LIC or scalar colors
          ENHANCE_CONTRAST_LIC   -- enhance in LIC high-pass input and
        output
          ENHANCE_CONTRAST_COLOR -- enhance after scalars are combined
        with LIC
          ENHANCE_CONTRAST_BOTH  -- enhance in LIC stages and after
        scalar colors
        
        This feature is disabled by default.
        """
    )
    def _enhance_contrast_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnhanceContrast,
                        self.enhance_contrast)

    low_lic_contrast_enhancement_factor = traits.Float(0.0, enter_set=True, auto_set=False, help=\
        """
        This feature is used to fine tune the contrast enhancement. There
        are two modes AUTOMATIC and MANUAL.In AUTOMATIC mode values are
        provided indicating the fraction of the range to adjust M and m
        by, during contrast enahncement histogram stretching. M and m are
        the intensity/lightness values that map to 1 and 0. (see
        enhance_contrast for an explanation of the mapping procedure). m
        and M are computed using the factors as follows:
        
        
            m = min(C) + m_factor * (max(C) - min(C))
            M = max(C) - MFactor * (max(C) - min(C))
        
        the default values for m_factor and MFactor are 0 which result in
        m = min(C), M = max(C), taken over the entire image. Modifying
        m_factor and MFactor above or below zero provide control over the
        saturation/ de-saturation during contrast enhancement.
        """
    )
    def _low_lic_contrast_enhancement_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLowLICContrastEnhancementFactor,
                        self.low_lic_contrast_enhancement_factor)

    step_size = traits.Float(1.0, enter_set=True, auto_set=False, help=\
        """
        Get/Set the step size (in pixels).
        """
    )
    def _step_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStepSize,
                        self.step_size)

    noise_grain_size = traits.Int(1, enter_set=True, auto_set=False, help=\
        """
        Set/Get the side length in pixels of the noise values in the
        noise texture. Each noise value will be length^2 pixels in area.
        """
    )
    def _noise_grain_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNoiseGrainSize,
                        self.noise_grain_size)

    mask_threshold = traits.Float(0.0, enter_set=True, auto_set=False, help=\
        """
        The mask_threshold controls the rendering of fragments in stagnant
        regions of flow.  // In these regions LIC noise texture will be
        masked, where |V| < mask_threshold is satisifed. The masking
        process blends a the mask_color with the scalar color of the
        surface proportional to mask_intesnsity. See mask_intensity for
        more information on the blending algorithm. This blending allows
        one control over the masking process so that masked fragments may
        be: highlighted (by setting a unique mask color and mask
        intensity > 0), made invisible with and without passing the
        un-convolved noise texture (by setting mask intensity 0), made to
        blend into the LIC.
        
        mask_threshold units are in the original vector space. Note that
        the threshold can be applied to the original vector field or to
        the surface projected vector field. See mask_on_surface.
        """
    )
    def _mask_threshold_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaskThreshold,
                        self.mask_threshold)

    impulse_noise_background_value = traits.Float(0.0, enter_set=True, auto_set=False, help=\
        """
        The color to use for untouched pixels when impulse noise
        probability < 1.
        """
    )
    def _impulse_noise_background_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetImpulseNoiseBackgroundValue,
                        self.impulse_noise_background_value)

    max_noise_value = traits.Float(0.8, enter_set=True, auto_set=False, help=\
        """
        Set/Get the minimum and mximum  gray scale values that the
        generated noise can take on. The generated noise will be in the
        range of min_noise_value to max_noise_value. Values are clamped
        within 0 to 1. min_noise_value must be less than max_noise_value.
        """
    )
    def _max_noise_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaxNoiseValue,
                        self.max_noise_value)

    composite_strategy = traits.Int(3, enter_set=True, auto_set=False, help=\
        """
        Control the screen space decomposition where LIC is computed.
        """
    )
    def _composite_strategy_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCompositeStrategy,
                        self.composite_strategy)

    noise_texture_size = traits.Int(200, enter_set=True, auto_set=False, help=\
        """
        Set/Get the side length in pixels of the noise texture. The
        texture will be length^2 pixels in area.
        """
    )
    def _noise_texture_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNoiseTextureSize,
                        self.noise_texture_size)

    min_noise_value = traits.Float(0.0, enter_set=True, auto_set=False, help=\
        """
        Set/Get the minimum and mximum  gray scale values that the
        generated noise can take on. The generated noise will be in the
        range of min_noise_value to max_noise_value. Values are clamped
        within 0 to 1. min_noise_value must be less than max_noise_value.
        """
    )
    def _min_noise_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMinNoiseValue,
                        self.min_noise_value)

    generate_noise_texture = traits.Int(0, enter_set=True, auto_set=False, help=\
        """
        Set/Get the noise texture source. When not set the default
        200x200 white noise texture is used (see
        VTKData/Data/Data/noise.png). When set a noise texture is
        generated based on the following parameters:
        
        
           noise_type               - select noise type. Gaussian,
        Uniform, etc
           noise_texture_size        - number of pixels in square noise
        texture(side)
           noise_grain_size          - number of pixels each noise value
        spans(side)
           min_noise_value           - minimum noise color >=0 && <
        max_noise_value
           max_noise_value           - maximum noise color <=1 ** >
        min_noise_value
           number_of_noise_levels     - number of discrete noise colors
           impulse_noise_probability - impulse noise is generated when < 1
           impulse_noise_background_value  - the background color for
        untouched pixels
           noise_generator_seed      - seed the random number generators
        
        Changing the noise texture gives one greater control over the
        look of the final image. The default is 0 which results in the
        use of a static 200x200 Gaussian noise texture. See
        VTKData/Data/Data/noise.png.
        """
    )
    def _generate_noise_texture_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateNoiseTexture,
                        self.generate_noise_texture)

    high_lic_contrast_enhancement_factor = traits.Float(0.0, enter_set=True, auto_set=False, help=\
        """
        This feature is used to fine tune the contrast enhancement. There
        are two modes AUTOMATIC and MANUAL.In AUTOMATIC mode values are
        provided indicating the fraction of the range to adjust M and m
        by, during contrast enahncement histogram stretching. M and m are
        the intensity/lightness values that map to 1 and 0. (see
        enhance_contrast for an explanation of the mapping procedure). m
        and M are computed using the factors as follows:
        
        
            m = min(C) + m_factor * (max(C) - min(C))
            M = max(C) - MFactor * (max(C) - min(C))
        
        the default values for m_factor and MFactor are 0 which result in
        m = min(C), M = max(C), taken over the entire image. Modifying
        m_factor and MFactor above or below zero provide control over the
        saturation/ de-saturation during contrast enhancement.
        """
    )
    def _high_lic_contrast_enhancement_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHighLICContrastEnhancementFactor,
                        self.high_lic_contrast_enhancement_factor)

    impulse_noise_probability = traits.Float(1.0, enter_set=True, auto_set=False, help=\
        """
        Control the density of of the noise. A value of 1.0 produces
        uniform random noise while values < 1.0 produce impulse noise
        with the given probabilty.
        """
    )
    def _impulse_noise_probability_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetImpulseNoiseProbability,
                        self.impulse_noise_probability)

    def _get_noise_data_set(self):
        return wrap_vtk(self._vtk_obj.GetNoiseDataSet())
    def _set_noise_data_set(self, arg):
        old_val = self._get_noise_data_set()
        self._wrap_call(self._vtk_obj.SetNoiseDataSet,
                        deref_vtk(arg))
        self.trait_property_changed('noise_data_set', old_val, arg)
    noise_data_set = traits.Property(_get_noise_data_set, _set_noise_data_set, help=\
        """
        Set the data containing a noise array as active scalars. Active
        scalars array will be converted into a texture for use as noise
        in the LIC process. Noise datasets are expected to be gray scale.
        """
    )

    map_mode_bias = traits.Float(0.0, enter_set=True, auto_set=False, help=\
        """
        Factor used when blend mode is set to COLOR_MODE_MAP. This adds a
        bias to the LIC image. The purpose of this is to adjust the
        brightness when a brighter image is desired. The default of 0.0
        results in no change. Values gretaer than 0.0 will brighten the
        image while values less than 0.0 darken the image.
        """
    )
    def _map_mode_bias_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMapModeBias,
                        self.map_mode_bias)

    def is_supported(self, *args):
        """
        V.is_supported(RenderWindow) -> bool
        C++: static bool IsSupported(RenderWindow *context)
        Returns true if the rendering context supports extensions needed
        by this painter.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.IsSupported, *my_args)
        return ret

    def set_enable_off(self):
        """
        V.set_enable_off()
        C++: void SetEnableOff()
        Enable/Disable this painter.
        """
        ret = self._vtk_obj.SetEnableOff()
        return ret
        

    def set_enable_on(self):
        """
        V.set_enable_on()
        C++: void SetEnableOn()
        Enable/Disable this painter.
        """
        ret = self._vtk_obj.SetEnableOn()
        return ret
        

    def set_input_array_to_process(self, *args):
        """
        V.set_input_array_to_process(int, string)
        C++: void SetInputArrayToProcess(int fieldAssociation,
            const char *name)
        V.set_input_array_to_process(int, int)
        C++: void SetInputArrayToProcess(int fieldAssociation,
            int fieldAttributeType)
        Set the vectors to used for applying LIC. By default point
        vectors are used. Arguments are same as those passed to
        Algorithm::SetInputArrayToProcess except the first 3 arguments
        i.e. idx, port, connection.
        """
        ret = self._wrap_call(self._vtk_obj.SetInputArrayToProcess, *args)
        return ret

    def write_timer_log(self, *args):
        """
        V.write_timer_log(string)
        C++: virtual void WriteTimerLog(const char *)
        Methods used for parallel benchmarks. Use cmake to define
        SurfaceLICPainterTIME to enable benchmarks. During each update
        timing information is stored, it can be written to disk by
        calling write_log.
        """
        ret = self._wrap_call(self._vtk_obj.WriteTimerLog, *args)
        return ret

    _updateable_traits_ = \
    (('enable', 'GetEnable'), ('generate_noise_texture',
    'GetGenerateNoiseTexture'), ('noise_grain_size', 'GetNoiseGrainSize'),
    ('normalize_vectors', 'GetNormalizeVectors'), ('min_noise_value',
    'GetMinNoiseValue'), ('impulse_noise_background_value',
    'GetImpulseNoiseBackgroundValue'), ('anti_alias', 'GetAntiAlias'),
    ('mask_intensity', 'GetMaskIntensity'), ('debug', 'GetDebug'),
    ('number_of_steps', 'GetNumberOfSteps'), ('enhance_contrast',
    'GetEnhanceContrast'), ('noise_generator_seed',
    'GetNoiseGeneratorSeed'), ('number_of_noise_levels',
    'GetNumberOfNoiseLevels'), ('lic_intensity', 'GetLICIntensity'),
    ('high_lic_contrast_enhancement_factor',
    'GetHighLICContrastEnhancementFactor'), ('map_mode_bias',
    'GetMapModeBias'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('composite_strategy',
    'GetCompositeStrategy'), ('color_mode', 'GetColorMode'),
    ('mask_threshold', 'GetMaskThreshold'), ('noise_texture_size',
    'GetNoiseTextureSize'), ('enhanced_lic', 'GetEnhancedLIC'),
    ('mask_on_surface', 'GetMaskOnSurface'), ('mask_color',
    'GetMaskColor'), ('step_size', 'GetStepSize'), ('max_noise_value',
    'GetMaxNoiseValue'), ('reference_count', 'GetReferenceCount'),
    ('progress', 'GetProgress'), ('low_color_contrast_enhancement_factor',
    'GetLowColorContrastEnhancementFactor'), ('impulse_noise_probability',
    'GetImpulseNoiseProbability'), ('low_lic_contrast_enhancement_factor',
    'GetLowLICContrastEnhancementFactor'),
    ('high_color_contrast_enhancement_factor',
    'GetHighColorContrastEnhancementFactor'), ('noise_type',
    'GetNoiseType'))
    
    _full_traitnames_list_ = \
    (['anti_alias', 'debug', 'enhanced_lic', 'global_warning_display',
    'mask_on_surface', 'normalize_vectors', 'color_mode',
    'composite_strategy', 'enable', 'enhance_contrast',
    'generate_noise_texture', 'high_color_contrast_enhancement_factor',
    'high_lic_contrast_enhancement_factor',
    'impulse_noise_background_value', 'impulse_noise_probability',
    'lic_intensity', 'low_color_contrast_enhancement_factor',
    'low_lic_contrast_enhancement_factor', 'map_mode_bias', 'mask_color',
    'mask_intensity', 'mask_threshold', 'max_noise_value',
    'min_noise_value', 'noise_generator_seed', 'noise_grain_size',
    'noise_texture_size', 'noise_type', 'number_of_noise_levels',
    'number_of_steps', 'step_size'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SurfaceLICPainter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit SurfaceLICPainter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['anti_alias', 'enhanced_lic', 'mask_on_surface',
            'normalize_vectors'], [], ['color_mode', 'composite_strategy',
            'enable', 'enhance_contrast', 'generate_noise_texture',
            'high_color_contrast_enhancement_factor',
            'high_lic_contrast_enhancement_factor',
            'impulse_noise_background_value', 'impulse_noise_probability',
            'lic_intensity', 'low_color_contrast_enhancement_factor',
            'low_lic_contrast_enhancement_factor', 'map_mode_bias', 'mask_color',
            'mask_intensity', 'mask_threshold', 'max_noise_value',
            'min_noise_value', 'noise_generator_seed', 'noise_grain_size',
            'noise_texture_size', 'noise_type', 'number_of_noise_levels',
            'number_of_steps', 'step_size']),
            title='Edit SurfaceLICPainter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SurfaceLICPainter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

