import vtk
from tvtk import tvtk_base
from tvtk.common import get_tvtk_name, camel2enthought

# Caches all the classes.
_cache = {}

def set_ancestors(klass):
    tmp = klass.__bases__
    if not tmp:
        return
    # Assuming a single inheritance.
    tmp = tmp[0]
    name = tmp.__name__
    while not _cache.has_key(name) and                     name not in ['TVTKBase', 'object']:
        _cache[name] = tmp
        tmp = tmp.__bases__[0]
        name = tmp.__name__

def get_module(fname):
    try:
        mod = __import__('tvtk.custom.%s'%fname,
                         globals(), locals(), [fname])
    except ImportError:
        # This is a local import since the tvtk modules are all
        # inside the tvtk_classes ZIP file and are local to the
        # current module: tvtk_helper.py
        mod = __import__('tvtk.tvtk_classes.%s'%fname, globals(), locals(), [fname])
    return mod

def get_class(name):
    if _cache.has_key(name):
        return _cache[name]
    else:
        fname = camel2enthought(name)
        mod = get_module(fname)
        klass = getattr(mod, name)
        _cache[name] = klass
        set_ancestors(klass)
        return klass

def wrap_vtk(obj):
    if isinstance(obj, tvtk_base.TVTKBase):
        return obj
    elif isinstance(obj, vtk.vtkObjectBase):
        cached_obj = tvtk_base.get_tvtk_object_from_cache(obj)
        if cached_obj is not None:
            return cached_obj
        cname = get_tvtk_name(obj.__class__.__name__)
        tvtk_class = get_class(cname)
        return tvtk_class(obj)
    else:
        return obj


class TVTK(object):
    to_tvtk = staticmethod(wrap_vtk)
    to_vtk = staticmethod(tvtk_base.deref_vtk)

    Color3 = property(lambda self: get_class('Color3'))
    Color4 = property(lambda self: get_class('Color4'))
    DenseArray = property(lambda self: get_class('DenseArray'))
    ObjectBase = property(lambda self: get_class('ObjectBase'))
    Quaternion = property(lambda self: get_class('Quaternion'))
    Rect = property(lambda self: get_class('Rect'))
    SparseArray = property(lambda self: get_class('SparseArray'))
    Tuple = property(lambda self: get_class('Tuple'))
    TypedArray = property(lambda self: get_class('TypedArray'))
    Vector = property(lambda self: get_class('Vector'))
    Vector2 = property(lambda self: get_class('Vector2'))
    Vector3 = property(lambda self: get_class('Vector3'))
    Command = property(lambda self: get_class('Command'))
    InformationKey = property(lambda self: get_class('InformationKey'))
    Object = property(lambda self: get_class('Object'))
    AMRDataSetCache = property(lambda self: get_class('AMRDataSetCache'))
    AMRInformation = property(lambda self: get_class('AMRInformation'))
    AMRUtilities = property(lambda self: get_class('AMRUtilities'))
    AbstractArray = property(lambda self: get_class('AbstractArray'))
    AbstractContextBufferId = property(lambda self: get_class('AbstractContextBufferId'))
    AbstractContextItem = property(lambda self: get_class('AbstractContextItem'))
    AbstractGridConnectivity = property(lambda self: get_class('AbstractGridConnectivity'))
    AbstractImageInterpolator = property(lambda self: get_class('AbstractImageInterpolator'))
    AbstractPicker = property(lambda self: get_class('AbstractPicker'))
    AbstractTransform = property(lambda self: get_class('AbstractTransform'))
    AdjacentVertexIterator = property(lambda self: get_class('AdjacentVertexIterator'))
    Algorithm = property(lambda self: get_class('Algorithm'))
    AlgorithmOutput = property(lambda self: get_class('AlgorithmOutput'))
    AmoebaMinimizer = property(lambda self: get_class('AmoebaMinimizer'))
    AnimationCue = property(lambda self: get_class('AnimationCue'))
    AreaLayoutStrategy = property(lambda self: get_class('AreaLayoutStrategy'))
    Array = property(lambda self: get_class('Array'))
    ArrayIterator = property(lambda self: get_class('ArrayIterator'))
    AssemblyNode = property(lambda self: get_class('AssemblyNode'))
    AxisExtended = property(lambda self: get_class('AxisExtended'))
    BSPIntersections = property(lambda self: get_class('BSPIntersections'))
    BackgroundColorMonitor = property(lambda self: get_class('BackgroundColorMonitor'))
    Base64Utilities = property(lambda self: get_class('Base64Utilities'))
    Brush = property(lambda self: get_class('Brush'))
    ByteSwap = property(lambda self: get_class('ByteSwap'))
    CPExodusIIElementBlockImpl = property(lambda self: get_class('CPExodusIIElementBlockImpl'))
    Camera = property(lambda self: get_class('Camera'))
    CameraInterpolator = property(lambda self: get_class('CameraInterpolator'))
    Cell = property(lambda self: get_class('Cell'))
    CellArray = property(lambda self: get_class('CellArray'))
    CellIterator = property(lambda self: get_class('CellIterator'))
    CellLinks = property(lambda self: get_class('CellLinks'))
    CellTypes = property(lambda self: get_class('CellTypes'))
    CirclePackLayoutStrategy = property(lambda self: get_class('CirclePackLayoutStrategy'))
    CoincidentPoints = property(lambda self: get_class('CoincidentPoints'))
    Collection = property(lambda self: get_class('Collection'))
    CollectionIterator = property(lambda self: get_class('CollectionIterator'))
    ColorMaterialHelper = property(lambda self: get_class('ColorMaterialHelper'))
    ColorSeries = property(lambda self: get_class('ColorSeries'))
    Communicator = property(lambda self: get_class('Communicator'))
    CompositeDataDisplayAttributes = property(lambda self: get_class('CompositeDataDisplayAttributes'))
    CompositeDataIterator = property(lambda self: get_class('CompositeDataIterator'))
    ConditionVariable = property(lambda self: get_class('ConditionVariable'))
    Context2D = property(lambda self: get_class('Context2D'))
    ContextScene = property(lambda self: get_class('ContextScene'))
    ContourLineInterpolator = property(lambda self: get_class('ContourLineInterpolator'))
    ContourValues = property(lambda self: get_class('ContourValues'))
    Coordinate = property(lambda self: get_class('Coordinate'))
    CriticalSection = property(lambda self: get_class('CriticalSection'))
    Culler = property(lambda self: get_class('Culler'))
    DSPFilterDefinition = property(lambda self: get_class('DSPFilterDefinition'))
    DSPFilterGroup = property(lambda self: get_class('DSPFilterGroup'))
    DataArraySelection = property(lambda self: get_class('DataArraySelection'))
    DataCompressor = property(lambda self: get_class('DataCompressor'))
    DataObject = property(lambda self: get_class('DataObject'))
    DataObjectTypes = property(lambda self: get_class('DataObjectTypes'))
    DataTransferHelper = property(lambda self: get_class('DataTransferHelper'))
    DebugLeaks = property(lambda self: get_class('DebugLeaks'))
    DirectionEncoder = property(lambda self: get_class('DirectionEncoder'))
    Directory = property(lambda self: get_class('Directory'))
    DistributedGraphHelper = property(lambda self: get_class('DistributedGraphHelper'))
    DynamicLoader = property(lambda self: get_class('DynamicLoader'))
    EdgeLayoutStrategy = property(lambda self: get_class('EdgeLayoutStrategy'))
    EdgeListIterator = property(lambda self: get_class('EdgeListIterator'))
    EdgeSubdivisionCriterion = property(lambda self: get_class('EdgeSubdivisionCriterion'))
    EdgeTable = property(lambda self: get_class('EdgeTable'))
    EncodedGradientEstimator = property(lambda self: get_class('EncodedGradientEstimator'))
    EncodedGradientShader = property(lambda self: get_class('EncodedGradientShader'))
    Event = property(lambda self: get_class('Event'))
    ExecutionTimer = property(lambda self: get_class('ExecutionTimer'))
    Executive = property(lambda self: get_class('Executive'))
    ExodusIICache = property(lambda self: get_class('ExodusIICache'))
    Exporter = property(lambda self: get_class('Exporter'))
    ExtentRCBPartitioner = property(lambda self: get_class('ExtentRCBPartitioner'))
    ExtentSplitter = property(lambda self: get_class('ExtentSplitter'))
    ExtentTranslator = property(lambda self: get_class('ExtentTranslator'))
    ExtractStructuredGridHelper = property(lambda self: get_class('ExtractStructuredGridHelper'))
    FastNumericConversion = property(lambda self: get_class('FastNumericConversion'))
    FieldData = property(lambda self: get_class('FieldData'))
    FieldDataSerializer = property(lambda self: get_class('FieldDataSerializer'))
    FixedPointRayCastImage = property(lambda self: get_class('FixedPointRayCastImage'))
    FixedPointVolumeRayCastHelper = property(lambda self: get_class('FixedPointVolumeRayCastHelper'))
    FrameBufferObject = property(lambda self: get_class('FrameBufferObject'))
    FrameBufferObject2 = property(lambda self: get_class('FrameBufferObject2'))
    FunctionParser = property(lambda self: get_class('FunctionParser'))
    FunctionSet = property(lambda self: get_class('FunctionSet'))
    GL2PSUtilities = property(lambda self: get_class('GL2PSUtilities'))
    GPUInfo = property(lambda self: get_class('GPUInfo'))
    GPUInfoList = property(lambda self: get_class('GPUInfoList'))
    GarbageCollector = property(lambda self: get_class('GarbageCollector'))
    GenericAdaptorCell = property(lambda self: get_class('GenericAdaptorCell'))
    GenericAttribute = property(lambda self: get_class('GenericAttribute'))
    GenericAttributeCollection = property(lambda self: get_class('GenericAttributeCollection'))
    GenericCellIterator = property(lambda self: get_class('GenericCellIterator'))
    GenericCellTessellator = property(lambda self: get_class('GenericCellTessellator'))
    GenericEdgeTable = property(lambda self: get_class('GenericEdgeTable'))
    GenericPointIterator = property(lambda self: get_class('GenericPointIterator'))
    GenericSubdivisionErrorMetric = property(lambda self: get_class('GenericSubdivisionErrorMetric'))
    GenericVertexAttributeMapping = property(lambda self: get_class('GenericVertexAttributeMapping'))
    GeoCamera = property(lambda self: get_class('GeoCamera'))
    GeoMath = property(lambda self: get_class('GeoMath'))
    GeoProjection = property(lambda self: get_class('GeoProjection'))
    GeoSource = property(lambda self: get_class('GeoSource'))
    GeoTerrain = property(lambda self: get_class('GeoTerrain'))
    GeoTreeNode = property(lambda self: get_class('GeoTreeNode'))
    GeoTreeNodeCache = property(lambda self: get_class('GeoTreeNodeCache'))
    GhostArray = property(lambda self: get_class('GhostArray'))
    GlobFileNames = property(lambda self: get_class('GlobFileNames'))
    GraphEdge = property(lambda self: get_class('GraphEdge'))
    GraphInternals = property(lambda self: get_class('GraphInternals'))
    GraphLayoutStrategy = property(lambda self: get_class('GraphLayoutStrategy'))
    GraphicsFactory = property(lambda self: get_class('GraphicsFactory'))
    HardwareSelector = property(lambda self: get_class('HardwareSelector'))
    Heap = property(lambda self: get_class('Heap'))
    HierarchicalGraphPipeline = property(lambda self: get_class('HierarchicalGraphPipeline'))
    HyperOctreeCursor = property(lambda self: get_class('HyperOctreeCursor'))
    HyperOctreePointsGrabber = property(lambda self: get_class('HyperOctreePointsGrabber'))
    HyperTree = property(lambda self: get_class('HyperTree'))
    HyperTreeCursor = property(lambda self: get_class('HyperTreeCursor'))
    IdList = property(lambda self: get_class('IdList'))
    ImageConnector = property(lambda self: get_class('ImageConnector'))
    ImageOrthoPlanes = property(lambda self: get_class('ImageOrthoPlanes'))
    ImageProperty = property(lambda self: get_class('ImageProperty'))
    ImageReader2Factory = property(lambda self: get_class('ImageReader2Factory'))
    ImageViewer = property(lambda self: get_class('ImageViewer'))
    ImageViewer2 = property(lambda self: get_class('ImageViewer2'))
    ImplicitFunction = property(lambda self: get_class('ImplicitFunction'))
    Importer = property(lambda self: get_class('Importer'))
    InEdgeIterator = property(lambda self: get_class('InEdgeIterator'))
    IncrementalForceLayout = property(lambda self: get_class('IncrementalForceLayout'))
    IncrementalOctreeNode = property(lambda self: get_class('IncrementalOctreeNode'))
    Information = property(lambda self: get_class('Information'))
    InformationDataObjectKey = property(lambda self: get_class('InformationDataObjectKey'))
    InformationDoubleKey = property(lambda self: get_class('InformationDoubleKey'))
    InformationDoubleVectorKey = property(lambda self: get_class('InformationDoubleVectorKey'))
    InformationExecutivePortKey = property(lambda self: get_class('InformationExecutivePortKey'))
    InformationExecutivePortVectorKey = property(lambda self: get_class('InformationExecutivePortVectorKey'))
    InformationIdTypeKey = property(lambda self: get_class('InformationIdTypeKey'))
    InformationInformationKey = property(lambda self: get_class('InformationInformationKey'))
    InformationInformationVectorKey = property(lambda self: get_class('InformationInformationVectorKey'))
    InformationIntegerKey = property(lambda self: get_class('InformationIntegerKey'))
    InformationIntegerPointerKey = property(lambda self: get_class('InformationIntegerPointerKey'))
    InformationIntegerVectorKey = property(lambda self: get_class('InformationIntegerVectorKey'))
    InformationIterator = property(lambda self: get_class('InformationIterator'))
    InformationKeyVectorKey = property(lambda self: get_class('InformationKeyVectorKey'))
    InformationObjectBaseKey = property(lambda self: get_class('InformationObjectBaseKey'))
    InformationObjectBaseVectorKey = property(lambda self: get_class('InformationObjectBaseVectorKey'))
    InformationQuadratureSchemeDefinitionVectorKey = property(lambda self: get_class('InformationQuadratureSchemeDefinitionVectorKey'))
    InformationRequestKey = property(lambda self: get_class('InformationRequestKey'))
    InformationStringKey = property(lambda self: get_class('InformationStringKey'))
    InformationStringVectorKey = property(lambda self: get_class('InformationStringVectorKey'))
    InformationUnsignedLongKey = property(lambda self: get_class('InformationUnsignedLongKey'))
    InformationVariantKey = property(lambda self: get_class('InformationVariantKey'))
    InformationVariantVectorKey = property(lambda self: get_class('InformationVariantVectorKey'))
    InformationVector = property(lambda self: get_class('InformationVector'))
    InitialValueProblemSolver = property(lambda self: get_class('InitialValueProblemSolver'))
    InputStream = property(lambda self: get_class('InputStream'))
    Instantiator = property(lambda self: get_class('Instantiator'))
    InteractorObserver = property(lambda self: get_class('InteractorObserver'))
    KMeansDistanceFunctor = property(lambda self: get_class('KMeansDistanceFunctor'))
    KdNode = property(lambda self: get_class('KdNode'))
    LabelHierarchyIterator = property(lambda self: get_class('LabelHierarchyIterator'))
    LabelRenderStrategy = property(lambda self: get_class('LabelRenderStrategy'))
    Light = property(lambda self: get_class('Light'))
    LightKit = property(lambda self: get_class('LightKit'))
    Locator = property(lambda self: get_class('Locator'))
    MINCImageAttributes = property(lambda self: get_class('MINCImageAttributes'))
    MarkerUtilities = property(lambda self: get_class('MarkerUtilities'))
    Math = property(lambda self: get_class('Math'))
    MathTextUtilities = property(lambda self: get_class('MathTextUtilities'))
    Matrix3x3 = property(lambda self: get_class('Matrix3x3'))
    Matrix4x4 = property(lambda self: get_class('Matrix4x4'))
    MeanValueCoordinatesInterpolator = property(lambda self: get_class('MeanValueCoordinatesInterpolator'))
    MedicalImageProperties = property(lambda self: get_class('MedicalImageProperties'))
    MergeCells = property(lambda self: get_class('MergeCells'))
    ModelMetadata = property(lambda self: get_class('ModelMetadata'))
    MultiProcessController = property(lambda self: get_class('MultiProcessController'))
    MultiThreader = property(lambda self: get_class('MultiThreader'))
    MutableGraphHelper = property(lambda self: get_class('MutableGraphHelper'))
    MutexLock = property(lambda self: get_class('MutexLock'))
    NIFTIImageHeader = property(lambda self: get_class('NIFTIImageHeader'))
    NamedColors = property(lambda self: get_class('NamedColors'))
    ObjectFactory = property(lambda self: get_class('ObjectFactory'))
    ObserverMediator = property(lambda self: get_class('ObserverMediator'))
    OctreePointLocatorNode = property(lambda self: get_class('OctreePointLocatorNode'))
    OpenGLExtensionManager = property(lambda self: get_class('OpenGLExtensionManager'))
    OpenGLHardwareSupport = property(lambda self: get_class('OpenGLHardwareSupport'))
    OpenGLLightMonitor = property(lambda self: get_class('OpenGLLightMonitor'))
    OpenGLModelViewProjectionMonitor = property(lambda self: get_class('OpenGLModelViewProjectionMonitor'))
    OrderedTriangulator = property(lambda self: get_class('OrderedTriangulator'))
    OutEdgeIterator = property(lambda self: get_class('OutEdgeIterator'))
    OutputStream = property(lambda self: get_class('OutputStream'))
    OutputWindow = property(lambda self: get_class('OutputWindow'))
    OverrideInformation = property(lambda self: get_class('OverrideInformation'))
    Painter = property(lambda self: get_class('Painter'))
    PainterDeviceAdapter = property(lambda self: get_class('PainterDeviceAdapter'))
    ParametricFunction = property(lambda self: get_class('ParametricFunction'))
    Pen = property(lambda self: get_class('Pen'))
    PeriodicTable = property(lambda self: get_class('PeriodicTable'))
    PickingManager = property(lambda self: get_class('PickingManager'))
    PipelineSize = property(lambda self: get_class('PipelineSize'))
    PixelBufferObject = property(lambda self: get_class('PixelBufferObject'))
    PointPlacer = property(lambda self: get_class('PointPlacer'))
    Points = property(lambda self: get_class('Points'))
    Points2D = property(lambda self: get_class('Points2D'))
    PolynomialSolversUnivariate = property(lambda self: get_class('PolynomialSolversUnivariate'))
    PriorityQueue = property(lambda self: get_class('PriorityQueue'))
    Process = property(lambda self: get_class('Process'))
    ProcessGroup = property(lambda self: get_class('ProcessGroup'))
    ProgressObserver = property(lambda self: get_class('ProgressObserver'))
    Prop = property(lambda self: get_class('Prop'))
    Property = property(lambda self: get_class('Property'))
    Property2D = property(lambda self: get_class('Property2D'))
    QuadratureSchemeDefinition = property(lambda self: get_class('QuadratureSchemeDefinition'))
    QuaternionInterpolator = property(lambda self: get_class('QuaternionInterpolator'))
    RandomSequence = property(lambda self: get_class('RandomSequence'))
    RayCastImageDisplayHelper = property(lambda self: get_class('RayCastImageDisplayHelper'))
    ReebGraphSimplificationMetric = property(lambda self: get_class('ReebGraphSimplificationMetric'))
    ReferenceCount = property(lambda self: get_class('ReferenceCount'))
    RenderPass = property(lambda self: get_class('RenderPass'))
    RenderWindowInteractor = property(lambda self: get_class('RenderWindowInteractor'))
    Renderbuffer = property(lambda self: get_class('Renderbuffer'))
    RendererDelegate = property(lambda self: get_class('RendererDelegate'))
    ResliceCursor = property(lambda self: get_class('ResliceCursor'))
    ResliceImageViewerMeasurements = property(lambda self: get_class('ResliceImageViewerMeasurements'))
    RowQuery = property(lambda self: get_class('RowQuery'))
    SQLDatabase = property(lambda self: get_class('SQLDatabase'))
    SQLDatabaseSchema = property(lambda self: get_class('SQLDatabaseSchema'))
    ScalarTree = property(lambda self: get_class('ScalarTree'))
    ScalarsToColors = property(lambda self: get_class('ScalarsToColors'))
    ScenePicker = property(lambda self: get_class('ScenePicker'))
    SelectionNode = property(lambda self: get_class('SelectionNode'))
    ShaderDeviceAdapter2 = property(lambda self: get_class('ShaderDeviceAdapter2'))
    SliceCubes = property(lambda self: get_class('SliceCubes'))
    Socket = property(lambda self: get_class('Socket'))
    SortDataArray = property(lambda self: get_class('SortDataArray'))
    SortFileNames = property(lambda self: get_class('SortFileNames'))
    Spline = property(lambda self: get_class('Spline'))
    StreamingTessellator = property(lambda self: get_class('StreamingTessellator'))
    StringToImage = property(lambda self: get_class('StringToImage'))
    StructuredData = property(lambda self: get_class('StructuredData'))
    StructuredExtent = property(lambda self: get_class('StructuredExtent'))
    StructuredVisibilityConstraint = property(lambda self: get_class('StructuredVisibilityConstraint'))
    SubGroup = property(lambda self: get_class('SubGroup'))
    TDxInteractorStyle = property(lambda self: get_class('TDxInteractorStyle'))
    TDxInteractorStyleSettings = property(lambda self: get_class('TDxInteractorStyleSettings'))
    Tensor = property(lambda self: get_class('Tensor'))
    TextCodec = property(lambda self: get_class('TextCodec'))
    TextCodecFactory = property(lambda self: get_class('TextCodecFactory'))
    TextProperty = property(lambda self: get_class('TextProperty'))
    TextRenderer = property(lambda self: get_class('TextRenderer'))
    TextureObject = property(lambda self: get_class('TextureObject'))
    ThreadMessager = property(lambda self: get_class('ThreadMessager'))
    TimePointUtility = property(lambda self: get_class('TimePointUtility'))
    TimerLog = property(lambda self: get_class('TimerLog'))
    Transform2D = property(lambda self: get_class('Transform2D'))
    TransformInterpolator = property(lambda self: get_class('TransformInterpolator'))
    TreeIterator = property(lambda self: get_class('TreeIterator'))
    TupleInterpolator = property(lambda self: get_class('TupleInterpolator'))
    UniformVariables = property(lambda self: get_class('UniformVariables'))
    UnstructuredGridVolumeRayCastFunction = property(lambda self: get_class('UnstructuredGridVolumeRayCastFunction'))
    UnstructuredGridVolumeRayCastIterator = property(lambda self: get_class('UnstructuredGridVolumeRayCastIterator'))
    UnstructuredGridVolumeRayIntegrator = property(lambda self: get_class('UnstructuredGridVolumeRayIntegrator'))
    Version = property(lambda self: get_class('Version'))
    VertexListIterator = property(lambda self: get_class('VertexListIterator'))
    View = property(lambda self: get_class('View'))
    ViewTheme = property(lambda self: get_class('ViewTheme'))
    ViewUpdater = property(lambda self: get_class('ViewUpdater'))
    Viewport = property(lambda self: get_class('Viewport'))
    VisibilitySort = property(lambda self: get_class('VisibilitySort'))
    VoidArray = property(lambda self: get_class('VoidArray'))
    VolumeProperty = property(lambda self: get_class('VolumeProperty'))
    VolumeRayCastFunction = property(lambda self: get_class('VolumeRayCastFunction'))
    WidgetCallbackMapper = property(lambda self: get_class('WidgetCallbackMapper'))
    WidgetEvent = property(lambda self: get_class('WidgetEvent'))
    WidgetEventTranslator = property(lambda self: get_class('WidgetEventTranslator'))
    WidgetSet = property(lambda self: get_class('WidgetSet'))
    Window = property(lambda self: get_class('Window'))
    XMLDataElement = property(lambda self: get_class('XMLDataElement'))
    XMLHierarchicalBoxDataFileConverter = property(lambda self: get_class('XMLHierarchicalBoxDataFileConverter'))
    XMLParser = property(lambda self: get_class('XMLParser'))
    XMLUtilities = property(lambda self: get_class('XMLUtilities'))
    ThreeDSImporter = property(lambda self: get_class('ThreeDSImporter'))
    ThreeDWidget = property(lambda self: get_class('ThreeDWidget'))
    ASCIITextCodec = property(lambda self: get_class('ASCIITextCodec'))
    AbstractCellLocator = property(lambda self: get_class('AbstractCellLocator'))
    AbstractElectronicData = property(lambda self: get_class('AbstractElectronicData'))
    AbstractInterpolatedVelocityField = property(lambda self: get_class('AbstractInterpolatedVelocityField'))
    AbstractMapper = property(lambda self: get_class('AbstractMapper'))
    AbstractPointLocator = property(lambda self: get_class('AbstractPointLocator'))
    AbstractPropPicker = property(lambda self: get_class('AbstractPropPicker'))
    AbstractWidget = property(lambda self: get_class('AbstractWidget'))
    Actor2D = property(lambda self: get_class('Actor2D'))
    AnimationScene = property(lambda self: get_class('AnimationScene'))
    Annotation = property(lambda self: get_class('Annotation'))
    AnnotationLayers = property(lambda self: get_class('AnnotationLayers'))
    AnnotationLayersAlgorithm = property(lambda self: get_class('AnnotationLayersAlgorithm'))
    ArcParallelEdgeStrategy = property(lambda self: get_class('ArcParallelEdgeStrategy'))
    ArrayData = property(lambda self: get_class('ArrayData'))
    ArrayDataAlgorithm = property(lambda self: get_class('ArrayDataAlgorithm'))
    AssemblyPath = property(lambda self: get_class('AssemblyPath'))
    AssemblyPaths = property(lambda self: get_class('AssemblyPaths'))
    AssignCoordinatesLayoutStrategy = property(lambda self: get_class('AssignCoordinatesLayoutStrategy'))
    AttributeClustering2DLayoutStrategy = property(lambda self: get_class('AttributeClustering2DLayoutStrategy'))
    AttributesErrorMetric = property(lambda self: get_class('AttributesErrorMetric'))
    BSPCuts = property(lambda self: get_class('BSPCuts'))
    Base64InputStream = property(lambda self: get_class('Base64InputStream'))
    Base64OutputStream = property(lambda self: get_class('Base64OutputStream'))
    BezierContourLineInterpolator = property(lambda self: get_class('BezierContourLineInterpolator'))
    BitArrayIterator = property(lambda self: get_class('BitArrayIterator'))
    BoundedPlanePointPlacer = property(lambda self: get_class('BoundedPlanePointPlacer'))
    Box = property(lambda self: get_class('Box'))
    CachingInterpolatedVelocityField = property(lambda self: get_class('CachingInterpolatedVelocityField'))
    CameraPass = property(lambda self: get_class('CameraPass'))
    CardinalSpline = property(lambda self: get_class('CardinalSpline'))
    Cell3D = property(lambda self: get_class('Cell3D'))
    CellCenterDepthSort = property(lambda self: get_class('CellCenterDepthSort'))
    CellCentersPointPlacer = property(lambda self: get_class('CellCentersPointPlacer'))
    ChartMatrix = property(lambda self: get_class('ChartMatrix'))
    CirclePackFrontChainLayoutStrategy = property(lambda self: get_class('CirclePackFrontChainLayoutStrategy'))
    CircularLayoutStrategy = property(lambda self: get_class('CircularLayoutStrategy'))
    ClearRGBPass = property(lambda self: get_class('ClearRGBPass'))
    ClearZPass = property(lambda self: get_class('ClearZPass'))
    ClientSocket = property(lambda self: get_class('ClientSocket'))
    ClipPlanesPainter = property(lambda self: get_class('ClipPlanesPainter'))
    ClosedSurfacePointPlacer = property(lambda self: get_class('ClosedSurfacePointPlacer'))
    Clustering2DLayoutStrategy = property(lambda self: get_class('Clustering2DLayoutStrategy'))
    ColorTransferFunction = property(lambda self: get_class('ColorTransferFunction'))
    Community2DLayoutStrategy = property(lambda self: get_class('Community2DLayoutStrategy'))
    CompositeDataSet = property(lambda self: get_class('CompositeDataSet'))
    CompositeDataSetAlgorithm = property(lambda self: get_class('CompositeDataSetAlgorithm'))
    CompositePainter = property(lambda self: get_class('CompositePainter'))
    Cone = property(lambda self: get_class('Cone'))
    ConeLayoutStrategy = property(lambda self: get_class('ConeLayoutStrategy'))
    Constrained2DLayoutStrategy = property(lambda self: get_class('Constrained2DLayoutStrategy'))
    ContextActor = property(lambda self: get_class('ContextActor'))
    ContextClip = property(lambda self: get_class('ContextClip'))
    ContextItem = property(lambda self: get_class('ContextItem'))
    ContextMapper2D = property(lambda self: get_class('ContextMapper2D'))
    ContextTransform = property(lambda self: get_class('ContextTransform'))
    CosmicTreeLayoutStrategy = property(lambda self: get_class('CosmicTreeLayoutStrategy'))
    CullerCollection = property(lambda self: get_class('CullerCollection'))
    Cylinder = property(lambda self: get_class('Cylinder'))
    DataArray = property(lambda self: get_class('DataArray'))
    DataArrayCollection = property(lambda self: get_class('DataArrayCollection'))
    DataArrayCollectionIterator = property(lambda self: get_class('DataArrayCollectionIterator'))
    DataObjectAlgorithm = property(lambda self: get_class('DataObjectAlgorithm'))
    DataObjectCollection = property(lambda self: get_class('DataObjectCollection'))
    DataObjectTreeIterator = property(lambda self: get_class('DataObjectTreeIterator'))
    DataReader = property(lambda self: get_class('DataReader'))
    DataSet = property(lambda self: get_class('DataSet'))
    DataSetAlgorithm = property(lambda self: get_class('DataSetAlgorithm'))
    DataSetAttributes = property(lambda self: get_class('DataSetAttributes'))
    DataSetCellIterator = property(lambda self: get_class('DataSetCellIterator'))
    DataSetCollection = property(lambda self: get_class('DataSetCollection'))
    DataSetEdgeSubdivisionCriterion = property(lambda self: get_class('DataSetEdgeSubdivisionCriterion'))
    DefaultPainter = property(lambda self: get_class('DefaultPainter'))
    DefaultPass = property(lambda self: get_class('DefaultPass'))
    DemandDrivenPipeline = property(lambda self: get_class('DemandDrivenPipeline'))
    DepthPeelingPass = property(lambda self: get_class('DepthPeelingPass'))
    DijkstraImageContourLineInterpolator = property(lambda self: get_class('DijkstraImageContourLineInterpolator'))
    DirectXGPUInfoList = property(lambda self: get_class('DirectXGPUInfoList'))
    DirectedGraphAlgorithm = property(lambda self: get_class('DirectedGraphAlgorithm'))
    DisplayListPainter = property(lambda self: get_class('DisplayListPainter'))
    DummyCommunicator = property(lambda self: get_class('DummyCommunicator'))
    DummyController = property(lambda self: get_class('DummyController'))
    EmptyCell = property(lambda self: get_class('EmptyCell'))
    EnsembleSource = property(lambda self: get_class('EnsembleSource'))
    Fast2DLayoutStrategy = property(lambda self: get_class('Fast2DLayoutStrategy'))
    FileOutputWindow = property(lambda self: get_class('FileOutputWindow'))
    FiniteDifferenceGradientEstimator = property(lambda self: get_class('FiniteDifferenceGradientEstimator'))
    FixedPointVolumeRayCastCompositeGOHelper = property(lambda self: get_class('FixedPointVolumeRayCastCompositeGOHelper'))
    FixedPointVolumeRayCastCompositeGOShadeHelper = property(lambda self: get_class('FixedPointVolumeRayCastCompositeGOShadeHelper'))
    FixedPointVolumeRayCastCompositeHelper = property(lambda self: get_class('FixedPointVolumeRayCastCompositeHelper'))
    FixedPointVolumeRayCastCompositeShadeHelper = property(lambda self: get_class('FixedPointVolumeRayCastCompositeShadeHelper'))
    FixedPointVolumeRayCastMIPHelper = property(lambda self: get_class('FixedPointVolumeRayCastMIPHelper'))
    FocalPlanePointPlacer = property(lambda self: get_class('FocalPlanePointPlacer'))
    ForceDirectedLayoutStrategy = property(lambda self: get_class('ForceDirectedLayoutStrategy'))
    FreeTypeLabelRenderStrategy = property(lambda self: get_class('FreeTypeLabelRenderStrategy'))
    FreeTypeStringToImage = property(lambda self: get_class('FreeTypeStringToImage'))
    FrustumCoverageCuller = property(lambda self: get_class('FrustumCoverageCuller'))
    GL2PSExporter = property(lambda self: get_class('GL2PSExporter'))
    GLSLShaderDeviceAdapter2 = property(lambda self: get_class('GLSLShaderDeviceAdapter2'))
    GaussianRandomSequence = property(lambda self: get_class('GaussianRandomSequence'))
    GeneralTransform = property(lambda self: get_class('GeneralTransform'))
    GenericCell = property(lambda self: get_class('GenericCell'))
    GenericDataSet = property(lambda self: get_class('GenericDataSet'))
    GenericInterpolatedVelocityField = property(lambda self: get_class('GenericInterpolatedVelocityField'))
    GenericRenderWindowInteractor = property(lambda self: get_class('GenericRenderWindowInteractor'))
    GeoAlignedImageSource = property(lambda self: get_class('GeoAlignedImageSource'))
    GeoEdgeStrategy = property(lambda self: get_class('GeoEdgeStrategy'))
    GeoFileImageSource = property(lambda self: get_class('GeoFileImageSource'))
    GeoFileTerrainSource = property(lambda self: get_class('GeoFileTerrainSource'))
    GeoGlobeSource = property(lambda self: get_class('GeoGlobeSource'))
    GeoImageNode = property(lambda self: get_class('GeoImageNode'))
    GeoProjectionSource = property(lambda self: get_class('GeoProjectionSource'))
    GeoSphereTransform = property(lambda self: get_class('GeoSphereTransform'))
    GeoTerrain2D = property(lambda self: get_class('GeoTerrain2D'))
    GeoTerrainNode = property(lambda self: get_class('GeoTerrainNode'))
    GeoTransform = property(lambda self: get_class('GeoTransform'))
    GeometricErrorMetric = property(lambda self: get_class('GeometricErrorMetric'))
    Graph = property(lambda self: get_class('Graph'))
    GraphAlgorithm = property(lambda self: get_class('GraphAlgorithm'))
    HierarchicalBoxDataSetAlgorithm = property(lambda self: get_class('HierarchicalBoxDataSetAlgorithm'))
    HomogeneousTransform = property(lambda self: get_class('HomogeneousTransform'))
    HyperOctreeAlgorithm = property(lambda self: get_class('HyperOctreeAlgorithm'))
    HyperOctreeClipCutPointsGrabber = property(lambda self: get_class('HyperOctreeClipCutPointsGrabber'))
    HyperTreeGridAlgorithm = property(lambda self: get_class('HyperTreeGridAlgorithm'))
    IVExporter = property(lambda self: get_class('IVExporter'))
    IdListCollection = property(lambda self: get_class('IdListCollection'))
    ImageActorPointPlacer = property(lambda self: get_class('ImageActorPointPlacer'))
    ImageAlgorithm = property(lambda self: get_class('ImageAlgorithm'))
    ImageBSplineInterpolator = property(lambda self: get_class('ImageBSplineInterpolator'))
    ImageInterpolator = property(lambda self: get_class('ImageInterpolator'))
    ImageProcessingPass = property(lambda self: get_class('ImageProcessingPass'))
    ImageReader2Collection = property(lambda self: get_class('ImageReader2Collection'))
    ImageSincInterpolator = property(lambda self: get_class('ImageSincInterpolator'))
    ImageStencilAlgorithm = property(lambda self: get_class('ImageStencilAlgorithm'))
    ImageStencilData = property(lambda self: get_class('ImageStencilData'))
    ImplicitBoolean = property(lambda self: get_class('ImplicitBoolean'))
    ImplicitDataSet = property(lambda self: get_class('ImplicitDataSet'))
    ImplicitFunctionCollection = property(lambda self: get_class('ImplicitFunctionCollection'))
    ImplicitHalo = property(lambda self: get_class('ImplicitHalo'))
    ImplicitPolyDataDistance = property(lambda self: get_class('ImplicitPolyDataDistance'))
    ImplicitSelectionLoop = property(lambda self: get_class('ImplicitSelectionLoop'))
    ImplicitSum = property(lambda self: get_class('ImplicitSum'))
    ImplicitVolume = property(lambda self: get_class('ImplicitVolume'))
    ImplicitWindowFunction = property(lambda self: get_class('ImplicitWindowFunction'))
    InformationDataObjectMetaDataKey = property(lambda self: get_class('InformationDataObjectMetaDataKey'))
    InformationIntegerRequestKey = property(lambda self: get_class('InformationIntegerRequestKey'))
    InteractorEventRecorder = property(lambda self: get_class('InteractorEventRecorder'))
    InteractorStyle = property(lambda self: get_class('InteractorStyle'))
    KMeansDistanceFunctorCalculator = property(lambda self: get_class('KMeansDistanceFunctorCalculator'))
    KdTree = property(lambda self: get_class('KdTree'))
    KochanekSpline = property(lambda self: get_class('KochanekSpline'))
    LSDynaSummaryParser = property(lambda self: get_class('LSDynaSummaryParser'))
    LabelHierarchyAlgorithm = property(lambda self: get_class('LabelHierarchyAlgorithm'))
    LabelHierarchyCompositeIterator = property(lambda self: get_class('LabelHierarchyCompositeIterator'))
    LegendScaleActor = property(lambda self: get_class('LegendScaleActor'))
    LightCollection = property(lambda self: get_class('LightCollection'))
    LightsPass = property(lambda self: get_class('LightsPass'))
    Line = property(lambda self: get_class('Line'))
    LinearContourLineInterpolator = property(lambda self: get_class('LinearContourLineInterpolator'))
    LookupTable = property(lambda self: get_class('LookupTable'))
    MNITransformReader = property(lambda self: get_class('MNITransformReader'))
    MNITransformWriter = property(lambda self: get_class('MNITransformWriter'))
    MapperCollection = property(lambda self: get_class('MapperCollection'))
    MathTextFreeTypeTextRenderer = property(lambda self: get_class('MathTextFreeTypeTextRenderer'))
    MinimalStandardRandomSequence = property(lambda self: get_class('MinimalStandardRandomSequence'))
    MoleculeAlgorithm = property(lambda self: get_class('MoleculeAlgorithm'))
    MultiBlockDataSetAlgorithm = property(lambda self: get_class('MultiBlockDataSetAlgorithm'))
    MultiTimeStepAlgorithm = property(lambda self: get_class('MultiTimeStepAlgorithm'))
    NonLinearCell = property(lambda self: get_class('NonLinearCell'))
    OBJExporter = property(lambda self: get_class('OBJExporter'))
    OOGLExporter = property(lambda self: get_class('OOGLExporter'))
    ObjectFactoryCollection = property(lambda self: get_class('ObjectFactoryCollection'))
    OpenGLCamera = property(lambda self: get_class('OpenGLCamera'))
    OpenGLHardwareSelector = property(lambda self: get_class('OpenGLHardwareSelector'))
    OpenGLLight = property(lambda self: get_class('OpenGLLight'))
    OpenGLPainterDeviceAdapter = property(lambda self: get_class('OpenGLPainterDeviceAdapter'))
    OpenGLProperty = property(lambda self: get_class('OpenGLProperty'))
    OpenGLRayCastImageDisplayHelper = property(lambda self: get_class('OpenGLRayCastImageDisplayHelper'))
    OrientationMarkerWidget = property(lambda self: get_class('OrientationMarkerWidget'))
    OverrideInformationCollection = property(lambda self: get_class('OverrideInformationCollection'))
    POVExporter = property(lambda self: get_class('POVExporter'))
    ParallelAMRUtilities = property(lambda self: get_class('ParallelAMRUtilities'))
    ParametricBoy = property(lambda self: get_class('ParametricBoy'))
    ParametricConicSpiral = property(lambda self: get_class('ParametricConicSpiral'))
    ParametricCrossCap = property(lambda self: get_class('ParametricCrossCap'))
    ParametricDini = property(lambda self: get_class('ParametricDini'))
    ParametricEllipsoid = property(lambda self: get_class('ParametricEllipsoid'))
    ParametricEnneper = property(lambda self: get_class('ParametricEnneper'))
    ParametricFigure8Klein = property(lambda self: get_class('ParametricFigure8Klein'))
    ParametricKlein = property(lambda self: get_class('ParametricKlein'))
    ParametricMobius = property(lambda self: get_class('ParametricMobius'))
    ParametricRandomHills = property(lambda self: get_class('ParametricRandomHills'))
    ParametricRoman = property(lambda self: get_class('ParametricRoman'))
    ParametricSpline = property(lambda self: get_class('ParametricSpline'))
    ParametricSuperEllipsoid = property(lambda self: get_class('ParametricSuperEllipsoid'))
    ParametricSuperToroid = property(lambda self: get_class('ParametricSuperToroid'))
    ParametricTorus = property(lambda self: get_class('ParametricTorus'))
    PassInputTypeAlgorithm = property(lambda self: get_class('PassInputTypeAlgorithm'))
    PassThroughEdgeStrategy = property(lambda self: get_class('PassThroughEdgeStrategy'))
    PassThroughLayoutStrategy = property(lambda self: get_class('PassThroughLayoutStrategy'))
    PerlinNoise = property(lambda self: get_class('PerlinNoise'))
    PieceRequestFilter = property(lambda self: get_class('PieceRequestFilter'))
    PiecewiseFunction = property(lambda self: get_class('PiecewiseFunction'))
    PiecewiseFunctionAlgorithm = property(lambda self: get_class('PiecewiseFunctionAlgorithm'))
    Pixel = property(lambda self: get_class('Pixel'))
    Plane = property(lambda self: get_class('Plane'))
    PlaneCollection = property(lambda self: get_class('PlaneCollection'))
    Planes = property(lambda self: get_class('Planes'))
    PointSetAlgorithm = property(lambda self: get_class('PointSetAlgorithm'))
    PointSetCellIterator = property(lambda self: get_class('PointSetCellIterator'))
    PointsProjectedHull = property(lambda self: get_class('PointsProjectedHull'))
    PolyDataAlgorithm = property(lambda self: get_class('PolyDataAlgorithm'))
    PolyDataCollection = property(lambda self: get_class('PolyDataCollection'))
    PolyDataContourLineInterpolator = property(lambda self: get_class('PolyDataContourLineInterpolator'))
    PolyDataPainter = property(lambda self: get_class('PolyDataPainter'))
    PolyDataPointPlacer = property(lambda self: get_class('PolyDataPointPlacer'))
    PolyLine = property(lambda self: get_class('PolyLine'))
    PolyPlane = property(lambda self: get_class('PolyPlane'))
    PolyVertex = property(lambda self: get_class('PolyVertex'))
    Polygon = property(lambda self: get_class('Polygon'))
    Prop3D = property(lambda self: get_class('Prop3D'))
    PropAssembly = property(lambda self: get_class('PropAssembly'))
    PropCollection = property(lambda self: get_class('PropCollection'))
    PythonAlgorithm = property(lambda self: get_class('PythonAlgorithm'))
    Quad = property(lambda self: get_class('Quad'))
    Quadric = property(lambda self: get_class('Quadric'))
    RIBExporter = property(lambda self: get_class('RIBExporter'))
    RIBLight = property(lambda self: get_class('RIBLight'))
    RIBProperty = property(lambda self: get_class('RIBProperty'))
    RandomLayoutStrategy = property(lambda self: get_class('RandomLayoutStrategy'))
    RectilinearGridAlgorithm = property(lambda self: get_class('RectilinearGridAlgorithm'))
    RecursiveSphereDirectionEncoder = property(lambda self: get_class('RecursiveSphereDirectionEncoder'))
    RenderLargeImage = property(lambda self: get_class('RenderLargeImage'))
    RenderPassCollection = property(lambda self: get_class('RenderPassCollection'))
    RenderViewBase = property(lambda self: get_class('RenderViewBase'))
    RenderWindow = property(lambda self: get_class('RenderWindow'))
    RenderWindowCollection = property(lambda self: get_class('RenderWindowCollection'))
    Renderer = property(lambda self: get_class('Renderer'))
    RendererCollection = property(lambda self: get_class('RendererCollection'))
    RendererSource = property(lambda self: get_class('RendererSource'))
    ResliceImageViewer = property(lambda self: get_class('ResliceImageViewer'))
    RungeKutta2 = property(lambda self: get_class('RungeKutta2'))
    RungeKutta4 = property(lambda self: get_class('RungeKutta4'))
    RungeKutta45 = property(lambda self: get_class('RungeKutta45'))
    SCurveSpline = property(lambda self: get_class('SCurveSpline'))
    SQLQuery = property(lambda self: get_class('SQLQuery'))
    SQLiteDatabase = property(lambda self: get_class('SQLiteDatabase'))
    ScalarsToColorsPainter = property(lambda self: get_class('ScalarsToColorsPainter'))
    Selection = property(lambda self: get_class('Selection'))
    SelectionAlgorithm = property(lambda self: get_class('SelectionAlgorithm'))
    SequencePass = property(lambda self: get_class('SequencePass'))
    ServerSocket = property(lambda self: get_class('ServerSocket'))
    ShadowMapBakerPass = property(lambda self: get_class('ShadowMapBakerPass'))
    ShadowMapPass = property(lambda self: get_class('ShadowMapPass'))
    Simple2DLayoutStrategy = property(lambda self: get_class('Simple2DLayoutStrategy'))
    Simple3DCirclesStrategy = property(lambda self: get_class('Simple3DCirclesStrategy'))
    SimpleCellTessellator = property(lambda self: get_class('SimpleCellTessellator'))
    SimpleScalarTree = property(lambda self: get_class('SimpleScalarTree'))
    SmoothErrorMetric = property(lambda self: get_class('SmoothErrorMetric'))
    SocketCollection = property(lambda self: get_class('SocketCollection'))
    SocketCommunicator = property(lambda self: get_class('SocketCommunicator'))
    SocketController = property(lambda self: get_class('SocketController'))
    SpanTreeLayoutStrategy = property(lambda self: get_class('SpanTreeLayoutStrategy'))
    Sphere = property(lambda self: get_class('Sphere'))
    SphericalDirectionEncoder = property(lambda self: get_class('SphericalDirectionEncoder'))
    StackedTreeLayoutStrategy = property(lambda self: get_class('StackedTreeLayoutStrategy'))
    StreamerBase = property(lambda self: get_class('StreamerBase'))
    StringArray = property(lambda self: get_class('StringArray'))
    StructuredAMRGridConnectivity = property(lambda self: get_class('StructuredAMRGridConnectivity'))
    StructuredGridAlgorithm = property(lambda self: get_class('StructuredGridAlgorithm'))
    StructuredGridConnectivity = property(lambda self: get_class('StructuredGridConnectivity'))
    StructuredPointsCollection = property(lambda self: get_class('StructuredPointsCollection'))
    SubCommunicator = property(lambda self: get_class('SubCommunicator'))
    Superquadric = property(lambda self: get_class('Superquadric'))
    SurfaceLICPainter = property(lambda self: get_class('SurfaceLICPainter'))
    TDxInteractorStyleCamera = property(lambda self: get_class('TDxInteractorStyleCamera'))
    Table = property(lambda self: get_class('Table'))
    TableAlgorithm = property(lambda self: get_class('TableAlgorithm'))
    TemporalDataSetCache = property(lambda self: get_class('TemporalDataSetCache'))
    TemporalFractal = property(lambda self: get_class('TemporalFractal'))
    TemporalInterpolatedVelocityField = property(lambda self: get_class('TemporalInterpolatedVelocityField'))
    TemporalShiftScale = property(lambda self: get_class('TemporalShiftScale'))
    TemporalSnapToTimeStep = property(lambda self: get_class('TemporalSnapToTimeStep'))
    TerrainContourLineInterpolator = property(lambda self: get_class('TerrainContourLineInterpolator'))
    TerrainDataPointPlacer = property(lambda self: get_class('TerrainDataPointPlacer'))
    TextPropertyCollection = property(lambda self: get_class('TextPropertyCollection'))
    TextRendererStringToImage = property(lambda self: get_class('TextRendererStringToImage'))
    TransformCollection = property(lambda self: get_class('TransformCollection'))
    TransformToGrid = property(lambda self: get_class('TransformToGrid'))
    TreeAlgorithm = property(lambda self: get_class('TreeAlgorithm'))
    TreeBFSIterator = property(lambda self: get_class('TreeBFSIterator'))
    TreeDFSIterator = property(lambda self: get_class('TreeDFSIterator'))
    TreeLayoutStrategy = property(lambda self: get_class('TreeLayoutStrategy'))
    TreeMapLayoutStrategy = property(lambda self: get_class('TreeMapLayoutStrategy'))
    TreeOrbitLayoutStrategy = property(lambda self: get_class('TreeOrbitLayoutStrategy'))
    Triangle = property(lambda self: get_class('Triangle'))
    TriangleStrip = property(lambda self: get_class('TriangleStrip'))
    TrivialProducer = property(lambda self: get_class('TrivialProducer'))
    TypedArray_I10vtkVariantE = property(lambda self: get_class('TypedArray_I10vtkVariantE'))
    TypedArray_I12vtkStdStringE = property(lambda self: get_class('TypedArray_I12vtkStdStringE'))
    TypedArray_I16vtkUnicodeStringE = property(lambda self: get_class('TypedArray_I16vtkUnicodeStringE'))
    TypedArray_IaE = property(lambda self: get_class('TypedArray_IaE'))
    TypedArray_IcE = property(lambda self: get_class('TypedArray_IcE'))
    TypedArray_IdE = property(lambda self: get_class('TypedArray_IdE'))
    TypedArray_IfE = property(lambda self: get_class('TypedArray_IfE'))
    TypedArray_IhE = property(lambda self: get_class('TypedArray_IhE'))
    TypedArray_IiE = property(lambda self: get_class('TypedArray_IiE'))
    TypedArray_IjE = property(lambda self: get_class('TypedArray_IjE'))
    TypedArray_IlE = property(lambda self: get_class('TypedArray_IlE'))
    TypedArray_ImE = property(lambda self: get_class('TypedArray_ImE'))
    TypedArray_IsE = property(lambda self: get_class('TypedArray_IsE'))
    TypedArray_ItE = property(lambda self: get_class('TypedArray_ItE'))
    TypedArray_IxE = property(lambda self: get_class('TypedArray_IxE'))
    TypedArray_IyE = property(lambda self: get_class('TypedArray_IyE'))
    UTF16TextCodec = property(lambda self: get_class('UTF16TextCodec'))
    UTF8TextCodec = property(lambda self: get_class('UTF8TextCodec'))
    UndirectedGraphAlgorithm = property(lambda self: get_class('UndirectedGraphAlgorithm'))
    UnicodeStringArray = property(lambda self: get_class('UnicodeStringArray'))
    UniformGridAMRAlgorithm = property(lambda self: get_class('UniformGridAMRAlgorithm'))
    UniformGridAMRDataIterator = property(lambda self: get_class('UniformGridAMRDataIterator'))
    UnstructuredGridAlgorithm = property(lambda self: get_class('UnstructuredGridAlgorithm'))
    UnstructuredGridBaseAlgorithm = property(lambda self: get_class('UnstructuredGridBaseAlgorithm'))
    UnstructuredGridBunykRayCastFunction = property(lambda self: get_class('UnstructuredGridBunykRayCastFunction'))
    UnstructuredGridCellIterator = property(lambda self: get_class('UnstructuredGridCellIterator'))
    UnstructuredGridHomogeneousRayIntegrator = property(lambda self: get_class('UnstructuredGridHomogeneousRayIntegrator'))
    UnstructuredGridLinearRayIntegrator = property(lambda self: get_class('UnstructuredGridLinearRayIntegrator'))
    UnstructuredGridPartialPreIntegration = property(lambda self: get_class('UnstructuredGridPartialPreIntegration'))
    UnstructuredGridPreIntegration = property(lambda self: get_class('UnstructuredGridPreIntegration'))
    VRMLExporter = property(lambda self: get_class('VRMLExporter'))
    VRMLImporter = property(lambda self: get_class('VRMLImporter'))
    ValuePasses = property(lambda self: get_class('ValuePasses'))
    VariantArray = property(lambda self: get_class('VariantArray'))
    Vertex = property(lambda self: get_class('Vertex'))
    ViewDependentErrorMetric = property(lambda self: get_class('ViewDependentErrorMetric'))
    VolumeRayCastCompositeFunction = property(lambda self: get_class('VolumeRayCastCompositeFunction'))
    VolumeRayCastIsosurfaceFunction = property(lambda self: get_class('VolumeRayCastIsosurfaceFunction'))
    VolumeRayCastMIPFunction = property(lambda self: get_class('VolumeRayCastMIPFunction'))
    WarpTransform = property(lambda self: get_class('WarpTransform'))
    WidgetRepresentation = property(lambda self: get_class('WidgetRepresentation'))
    Win32OutputWindow = property(lambda self: get_class('Win32OutputWindow'))
    Win32ProcessOutputWindow = property(lambda self: get_class('Win32ProcessOutputWindow'))
    Win32RenderWindowInteractor = property(lambda self: get_class('Win32RenderWindowInteractor'))
    WindowToImageFilter = property(lambda self: get_class('WindowToImageFilter'))
    WorldPointPicker = property(lambda self: get_class('WorldPointPicker'))
    Writer = property(lambda self: get_class('Writer'))
    X3DExporter = property(lambda self: get_class('X3DExporter'))
    XMLDataParser = property(lambda self: get_class('XMLDataParser'))
    XMLFileReadTester = property(lambda self: get_class('XMLFileReadTester'))
    XMLReader = property(lambda self: get_class('XMLReader'))
    XMLWriter = property(lambda self: get_class('XMLWriter'))
    XYPlotWidget = property(lambda self: get_class('XYPlotWidget'))
    ZLibDataCompressor = property(lambda self: get_class('ZLibDataCompressor'))
    AMRBaseParticlesReader = property(lambda self: get_class('AMRBaseParticlesReader'))
    AMRCutPlane = property(lambda self: get_class('AMRCutPlane'))
    AMRInterpolatedVelocityField = property(lambda self: get_class('AMRInterpolatedVelocityField'))
    AMRResampleFilter = property(lambda self: get_class('AMRResampleFilter'))
    AMRToMultiBlockFilter = property(lambda self: get_class('AMRToMultiBlockFilter'))
    AVSucdReader = property(lambda self: get_class('AVSucdReader'))
    AbstractMapper3D = property(lambda self: get_class('AbstractMapper3D'))
    AbstractParticleWriter = property(lambda self: get_class('AbstractParticleWriter'))
    Actor = property(lambda self: get_class('Actor'))
    Actor2DCollection = property(lambda self: get_class('Actor2DCollection'))
    ActorCollection = property(lambda self: get_class('ActorCollection'))
    AddMembershipArray = property(lambda self: get_class('AddMembershipArray'))
    AdjacencyMatrixToEdgeTable = property(lambda self: get_class('AdjacencyMatrixToEdgeTable'))
    AffineRepresentation = property(lambda self: get_class('AffineRepresentation'))
    AffineWidget = property(lambda self: get_class('AffineWidget'))
    AngleRepresentation = property(lambda self: get_class('AngleRepresentation'))
    AngleWidget = property(lambda self: get_class('AngleWidget'))
    AnnotatedCubeActor = property(lambda self: get_class('AnnotatedCubeActor'))
    AnnotationLink = property(lambda self: get_class('AnnotationLink'))
    AppendCompositeDataLeaves = property(lambda self: get_class('AppendCompositeDataLeaves'))
    AppendFilter = property(lambda self: get_class('AppendFilter'))
    AppendPoints = property(lambda self: get_class('AppendPoints'))
    AppendPolyData = property(lambda self: get_class('AppendPolyData'))
    AppendSelection = property(lambda self: get_class('AppendSelection'))
    ApplyColors = property(lambda self: get_class('ApplyColors'))
    ApplyIcons = property(lambda self: get_class('ApplyIcons'))
    ApproximatingSubdivisionFilter = property(lambda self: get_class('ApproximatingSubdivisionFilter'))
    ArcPlotter = property(lambda self: get_class('ArcPlotter'))
    ArcSource = property(lambda self: get_class('ArcSource'))
    AreaContourSpectrumFilter = property(lambda self: get_class('AreaContourSpectrumFilter'))
    AreaLayout = property(lambda self: get_class('AreaLayout'))
    AreaPicker = property(lambda self: get_class('AreaPicker'))
    ArrayCalculator = property(lambda self: get_class('ArrayCalculator'))
    ArrayDataReader = property(lambda self: get_class('ArrayDataReader'))
    ArrayDataWriter = property(lambda self: get_class('ArrayDataWriter'))
    ArrayNorm = property(lambda self: get_class('ArrayNorm'))
    ArrayReader = property(lambda self: get_class('ArrayReader'))
    ArrayToTable = property(lambda self: get_class('ArrayToTable'))
    ArrayWriter = property(lambda self: get_class('ArrayWriter'))
    ArrowSource = property(lambda self: get_class('ArrowSource'))
    Assembly = property(lambda self: get_class('Assembly'))
    AssignAttribute = property(lambda self: get_class('AssignAttribute'))
    AssignCoordinates = property(lambda self: get_class('AssignCoordinates'))
    AttributeDataToFieldDataFilter = property(lambda self: get_class('AttributeDataToFieldDataFilter'))
    Axes = property(lambda self: get_class('Axes'))
    AxesActor = property(lambda self: get_class('AxesActor'))
    AxesTransformRepresentation = property(lambda self: get_class('AxesTransformRepresentation'))
    AxesTransformWidget = property(lambda self: get_class('AxesTransformWidget'))
    Axis = property(lambda self: get_class('Axis'))
    AxisActor2D = property(lambda self: get_class('AxisActor2D'))
    BSplineTransform = property(lambda self: get_class('BSplineTransform'))
    BYUReader = property(lambda self: get_class('BYUReader'))
    BYUWriter = property(lambda self: get_class('BYUWriter'))
    BalloonRepresentation = property(lambda self: get_class('BalloonRepresentation'))
    BandedPolyDataContourFilter = property(lambda self: get_class('BandedPolyDataContourFilter'))
    BarChartActor = property(lambda self: get_class('BarChartActor'))
    BiDimensionalRepresentation = property(lambda self: get_class('BiDimensionalRepresentation'))
    BiDimensionalWidget = property(lambda self: get_class('BiDimensionalWidget'))
    BiQuadraticQuad = property(lambda self: get_class('BiQuadraticQuad'))
    BiQuadraticQuadraticHexahedron = property(lambda self: get_class('BiQuadraticQuadraticHexahedron'))
    BiQuadraticQuadraticWedge = property(lambda self: get_class('BiQuadraticQuadraticWedge'))
    BiQuadraticTriangle = property(lambda self: get_class('BiQuadraticTriangle'))
    BitArray = property(lambda self: get_class('BitArray'))
    BivariateLinearTableThreshold = property(lambda self: get_class('BivariateLinearTableThreshold'))
    BlankStructuredGrid = property(lambda self: get_class('BlankStructuredGrid'))
    BlankStructuredGridWithImage = property(lambda self: get_class('BlankStructuredGridWithImage'))
    BlockIdScalars = property(lambda self: get_class('BlockIdScalars'))
    BlockItem = property(lambda self: get_class('BlockItem'))
    BooleanOperationPolyDataFilter = property(lambda self: get_class('BooleanOperationPolyDataFilter'))
    BooleanTexture = property(lambda self: get_class('BooleanTexture'))
    BorderRepresentation = property(lambda self: get_class('BorderRepresentation'))
    BorderWidget = property(lambda self: get_class('BorderWidget'))
    BoxClipDataSet = property(lambda self: get_class('BoxClipDataSet'))
    BoxLayoutStrategy = property(lambda self: get_class('BoxLayoutStrategy'))
    BoxMuellerRandomSequence = property(lambda self: get_class('BoxMuellerRandomSequence'))
    BoxRepresentation = property(lambda self: get_class('BoxRepresentation'))
    BoxWidget = property(lambda self: get_class('BoxWidget'))
    BoxWidget2 = property(lambda self: get_class('BoxWidget2'))
    BrokenLineWidget = property(lambda self: get_class('BrokenLineWidget'))
    BrownianPoints = property(lambda self: get_class('BrownianPoints'))
    ButtonRepresentation = property(lambda self: get_class('ButtonRepresentation'))
    ButtonSource = property(lambda self: get_class('ButtonSource'))
    ButtonWidget = property(lambda self: get_class('ButtonWidget'))
    CMLMoleculeReader = property(lambda self: get_class('CMLMoleculeReader'))
    CPExodusIIInSituReader = property(lambda self: get_class('CPExodusIIInSituReader'))
    CameraActor = property(lambda self: get_class('CameraActor'))
    CaptionActor2D = property(lambda self: get_class('CaptionActor2D'))
    CastToConcrete = property(lambda self: get_class('CastToConcrete'))
    CellCenters = property(lambda self: get_class('CellCenters'))
    CellData = property(lambda self: get_class('CellData'))
    CellDataToPointData = property(lambda self: get_class('CellDataToPointData'))
    CellDerivatives = property(lambda self: get_class('CellDerivatives'))
    CellDistanceSelector = property(lambda self: get_class('CellDistanceSelector'))
    CellLocator = property(lambda self: get_class('CellLocator'))
    CellQuality = property(lambda self: get_class('CellQuality'))
    CellTreeLocator = property(lambda self: get_class('CellTreeLocator'))
    CenterOfMass = property(lambda self: get_class('CenterOfMass'))
    CenteredSliderWidget = property(lambda self: get_class('CenteredSliderWidget'))
    ChacoGraphReader = property(lambda self: get_class('ChacoGraphReader'))
    ChacoReader = property(lambda self: get_class('ChacoReader'))
    CharArray = property(lambda self: get_class('CharArray'))
    Chart = property(lambda self: get_class('Chart'))
    ChartLegend = property(lambda self: get_class('ChartLegend'))
    ChartXYZ = property(lambda self: get_class('ChartXYZ'))
    CheckerboardRepresentation = property(lambda self: get_class('CheckerboardRepresentation'))
    CheckerboardWidget = property(lambda self: get_class('CheckerboardWidget'))
    ChooserPainter = property(lambda self: get_class('ChooserPainter'))
    CirclePackLayout = property(lambda self: get_class('CirclePackLayout'))
    CirclePackToPolyData = property(lambda self: get_class('CirclePackToPolyData'))
    CleanPolyData = property(lambda self: get_class('CleanPolyData'))
    ClipClosedSurface = property(lambda self: get_class('ClipClosedSurface'))
    ClipConvexPolyData = property(lambda self: get_class('ClipConvexPolyData'))
    ClipDataSet = property(lambda self: get_class('ClipDataSet'))
    ClipHyperOctree = property(lambda self: get_class('ClipHyperOctree'))
    ClipPolyData = property(lambda self: get_class('ClipPolyData'))
    ClipVolume = property(lambda self: get_class('ClipVolume'))
    CoincidentTopologyResolutionPainter = property(lambda self: get_class('CoincidentTopologyResolutionPainter'))
    CollapseGraph = property(lambda self: get_class('CollapseGraph'))
    CollapseVerticesByArray = property(lambda self: get_class('CollapseVerticesByArray'))
    CollectGraph = property(lambda self: get_class('CollectGraph'))
    CollectPolyData = property(lambda self: get_class('CollectPolyData'))
    CollectTable = property(lambda self: get_class('CollectTable'))
    CompassWidget = property(lambda self: get_class('CompassWidget'))
    CompositeDataGeometryFilter = property(lambda self: get_class('CompositeDataGeometryFilter'))
    CompositeDataReader = property(lambda self: get_class('CompositeDataReader'))
    CompositeInterpolatedVelocityField = property(lambda self: get_class('CompositeInterpolatedVelocityField'))
    ComputeHistogram2DOutliers = property(lambda self: get_class('ComputeHistogram2DOutliers'))
    ComputeQuartiles = property(lambda self: get_class('ComputeQuartiles'))
    ConeSource = property(lambda self: get_class('ConeSource'))
    ConnectivityFilter = property(lambda self: get_class('ConnectivityFilter'))
    ContextInteractorStyle = property(lambda self: get_class('ContextInteractorStyle'))
    ContextView = property(lambda self: get_class('ContextView'))
    ContinuousValueWidget = property(lambda self: get_class('ContinuousValueWidget'))
    ContinuousValueWidgetRepresentation = property(lambda self: get_class('ContinuousValueWidgetRepresentation'))
    ContourFilter = property(lambda self: get_class('ContourFilter'))
    ContourGrid = property(lambda self: get_class('ContourGrid'))
    ContourRepresentation = property(lambda self: get_class('ContourRepresentation'))
    ContourTriangulator = property(lambda self: get_class('ContourTriangulator'))
    ContourWidget = property(lambda self: get_class('ContourWidget'))
    ConvertSelection = property(lambda self: get_class('ConvertSelection'))
    ConvertSelectionDomain = property(lambda self: get_class('ConvertSelectionDomain'))
    ConvexHull2D = property(lambda self: get_class('ConvexHull2D'))
    ConvexPointSet = property(lambda self: get_class('ConvexPointSet'))
    CornerAnnotation = property(lambda self: get_class('CornerAnnotation'))
    CubeAxesActor2D = property(lambda self: get_class('CubeAxesActor2D'))
    CubeSource = property(lambda self: get_class('CubeSource'))
    CubicLine = property(lambda self: get_class('CubicLine'))
    Cursor2D = property(lambda self: get_class('Cursor2D'))
    Cursor3D = property(lambda self: get_class('Cursor3D'))
    Curvatures = property(lambda self: get_class('Curvatures'))
    CutMaterial = property(lambda self: get_class('CutMaterial'))
    Cutter = property(lambda self: get_class('Cutter'))
    CylinderSource = property(lambda self: get_class('CylinderSource'))
    CylindricalTransform = property(lambda self: get_class('CylindricalTransform'))
    DEMReader = property(lambda self: get_class('DEMReader'))
    DIMACSGraphReader = property(lambda self: get_class('DIMACSGraphReader'))
    DataObjectGenerator = property(lambda self: get_class('DataObjectGenerator'))
    DataObjectReader = property(lambda self: get_class('DataObjectReader'))
    DataObjectToDataSetFilter = property(lambda self: get_class('DataObjectToDataSetFilter'))
    DataObjectToTable = property(lambda self: get_class('DataObjectToTable'))
    DataObjectTree = property(lambda self: get_class('DataObjectTree'))
    DataObjectWriter = property(lambda self: get_class('DataObjectWriter'))
    DataRepresentation = property(lambda self: get_class('DataRepresentation'))
    DataSetGhostGenerator = property(lambda self: get_class('DataSetGhostGenerator'))
    DataSetGradient = property(lambda self: get_class('DataSetGradient'))
    DataSetGradientPrecompute = property(lambda self: get_class('DataSetGradientPrecompute'))
    DataSetReader = property(lambda self: get_class('DataSetReader'))
    DataSetSurfaceFilter = property(lambda self: get_class('DataSetSurfaceFilter'))
    DataSetToDataObjectFilter = property(lambda self: get_class('DataSetToDataObjectFilter'))
    DataSetTriangleFilter = property(lambda self: get_class('DataSetTriangleFilter'))
    DataWriter = property(lambda self: get_class('DataWriter'))
    DatabaseToTableReader = property(lambda self: get_class('DatabaseToTableReader'))
    DecimatePolylineFilter = property(lambda self: get_class('DecimatePolylineFilter'))
    DecimatePro = property(lambda self: get_class('DecimatePro'))
    DeformPointSet = property(lambda self: get_class('DeformPointSet'))
    Delaunay2D = property(lambda self: get_class('Delaunay2D'))
    Delaunay3D = property(lambda self: get_class('Delaunay3D'))
    DelimitedTextReader = property(lambda self: get_class('DelimitedTextReader'))
    DelimitedTextWriter = property(lambda self: get_class('DelimitedTextWriter'))
    DendrogramItem = property(lambda self: get_class('DendrogramItem'))
    DenseArray_I10vtkVariantE = property(lambda self: get_class('DenseArray_I10vtkVariantE'))
    DenseArray_I12vtkStdStringE = property(lambda self: get_class('DenseArray_I12vtkStdStringE'))
    DenseArray_I16vtkUnicodeStringE = property(lambda self: get_class('DenseArray_I16vtkUnicodeStringE'))
    DenseArray_IaE = property(lambda self: get_class('DenseArray_IaE'))
    DenseArray_IcE = property(lambda self: get_class('DenseArray_IcE'))
    DenseArray_IdE = property(lambda self: get_class('DenseArray_IdE'))
    DenseArray_IfE = property(lambda self: get_class('DenseArray_IfE'))
    DenseArray_IhE = property(lambda self: get_class('DenseArray_IhE'))
    DenseArray_IiE = property(lambda self: get_class('DenseArray_IiE'))
    DenseArray_IjE = property(lambda self: get_class('DenseArray_IjE'))
    DenseArray_IlE = property(lambda self: get_class('DenseArray_IlE'))
    DenseArray_ImE = property(lambda self: get_class('DenseArray_ImE'))
    DenseArray_IsE = property(lambda self: get_class('DenseArray_IsE'))
    DenseArray_ItE = property(lambda self: get_class('DenseArray_ItE'))
    DenseArray_IxE = property(lambda self: get_class('DenseArray_IxE'))
    DenseArray_IyE = property(lambda self: get_class('DenseArray_IyE'))
    DensifyPolyData = property(lambda self: get_class('DensifyPolyData'))
    DepthSortPolyData = property(lambda self: get_class('DepthSortPolyData'))
    DiagonalMatrixSource = property(lambda self: get_class('DiagonalMatrixSource'))
    Dicer = property(lambda self: get_class('Dicer'))
    DirectedGraph = property(lambda self: get_class('DirectedGraph'))
    DiscretizableColorTransferFunction = property(lambda self: get_class('DiscretizableColorTransferFunction'))
    DiskSource = property(lambda self: get_class('DiskSource'))
    DistancePolyDataFilter = property(lambda self: get_class('DistancePolyDataFilter'))
    DistanceRepresentation = property(lambda self: get_class('DistanceRepresentation'))
    DistanceToCamera = property(lambda self: get_class('DistanceToCamera'))
    DistanceWidget = property(lambda self: get_class('DistanceWidget'))
    DotProductSimilarity = property(lambda self: get_class('DotProductSimilarity'))
    DoubleArray = property(lambda self: get_class('DoubleArray'))
    DuplicatePolyData = property(lambda self: get_class('DuplicatePolyData'))
    EarthSource = property(lambda self: get_class('EarthSource'))
    EdgeCenters = property(lambda self: get_class('EdgeCenters'))
    EdgeLayout = property(lambda self: get_class('EdgeLayout'))
    EdgePoints = property(lambda self: get_class('EdgePoints'))
    ElevationFilter = property(lambda self: get_class('ElevationFilter'))
    EnSightWriter = property(lambda self: get_class('EnSightWriter'))
    ExodusIIReader = property(lambda self: get_class('ExodusIIReader'))
    ExodusIIWriter = property(lambda self: get_class('ExodusIIWriter'))
    ExpandSelectedGraph = property(lambda self: get_class('ExpandSelectedGraph'))
    ExplicitCell = property(lambda self: get_class('ExplicitCell'))
    ExtractArray = property(lambda self: get_class('ExtractArray'))
    ExtractArraysOverTime = property(lambda self: get_class('ExtractArraysOverTime'))
    ExtractBlock = property(lambda self: get_class('ExtractBlock'))
    ExtractCTHPart = property(lambda self: get_class('ExtractCTHPart'))
    ExtractCells = property(lambda self: get_class('ExtractCells'))
    ExtractDataOverTime = property(lambda self: get_class('ExtractDataOverTime'))
    ExtractDataSets = property(lambda self: get_class('ExtractDataSets'))
    ExtractEdges = property(lambda self: get_class('ExtractEdges'))
    ExtractFunctionalBagPlot = property(lambda self: get_class('ExtractFunctionalBagPlot'))
    ExtractGeometry = property(lambda self: get_class('ExtractGeometry'))
    ExtractGrid = property(lambda self: get_class('ExtractGrid'))
    ExtractLevel = property(lambda self: get_class('ExtractLevel'))
    ExtractPiece = property(lambda self: get_class('ExtractPiece'))
    ExtractPolyDataGeometry = property(lambda self: get_class('ExtractPolyDataGeometry'))
    ExtractPolyDataPiece = property(lambda self: get_class('ExtractPolyDataPiece'))
    ExtractRectilinearGrid = property(lambda self: get_class('ExtractRectilinearGrid'))
    ExtractSelectedGraph = property(lambda self: get_class('ExtractSelectedGraph'))
    ExtractSelectedPolyDataIds = property(lambda self: get_class('ExtractSelectedPolyDataIds'))
    ExtractSelectedRows = property(lambda self: get_class('ExtractSelectedRows'))
    ExtractSelectedTree = property(lambda self: get_class('ExtractSelectedTree'))
    ExtractSelectionBase = property(lambda self: get_class('ExtractSelectionBase'))
    ExtractTemporalFieldData = property(lambda self: get_class('ExtractTemporalFieldData'))
    ExtractTensorComponents = property(lambda self: get_class('ExtractTensorComponents'))
    ExtractUnstructuredGrid = property(lambda self: get_class('ExtractUnstructuredGrid'))
    ExtractUnstructuredGridPiece = property(lambda self: get_class('ExtractUnstructuredGridPiece'))
    ExtractVOI = property(lambda self: get_class('ExtractVOI'))
    ExtractVectorComponents = property(lambda self: get_class('ExtractVectorComponents'))
    FLUENTReader = property(lambda self: get_class('FLUENTReader'))
    FacetReader = property(lambda self: get_class('FacetReader'))
    FacetWriter = property(lambda self: get_class('FacetWriter'))
    FastSplatter = property(lambda self: get_class('FastSplatter'))
    FeatureEdges = property(lambda self: get_class('FeatureEdges'))
    FieldDataToAttributeDataFilter = property(lambda self: get_class('FieldDataToAttributeDataFilter'))
    FillHolesFilter = property(lambda self: get_class('FillHolesFilter'))
    FixedWidthTextReader = property(lambda self: get_class('FixedWidthTextReader'))
    FloatArray = property(lambda self: get_class('FloatArray'))
    FrustumSource = property(lambda self: get_class('FrustumSource'))
    GAMBITReader = property(lambda self: get_class('GAMBITReader'))
    GaussianBlurPass = property(lambda self: get_class('GaussianBlurPass'))
    GaussianSplatter = property(lambda self: get_class('GaussianSplatter'))
    GenerateIndexArray = property(lambda self: get_class('GenerateIndexArray'))
    GenericClip = property(lambda self: get_class('GenericClip'))
    GenericContourFilter = property(lambda self: get_class('GenericContourFilter'))
    GenericCutter = property(lambda self: get_class('GenericCutter'))
    GenericDataObjectReader = property(lambda self: get_class('GenericDataObjectReader'))
    GenericDataSetTessellator = property(lambda self: get_class('GenericDataSetTessellator'))
    GenericEnSightReader = property(lambda self: get_class('GenericEnSightReader'))
    GenericGeometryFilter = property(lambda self: get_class('GenericGeometryFilter'))
    GenericGlyph3DFilter = property(lambda self: get_class('GenericGlyph3DFilter'))
    GenericMovieWriter = property(lambda self: get_class('GenericMovieWriter'))
    GenericOutlineFilter = property(lambda self: get_class('GenericOutlineFilter'))
    GenericProbeFilter = property(lambda self: get_class('GenericProbeFilter'))
    GenericStreamTracer = property(lambda self: get_class('GenericStreamTracer'))
    GeoAdaptiveArcs = property(lambda self: get_class('GeoAdaptiveArcs'))
    GeoArcs = property(lambda self: get_class('GeoArcs'))
    GeoAssignCoordinates = property(lambda self: get_class('GeoAssignCoordinates'))
    GeoGraticule = property(lambda self: get_class('GeoGraticule'))
    GeoSampleArcs = property(lambda self: get_class('GeoSampleArcs'))
    GeodesicPath = property(lambda self: get_class('GeodesicPath'))
    GeometryFilter = property(lambda self: get_class('GeometryFilter'))
    GlobeSource = property(lambda self: get_class('GlobeSource'))
    Glyph3D = property(lambda self: get_class('Glyph3D'))
    GlyphSource2D = property(lambda self: get_class('GlyphSource2D'))
    GradientFilter = property(lambda self: get_class('GradientFilter'))
    GraphAnnotationLayersFilter = property(lambda self: get_class('GraphAnnotationLayersFilter'))
    GraphHierarchicalBundleEdges = property(lambda self: get_class('GraphHierarchicalBundleEdges'))
    GraphItem = property(lambda self: get_class('GraphItem'))
    GraphLayout = property(lambda self: get_class('GraphLayout'))
    GraphLayoutFilter = property(lambda self: get_class('GraphLayoutFilter'))
    GraphReader = property(lambda self: get_class('GraphReader'))
    GraphToGlyphs = property(lambda self: get_class('GraphToGlyphs'))
    GraphToPoints = property(lambda self: get_class('GraphToPoints'))
    GraphToPolyData = property(lambda self: get_class('GraphToPolyData'))
    GraphWeightFilter = property(lambda self: get_class('GraphWeightFilter'))
    GreedyTerrainDecimation = property(lambda self: get_class('GreedyTerrainDecimation'))
    GridSynchronizedTemplates3D = property(lambda self: get_class('GridSynchronizedTemplates3D'))
    GridTransform = property(lambda self: get_class('GridTransform'))
    GroupLeafVertices = property(lambda self: get_class('GroupLeafVertices'))
    HandleRepresentation = property(lambda self: get_class('HandleRepresentation'))
    HandleWidget = property(lambda self: get_class('HandleWidget'))
    HeatmapItem = property(lambda self: get_class('HeatmapItem'))
    HedgeHog = property(lambda self: get_class('HedgeHog'))
    HexagonalPrism = property(lambda self: get_class('HexagonalPrism'))
    Hexahedron = property(lambda self: get_class('Hexahedron'))
    HierarchicalBoxDataIterator = property(lambda self: get_class('HierarchicalBoxDataIterator'))
    HoverWidget = property(lambda self: get_class('HoverWidget'))
    Hull = property(lambda self: get_class('Hull'))
    HyperOctree = property(lambda self: get_class('HyperOctree'))
    HyperOctreeContourFilter = property(lambda self: get_class('HyperOctreeContourFilter'))
    HyperOctreeCutter = property(lambda self: get_class('HyperOctreeCutter'))
    HyperOctreeDepth = property(lambda self: get_class('HyperOctreeDepth'))
    HyperOctreeDualGridContourFilter = property(lambda self: get_class('HyperOctreeDualGridContourFilter'))
    HyperOctreeFractalSource = property(lambda self: get_class('HyperOctreeFractalSource'))
    HyperOctreeLimiter = property(lambda self: get_class('HyperOctreeLimiter'))
    HyperOctreeSampleFunction = property(lambda self: get_class('HyperOctreeSampleFunction'))
    HyperOctreeSurfaceFilter = property(lambda self: get_class('HyperOctreeSurfaceFilter'))
    HyperOctreeToUniformGridFilter = property(lambda self: get_class('HyperOctreeToUniformGridFilter'))
    HyperStreamline = property(lambda self: get_class('HyperStreamline'))
    HyperTreeGrid = property(lambda self: get_class('HyperTreeGrid'))
    HyperTreeGridAxisCut = property(lambda self: get_class('HyperTreeGridAxisCut'))
    HyperTreeGridGeometry = property(lambda self: get_class('HyperTreeGridGeometry'))
    HyperTreeGridSource = property(lambda self: get_class('HyperTreeGridSource'))
    HyperTreeGridToUnstructuredGrid = property(lambda self: get_class('HyperTreeGridToUnstructuredGrid'))
    ISIReader = property(lambda self: get_class('ISIReader'))
    IVWriter = property(lambda self: get_class('IVWriter'))
    IconGlyphFilter = property(lambda self: get_class('IconGlyphFilter'))
    IdFilter = property(lambda self: get_class('IdFilter'))
    IdTypeArray = property(lambda self: get_class('IdTypeArray'))
    ImageAccumulate = property(lambda self: get_class('ImageAccumulate'))
    ImageCacheFilter = property(lambda self: get_class('ImageCacheFilter'))
    ImageCanvasSource2D = property(lambda self: get_class('ImageCanvasSource2D'))
    ImageChangeInformation = property(lambda self: get_class('ImageChangeInformation'))
    ImageClip = property(lambda self: get_class('ImageClip'))
    ImageCroppingRegionsWidget = property(lambda self: get_class('ImageCroppingRegionsWidget'))
    ImageData = property(lambda self: get_class('ImageData'))
    ImageDataGeometryFilter = property(lambda self: get_class('ImageDataGeometryFilter'))
    ImageDataLIC2D = property(lambda self: get_class('ImageDataLIC2D'))
    ImageDataStreamer = property(lambda self: get_class('ImageDataStreamer'))
    ImageDataToPointSet = property(lambda self: get_class('ImageDataToPointSet'))
    ImageDataToUniformGrid = property(lambda self: get_class('ImageDataToUniformGrid'))
    ImageEllipsoidSource = property(lambda self: get_class('ImageEllipsoidSource'))
    ImageExport = property(lambda self: get_class('ImageExport'))
    ImageGaussianSource = property(lambda self: get_class('ImageGaussianSource'))
    ImageGridSource = property(lambda self: get_class('ImageGridSource'))
    ImageImport = property(lambda self: get_class('ImageImport'))
    ImageInPlaceFilter = property(lambda self: get_class('ImageInPlaceFilter'))
    ImageIslandRemoval2D = property(lambda self: get_class('ImageIslandRemoval2D'))
    ImageItem = property(lambda self: get_class('ImageItem'))
    ImageMandelbrotSource = property(lambda self: get_class('ImageMandelbrotSource'))
    ImageMarchingCubes = property(lambda self: get_class('ImageMarchingCubes'))
    ImageNoiseSource = property(lambda self: get_class('ImageNoiseSource'))
    ImageOpenClose3D = property(lambda self: get_class('ImageOpenClose3D'))
    ImageQuantizeRGBToIndex = property(lambda self: get_class('ImageQuantizeRGBToIndex'))
    ImageReader2 = property(lambda self: get_class('ImageReader2'))
    ImageSeedConnectivity = property(lambda self: get_class('ImageSeedConnectivity'))
    ImageSinusoidSource = property(lambda self: get_class('ImageSinusoidSource'))
    ImageSlice = property(lambda self: get_class('ImageSlice'))
    ImageSliceCollection = property(lambda self: get_class('ImageSliceCollection'))
    ImageStencilSource = property(lambda self: get_class('ImageStencilSource'))
    ImageStencilToImage = property(lambda self: get_class('ImageStencilToImage'))
    ImageThresholdConnectivity = property(lambda self: get_class('ImageThresholdConnectivity'))
    ImageToImageStencil = property(lambda self: get_class('ImageToImageStencil'))
    ImageToPolyDataFilter = property(lambda self: get_class('ImageToPolyDataFilter'))
    ImageToStructuredGrid = property(lambda self: get_class('ImageToStructuredGrid'))
    ImageToStructuredPoints = property(lambda self: get_class('ImageToStructuredPoints'))
    ImageTracerWidget = property(lambda self: get_class('ImageTracerWidget'))
    ImageTranslateExtent = property(lambda self: get_class('ImageTranslateExtent'))
    ImageWriter = property(lambda self: get_class('ImageWriter'))
    ImplicitModeller = property(lambda self: get_class('ImplicitModeller'))
    ImplicitPlaneRepresentation = property(lambda self: get_class('ImplicitPlaneRepresentation'))
    ImplicitPlaneWidget2 = property(lambda self: get_class('ImplicitPlaneWidget2'))
    ImplicitTextureCoords = property(lambda self: get_class('ImplicitTextureCoords'))
    IncrementalPointLocator = property(lambda self: get_class('IncrementalPointLocator'))
    IntArray = property(lambda self: get_class('IntArray'))
    InteractorStyleDrawPolygon = property(lambda self: get_class('InteractorStyleDrawPolygon'))
    InteractorStyleFlight = property(lambda self: get_class('InteractorStyleFlight'))
    InteractorStyleJoystickActor = property(lambda self: get_class('InteractorStyleJoystickActor'))
    InteractorStyleJoystickCamera = property(lambda self: get_class('InteractorStyleJoystickCamera'))
    InteractorStyleRubberBand2D = property(lambda self: get_class('InteractorStyleRubberBand2D'))
    InteractorStyleRubberBandZoom = property(lambda self: get_class('InteractorStyleRubberBandZoom'))
    InteractorStyleSwitchBase = property(lambda self: get_class('InteractorStyleSwitchBase'))
    InteractorStyleTerrain = property(lambda self: get_class('InteractorStyleTerrain'))
    InteractorStyleTrackballActor = property(lambda self: get_class('InteractorStyleTrackballActor'))
    InteractorStyleTrackballCamera = property(lambda self: get_class('InteractorStyleTrackballCamera'))
    InteractorStyleUnicam = property(lambda self: get_class('InteractorStyleUnicam'))
    InteractorStyleUser = property(lambda self: get_class('InteractorStyleUser'))
    InterpolateDataSetAttributes = property(lambda self: get_class('InterpolateDataSetAttributes'))
    InterpolatingSubdivisionFilter = property(lambda self: get_class('InterpolatingSubdivisionFilter'))
    IntersectionPolyDataFilter = property(lambda self: get_class('IntersectionPolyDataFilter'))
    JSONImageWriter = property(lambda self: get_class('JSONImageWriter'))
    JavaScriptDataWriter = property(lambda self: get_class('JavaScriptDataWriter'))
    KCoreDecomposition = property(lambda self: get_class('KCoreDecomposition'))
    KCoreLayout = property(lambda self: get_class('KCoreLayout'))
    KdTreePointLocator = property(lambda self: get_class('KdTreePointLocator'))
    KdTreeSelector = property(lambda self: get_class('KdTreeSelector'))
    LODProp3D = property(lambda self: get_class('LODProp3D'))
    LSDynaReader = property(lambda self: get_class('LSDynaReader'))
    LabelPlacer = property(lambda self: get_class('LabelPlacer'))
    LabelSizeCalculator = property(lambda self: get_class('LabelSizeCalculator'))
    LeaderActor2D = property(lambda self: get_class('LeaderActor2D'))
    LegendBoxActor = property(lambda self: get_class('LegendBoxActor'))
    LightActor = property(lambda self: get_class('LightActor'))
    LightingPainter = property(lambda self: get_class('LightingPainter'))
    LineRepresentation = property(lambda self: get_class('LineRepresentation'))
    LineSource = property(lambda self: get_class('LineSource'))
    LineWidget = property(lambda self: get_class('LineWidget'))
    LineWidget2 = property(lambda self: get_class('LineWidget2'))
    LinearExtrusionFilter = property(lambda self: get_class('LinearExtrusionFilter'))
    LinearSelector = property(lambda self: get_class('LinearSelector'))
    LinearTransform = property(lambda self: get_class('LinearTransform'))
    LinkEdgels = property(lambda self: get_class('LinkEdgels'))
    LogLookupTable = property(lambda self: get_class('LogLookupTable'))
    LongArray = property(lambda self: get_class('LongArray'))
    LongLongArray = property(lambda self: get_class('LongLongArray'))
    LookupTableWithEnabling = property(lambda self: get_class('LookupTableWithEnabling'))
    MCubesReader = property(lambda self: get_class('MCubesReader'))
    MCubesWriter = property(lambda self: get_class('MCubesWriter'))
    MFIXReader = property(lambda self: get_class('MFIXReader'))
    MNIObjectReader = property(lambda self: get_class('MNIObjectReader'))
    MNIObjectWriter = property(lambda self: get_class('MNIObjectWriter'))
    MNITagPointReader = property(lambda self: get_class('MNITagPointReader'))
    MNITagPointWriter = property(lambda self: get_class('MNITagPointWriter'))
    MPASReader = property(lambda self: get_class('MPASReader'))
    MapArrayValues = property(lambda self: get_class('MapArrayValues'))
    Mapper2D = property(lambda self: get_class('Mapper2D'))
    MarchingContourFilter = property(lambda self: get_class('MarchingContourFilter'))
    MarchingCubes = property(lambda self: get_class('MarchingCubes'))
    MarchingSquares = property(lambda self: get_class('MarchingSquares'))
    MaskFields = property(lambda self: get_class('MaskFields'))
    MaskPoints = property(lambda self: get_class('MaskPoints'))
    MaskPolyData = property(lambda self: get_class('MaskPolyData'))
    MassProperties = property(lambda self: get_class('MassProperties'))
    MatricizeArray = property(lambda self: get_class('MatricizeArray'))
    MatrixMathFilter = property(lambda self: get_class('MatrixMathFilter'))
    MatrixToHomogeneousTransform = property(lambda self: get_class('MatrixToHomogeneousTransform'))
    MergeColumns = property(lambda self: get_class('MergeColumns'))
    MergeDataObjectFilter = property(lambda self: get_class('MergeDataObjectFilter'))
    MergeFields = property(lambda self: get_class('MergeFields'))
    MergeFilter = property(lambda self: get_class('MergeFilter'))
    MergeGraphs = property(lambda self: get_class('MergeGraphs'))
    MergeTables = property(lambda self: get_class('MergeTables'))
    MeshQuality = property(lambda self: get_class('MeshQuality'))
    ModifiedBSPTree = property(lambda self: get_class('ModifiedBSPTree'))
    MoleculeReaderBase = property(lambda self: get_class('MoleculeReaderBase'))
    MoleculeToPolyDataFilter = property(lambda self: get_class('MoleculeToPolyDataFilter'))
    MultiBlockDataGroupFilter = property(lambda self: get_class('MultiBlockDataGroupFilter'))
    MultiBlockMergeFilter = property(lambda self: get_class('MultiBlockMergeFilter'))
    MultiBlockPLOT3DReader = property(lambda self: get_class('MultiBlockPLOT3DReader'))
    MultiNewickTreeReader = property(lambda self: get_class('MultiNewickTreeReader'))
    MultiThreshold = property(lambda self: get_class('MultiThreshold'))
    NetCDFCAMReader = property(lambda self: get_class('NetCDFCAMReader'))
    NetCDFPOPReader = property(lambda self: get_class('NetCDFPOPReader'))
    NetCDFReader = property(lambda self: get_class('NetCDFReader'))
    NetworkHierarchy = property(lambda self: get_class('NetworkHierarchy'))
    NewickTreeReader = property(lambda self: get_class('NewickTreeReader'))
    NonOverlappingAMRAlgorithm = property(lambda self: get_class('NonOverlappingAMRAlgorithm'))
    NormalizeMatrixVectors = property(lambda self: get_class('NormalizeMatrixVectors'))
    OBBTree = property(lambda self: get_class('OBBTree'))
    OBJReader = property(lambda self: get_class('OBJReader'))
    OctreePointLocator = property(lambda self: get_class('OctreePointLocator'))
    OpaquePass = property(lambda self: get_class('OpaquePass'))
    OpenFOAMReader = property(lambda self: get_class('OpenFOAMReader'))
    OpenGLClipPlanesPainter = property(lambda self: get_class('OpenGLClipPlanesPainter'))
    OpenGLCompositePainter = property(lambda self: get_class('OpenGLCompositePainter'))
    OpenGLContextActor = property(lambda self: get_class('OpenGLContextActor'))
    OpenGLDisplayListPainter = property(lambda self: get_class('OpenGLDisplayListPainter'))
    OpenGLRenderWindow = property(lambda self: get_class('OpenGLRenderWindow'))
    OpenGLRenderer = property(lambda self: get_class('OpenGLRenderer'))
    OpenGLScalarsToColorsPainter = property(lambda self: get_class('OpenGLScalarsToColorsPainter'))
    OutlineCornerFilter = property(lambda self: get_class('OutlineCornerFilter'))
    OutlineFilter = property(lambda self: get_class('OutlineFilter'))
    OutlineSource = property(lambda self: get_class('OutlineSource'))
    OverlappingAMRAlgorithm = property(lambda self: get_class('OverlappingAMRAlgorithm'))
    OverlayPass = property(lambda self: get_class('OverlayPass'))
    PCAAnalysisFilter = property(lambda self: get_class('PCAAnalysisFilter'))
    PDataSetReader = property(lambda self: get_class('PDataSetReader'))
    PKdTree = property(lambda self: get_class('PKdTree'))
    PLYReader = property(lambda self: get_class('PLYReader'))
    PLYWriter = property(lambda self: get_class('PLYWriter'))
    POutlineCornerFilter = property(lambda self: get_class('POutlineCornerFilter'))
    POutlineFilter = property(lambda self: get_class('POutlineFilter'))
    PResampleFilter = property(lambda self: get_class('PResampleFilter'))
    ParallelopipedRepresentation = property(lambda self: get_class('ParallelopipedRepresentation'))
    ParallelopipedWidget = property(lambda self: get_class('ParallelopipedWidget'))
    ParametricFunctionSource = property(lambda self: get_class('ParametricFunctionSource'))
    ParticleReader = property(lambda self: get_class('ParticleReader'))
    ParticleTracerBase = property(lambda self: get_class('ParticleTracerBase'))
    PassArrays = property(lambda self: get_class('PassArrays'))
    PassThrough = property(lambda self: get_class('PassThrough'))
    PassThroughFilter = property(lambda self: get_class('PassThroughFilter'))
    PentagonalPrism = property(lambda self: get_class('PentagonalPrism'))
    PerspectiveTransform = property(lambda self: get_class('PerspectiveTransform'))
    PerturbCoincidentVertices = property(lambda self: get_class('PerturbCoincidentVertices'))
    PhyloXMLTreeReader = property(lambda self: get_class('PhyloXMLTreeReader'))
    PhyloXMLTreeWriter = property(lambda self: get_class('PhyloXMLTreeWriter'))
    Picker = property(lambda self: get_class('Picker'))
    PieChartActor = property(lambda self: get_class('PieChartActor'))
    PieceScalars = property(lambda self: get_class('PieceScalars'))
    PiecewiseFunctionShiftScale = property(lambda self: get_class('PiecewiseFunctionShiftScale'))
    PiecewisePointHandleItem = property(lambda self: get_class('PiecewisePointHandleItem'))
    PipelineGraphSource = property(lambda self: get_class('PipelineGraphSource'))
    PlaneSource = property(lambda self: get_class('PlaneSource'))
    PlanesIntersection = property(lambda self: get_class('PlanesIntersection'))
    PlatonicSolidSource = property(lambda self: get_class('PlatonicSolidSource'))
    Plot = property(lambda self: get_class('Plot'))
    Plot3D = property(lambda self: get_class('Plot3D'))
    Plot3DMetaReader = property(lambda self: get_class('Plot3DMetaReader'))
    PlotGrid = property(lambda self: get_class('PlotGrid'))
    PointData = property(lambda self: get_class('PointData'))
    PointDataToCellData = property(lambda self: get_class('PointDataToCellData'))
    PointLoad = property(lambda self: get_class('PointLoad'))
    PointSet = property(lambda self: get_class('PointSet'))
    PointSetToLabelHierarchy = property(lambda self: get_class('PointSetToLabelHierarchy'))
    PointSource = property(lambda self: get_class('PointSource'))
    PointWidget = property(lambda self: get_class('PointWidget'))
    PolyDataConnectivityFilter = property(lambda self: get_class('PolyDataConnectivityFilter'))
    PolyDataNormals = property(lambda self: get_class('PolyDataNormals'))
    PolyDataPointSampler = property(lambda self: get_class('PolyDataPointSampler'))
    PolyDataReader = property(lambda self: get_class('PolyDataReader'))
    PolyDataSilhouette = property(lambda self: get_class('PolyDataSilhouette'))
    PolyDataSourceWidget = property(lambda self: get_class('PolyDataSourceWidget'))
    PolyDataStreamer = property(lambda self: get_class('PolyDataStreamer'))
    PolyDataToReebGraphFilter = property(lambda self: get_class('PolyDataToReebGraphFilter'))
    PolygonalSurfaceContourLineInterpolator = property(lambda self: get_class('PolygonalSurfaceContourLineInterpolator'))
    PolygonalSurfacePointPlacer = property(lambda self: get_class('PolygonalSurfacePointPlacer'))
    Polyhedron = property(lambda self: get_class('Polyhedron'))
    PrimitivePainter = property(lambda self: get_class('PrimitivePainter'))
    ProStarReader = property(lambda self: get_class('ProStarReader'))
    ProbeFilter = property(lambda self: get_class('ProbeFilter'))
    ProbePolyhedron = property(lambda self: get_class('ProbePolyhedron'))
    ProcessIdScalars = property(lambda self: get_class('ProcessIdScalars'))
    ProcrustesAlignmentFilter = property(lambda self: get_class('ProcrustesAlignmentFilter'))
    ProgrammableAttributeDataFilter = property(lambda self: get_class('ProgrammableAttributeDataFilter'))
    ProgrammableDataObjectSource = property(lambda self: get_class('ProgrammableDataObjectSource'))
    ProgrammableElectronicData = property(lambda self: get_class('ProgrammableElectronicData'))
    ProgrammableFilter = property(lambda self: get_class('ProgrammableFilter'))
    ProgrammableGlyphFilter = property(lambda self: get_class('ProgrammableGlyphFilter'))
    ProgrammableSource = property(lambda self: get_class('ProgrammableSource'))
    ProjectSphereFilter = property(lambda self: get_class('ProjectSphereFilter'))
    ProjectedTerrainPath = property(lambda self: get_class('ProjectedTerrainPath'))
    ProjectedTexture = property(lambda self: get_class('ProjectedTexture'))
    Prop3DCollection = property(lambda self: get_class('Prop3DCollection'))
    Prop3DFollower = property(lambda self: get_class('Prop3DFollower'))
    PropPicker = property(lambda self: get_class('PropPicker'))
    ProteinRibbonFilter = property(lambda self: get_class('ProteinRibbonFilter'))
    PruneTreeFilter = property(lambda self: get_class('PruneTreeFilter'))
    Pyramid = property(lambda self: get_class('Pyramid'))
    QuadRotationalExtrusionFilter = property(lambda self: get_class('QuadRotationalExtrusionFilter'))
    QuadraticEdge = property(lambda self: get_class('QuadraticEdge'))
    QuadraticHexahedron = property(lambda self: get_class('QuadraticHexahedron'))
    QuadraticLinearQuad = property(lambda self: get_class('QuadraticLinearQuad'))
    QuadraticLinearWedge = property(lambda self: get_class('QuadraticLinearWedge'))
    QuadraticPolygon = property(lambda self: get_class('QuadraticPolygon'))
    QuadraticPyramid = property(lambda self: get_class('QuadraticPyramid'))
    QuadraticQuad = property(lambda self: get_class('QuadraticQuad'))
    QuadraticTetra = property(lambda self: get_class('QuadraticTetra'))
    QuadraticTriangle = property(lambda self: get_class('QuadraticTriangle'))
    QuadraticWedge = property(lambda self: get_class('QuadraticWedge'))
    QuadraturePointInterpolator = property(lambda self: get_class('QuadraturePointInterpolator'))
    QuadraturePointsGenerator = property(lambda self: get_class('QuadraturePointsGenerator'))
    QuadratureSchemeDictionaryGenerator = property(lambda self: get_class('QuadratureSchemeDictionaryGenerator'))
    QuadricClustering = property(lambda self: get_class('QuadricClustering'))
    QuadricDecimation = property(lambda self: get_class('QuadricDecimation'))
    RISReader = property(lambda self: get_class('RISReader'))
    RTAnalyticSource = property(lambda self: get_class('RTAnalyticSource'))
    RandomAttributeGenerator = property(lambda self: get_class('RandomAttributeGenerator'))
    RandomGraphSource = property(lambda self: get_class('RandomGraphSource'))
    RearrangeFields = property(lambda self: get_class('RearrangeFields'))
    RectilinearGrid = property(lambda self: get_class('RectilinearGrid'))
    RectilinearGridClip = property(lambda self: get_class('RectilinearGridClip'))
    RectilinearGridGeometryFilter = property(lambda self: get_class('RectilinearGridGeometryFilter'))
    RectilinearGridOutlineFilter = property(lambda self: get_class('RectilinearGridOutlineFilter'))
    RectilinearGridPartitioner = property(lambda self: get_class('RectilinearGridPartitioner'))
    RectilinearGridReader = property(lambda self: get_class('RectilinearGridReader'))
    RectilinearGridToPointSet = property(lambda self: get_class('RectilinearGridToPointSet'))
    RectilinearGridToTetrahedra = property(lambda self: get_class('RectilinearGridToTetrahedra'))
    RectilinearSynchronizedTemplates = property(lambda self: get_class('RectilinearSynchronizedTemplates'))
    RectilinearWipeRepresentation = property(lambda self: get_class('RectilinearWipeRepresentation'))
    RectilinearWipeWidget = property(lambda self: get_class('RectilinearWipeWidget'))
    RecursiveDividingCubes = property(lambda self: get_class('RecursiveDividingCubes'))
    ReduceTable = property(lambda self: get_class('ReduceTable'))
    ReflectionFilter = property(lambda self: get_class('ReflectionFilter'))
    RegularPolygonSource = property(lambda self: get_class('RegularPolygonSource'))
    RemoveHiddenData = property(lambda self: get_class('RemoveHiddenData'))
    RemoveIsolatedVertices = property(lambda self: get_class('RemoveIsolatedVertices'))
    RenderView = property(lambda self: get_class('RenderView'))
    RepresentationPainter = property(lambda self: get_class('RepresentationPainter'))
    ResliceCursorActor = property(lambda self: get_class('ResliceCursorActor'))
    ResliceCursorPolyDataAlgorithm = property(lambda self: get_class('ResliceCursorPolyDataAlgorithm'))
    ResliceCursorRepresentation = property(lambda self: get_class('ResliceCursorRepresentation'))
    ResliceCursorWidget = property(lambda self: get_class('ResliceCursorWidget'))
    ReverseSense = property(lambda self: get_class('ReverseSense'))
    RibbonFilter = property(lambda self: get_class('RibbonFilter'))
    RotationFilter = property(lambda self: get_class('RotationFilter'))
    RotationalExtrusionFilter = property(lambda self: get_class('RotationalExtrusionFilter'))
    RowQueryToTable = property(lambda self: get_class('RowQueryToTable'))
    RuledSurfaceFilter = property(lambda self: get_class('RuledSurfaceFilter'))
    SLACParticleReader = property(lambda self: get_class('SLACParticleReader'))
    SLACReader = property(lambda self: get_class('SLACReader'))
    SQLDatabaseTableSource = property(lambda self: get_class('SQLDatabaseTableSource'))
    SQLiteQuery = property(lambda self: get_class('SQLiteQuery'))
    STLReader = property(lambda self: get_class('STLReader'))
    STLWriter = property(lambda self: get_class('STLWriter'))
    SampleFunction = property(lambda self: get_class('SampleFunction'))
    ScalarBarActor = property(lambda self: get_class('ScalarBarActor'))
    ScatterPlotMatrix = property(lambda self: get_class('ScatterPlotMatrix'))
    SectorSource = property(lambda self: get_class('SectorSource'))
    SeedRepresentation = property(lambda self: get_class('SeedRepresentation'))
    SeedWidget = property(lambda self: get_class('SeedWidget'))
    SelectEnclosedPoints = property(lambda self: get_class('SelectEnclosedPoints'))
    SelectPolyData = property(lambda self: get_class('SelectPolyData'))
    SelectVisiblePoints = property(lambda self: get_class('SelectVisiblePoints'))
    SelectionSource = property(lambda self: get_class('SelectionSource'))
    ShepardMethod = property(lambda self: get_class('ShepardMethod'))
    ShortArray = property(lambda self: get_class('ShortArray'))
    ShrinkFilter = property(lambda self: get_class('ShrinkFilter'))
    ShrinkPolyData = property(lambda self: get_class('ShrinkPolyData'))
    SignedCharArray = property(lambda self: get_class('SignedCharArray'))
    SimpleBondPerceiver = property(lambda self: get_class('SimpleBondPerceiver'))
    SimpleElevationFilter = property(lambda self: get_class('SimpleElevationFilter'))
    SimpleImageToImageFilter = property(lambda self: get_class('SimpleImageToImageFilter'))
    SimplePointsReader = property(lambda self: get_class('SimplePointsReader'))
    SliceAndDiceLayoutStrategy = property(lambda self: get_class('SliceAndDiceLayoutStrategy'))
    SliderRepresentation = property(lambda self: get_class('SliderRepresentation'))
    SliderWidget = property(lambda self: get_class('SliderWidget'))
    SmoothPolyDataFilter = property(lambda self: get_class('SmoothPolyDataFilter'))
    SobelGradientMagnitudePass = property(lambda self: get_class('SobelGradientMagnitudePass'))
    SparseArrayToTable = property(lambda self: get_class('SparseArrayToTable'))
    SparseArray_I10vtkVariantE = property(lambda self: get_class('SparseArray_I10vtkVariantE'))
    SparseArray_I12vtkStdStringE = property(lambda self: get_class('SparseArray_I12vtkStdStringE'))
    SparseArray_I16vtkUnicodeStringE = property(lambda self: get_class('SparseArray_I16vtkUnicodeStringE'))
    SparseArray_IaE = property(lambda self: get_class('SparseArray_IaE'))
    SparseArray_IcE = property(lambda self: get_class('SparseArray_IcE'))
    SparseArray_IdE = property(lambda self: get_class('SparseArray_IdE'))
    SparseArray_IfE = property(lambda self: get_class('SparseArray_IfE'))
    SparseArray_IhE = property(lambda self: get_class('SparseArray_IhE'))
    SparseArray_IiE = property(lambda self: get_class('SparseArray_IiE'))
    SparseArray_IjE = property(lambda self: get_class('SparseArray_IjE'))
    SparseArray_IlE = property(lambda self: get_class('SparseArray_IlE'))
    SparseArray_ImE = property(lambda self: get_class('SparseArray_ImE'))
    SparseArray_IsE = property(lambda self: get_class('SparseArray_IsE'))
    SparseArray_ItE = property(lambda self: get_class('SparseArray_ItE'))
    SparseArray_IxE = property(lambda self: get_class('SparseArray_IxE'))
    SparseArray_IyE = property(lambda self: get_class('SparseArray_IyE'))
    SpatialRepresentationFilter = property(lambda self: get_class('SpatialRepresentationFilter'))
    SpherePuzzle = property(lambda self: get_class('SpherePuzzle'))
    SpherePuzzleArrows = property(lambda self: get_class('SpherePuzzleArrows'))
    SphereRepresentation = property(lambda self: get_class('SphereRepresentation'))
    SphereSource = property(lambda self: get_class('SphereSource'))
    SphereWidget = property(lambda self: get_class('SphereWidget'))
    SphereWidget2 = property(lambda self: get_class('SphereWidget2'))
    SphericalTransform = property(lambda self: get_class('SphericalTransform'))
    SpiderPlotActor = property(lambda self: get_class('SpiderPlotActor'))
    SplineFilter = property(lambda self: get_class('SplineFilter'))
    SplineGraphEdges = property(lambda self: get_class('SplineGraphEdges'))
    SplineRepresentation = property(lambda self: get_class('SplineRepresentation'))
    SplineWidget = property(lambda self: get_class('SplineWidget'))
    SplineWidget2 = property(lambda self: get_class('SplineWidget2'))
    SplitColumnComponents = property(lambda self: get_class('SplitColumnComponents'))
    SplitField = property(lambda self: get_class('SplitField'))
    SquarifyLayoutStrategy = property(lambda self: get_class('SquarifyLayoutStrategy'))
    StandardPolyDataPainter = property(lambda self: get_class('StandardPolyDataPainter'))
    StatisticsAlgorithm = property(lambda self: get_class('StatisticsAlgorithm'))
    StrahlerMetric = property(lambda self: get_class('StrahlerMetric'))
    StreamGraph = property(lambda self: get_class('StreamGraph'))
    StreamTracer = property(lambda self: get_class('StreamTracer'))
    Streamer = property(lambda self: get_class('Streamer'))
    StreamingDemandDrivenPipeline = property(lambda self: get_class('StreamingDemandDrivenPipeline'))
    StreamingStatistics = property(lambda self: get_class('StreamingStatistics'))
    StringToCategory = property(lambda self: get_class('StringToCategory'))
    StringToNumeric = property(lambda self: get_class('StringToNumeric'))
    Stripper = property(lambda self: get_class('Stripper'))
    StructuredGridAppend = property(lambda self: get_class('StructuredGridAppend'))
    StructuredGridClip = property(lambda self: get_class('StructuredGridClip'))
    StructuredGridGeometryFilter = property(lambda self: get_class('StructuredGridGeometryFilter'))
    StructuredGridLIC2D = property(lambda self: get_class('StructuredGridLIC2D'))
    StructuredGridOutlineFilter = property(lambda self: get_class('StructuredGridOutlineFilter'))
    StructuredGridPartitioner = property(lambda self: get_class('StructuredGridPartitioner'))
    StructuredGridReader = property(lambda self: get_class('StructuredGridReader'))
    StructuredPointsReader = property(lambda self: get_class('StructuredPointsReader'))
    SubPixelPositionEdgels = property(lambda self: get_class('SubPixelPositionEdgels'))
    SubdivideTetra = property(lambda self: get_class('SubdivideTetra'))
    SuperquadricSource = property(lambda self: get_class('SuperquadricSource'))
    SurfaceLICDefaultPainter = property(lambda self: get_class('SurfaceLICDefaultPainter'))
    SurfaceReconstructionFilter = property(lambda self: get_class('SurfaceReconstructionFilter'))
    SynchronizedTemplates2D = property(lambda self: get_class('SynchronizedTemplates2D'))
    SynchronizedTemplates3D = property(lambda self: get_class('SynchronizedTemplates3D'))
    TableBasedClipDataSet = property(lambda self: get_class('TableBasedClipDataSet'))
    TableFFT = property(lambda self: get_class('TableFFT'))
    TableReader = property(lambda self: get_class('TableReader'))
    TableToArray = property(lambda self: get_class('TableToArray'))
    TableToDatabaseWriter = property(lambda self: get_class('TableToDatabaseWriter'))
    TableToGraph = property(lambda self: get_class('TableToGraph'))
    TableToPolyData = property(lambda self: get_class('TableToPolyData'))
    TableToSparseArray = property(lambda self: get_class('TableToSparseArray'))
    TableToStructuredGrid = property(lambda self: get_class('TableToStructuredGrid'))
    TableToTreeFilter = property(lambda self: get_class('TableToTreeFilter'))
    TanglegramItem = property(lambda self: get_class('TanglegramItem'))
    TecplotReader = property(lambda self: get_class('TecplotReader'))
    TemporalInterpolator = property(lambda self: get_class('TemporalInterpolator'))
    TemporalPathLineFilter = property(lambda self: get_class('TemporalPathLineFilter'))
    TemporalStatistics = property(lambda self: get_class('TemporalStatistics'))
    TensorGlyph = property(lambda self: get_class('TensorGlyph'))
    TensorProbeRepresentation = property(lambda self: get_class('TensorProbeRepresentation'))
    TensorProbeWidget = property(lambda self: get_class('TensorProbeWidget'))
    TessellatedBoxSource = property(lambda self: get_class('TessellatedBoxSource'))
    TessellatorFilter = property(lambda self: get_class('TessellatorFilter'))
    Tetra = property(lambda self: get_class('Tetra'))
    TextActor3D = property(lambda self: get_class('TextActor3D'))
    TextSource = property(lambda self: get_class('TextSource'))
    Texture = property(lambda self: get_class('Texture'))
    TextureMapToCylinder = property(lambda self: get_class('TextureMapToCylinder'))
    TextureMapToPlane = property(lambda self: get_class('TextureMapToPlane'))
    TextureMapToSphere = property(lambda self: get_class('TextureMapToSphere'))
    TexturedActor2D = property(lambda self: get_class('TexturedActor2D'))
    TexturedSphereSource = property(lambda self: get_class('TexturedSphereSource'))
    ThinPlateSplineTransform = property(lambda self: get_class('ThinPlateSplineTransform'))
    ThreadedImageAlgorithm = property(lambda self: get_class('ThreadedImageAlgorithm'))
    ThreadedSynchronizedTemplates3D = property(lambda self: get_class('ThreadedSynchronizedTemplates3D'))
    Threshold = property(lambda self: get_class('Threshold'))
    ThresholdGraph = property(lambda self: get_class('ThresholdGraph'))
    ThresholdPoints = property(lambda self: get_class('ThresholdPoints'))
    ThresholdTable = property(lambda self: get_class('ThresholdTable'))
    ThresholdTextureCoords = property(lambda self: get_class('ThresholdTextureCoords'))
    TimeSourceExample = property(lambda self: get_class('TimeSourceExample'))
    TooltipItem = property(lambda self: get_class('TooltipItem'))
    TransferAttributes = property(lambda self: get_class('TransferAttributes'))
    TransformCoordinateSystems = property(lambda self: get_class('TransformCoordinateSystems'))
    TransformFilter = property(lambda self: get_class('TransformFilter'))
    TransformPolyDataFilter = property(lambda self: get_class('TransformPolyDataFilter'))
    TransformTextureCoords = property(lambda self: get_class('TransformTextureCoords'))
    TranslucentPass = property(lambda self: get_class('TranslucentPass'))
    TransmitPolyDataPiece = property(lambda self: get_class('TransmitPolyDataPiece'))
    TransmitStructuredDataPiece = property(lambda self: get_class('TransmitStructuredDataPiece'))
    TransmitUnstructuredGridPiece = property(lambda self: get_class('TransmitUnstructuredGridPiece'))
    TransposeMatrix = property(lambda self: get_class('TransposeMatrix'))
    TransposeTable = property(lambda self: get_class('TransposeTable'))
    TreeDifferenceFilter = property(lambda self: get_class('TreeDifferenceFilter'))
    TreeFieldAggregator = property(lambda self: get_class('TreeFieldAggregator'))
    TreeHeatmapItem = property(lambda self: get_class('TreeHeatmapItem'))
    TreeLevelsFilter = property(lambda self: get_class('TreeLevelsFilter'))
    TreeMapLayout = property(lambda self: get_class('TreeMapLayout'))
    TreeMapToPolyData = property(lambda self: get_class('TreeMapToPolyData'))
    TreeReader = property(lambda self: get_class('TreeReader'))
    TreeRingToPolyData = property(lambda self: get_class('TreeRingToPolyData'))
    TriQuadraticHexahedron = property(lambda self: get_class('TriQuadraticHexahedron'))
    TriangleFilter = property(lambda self: get_class('TriangleFilter'))
    TriangularTCoords = property(lambda self: get_class('TriangularTCoords'))
    TriangularTexture = property(lambda self: get_class('TriangularTexture'))
    TubeFilter = property(lambda self: get_class('TubeFilter'))
    TulipReader = property(lambda self: get_class('TulipReader'))
    UGFacetReader = property(lambda self: get_class('UGFacetReader'))
    UncertaintyTubeFilter = property(lambda self: get_class('UncertaintyTubeFilter'))
    UndirectedGraph = property(lambda self: get_class('UndirectedGraph'))
    UniformGridAMR = property(lambda self: get_class('UniformGridAMR'))
    UniformGridPartitioner = property(lambda self: get_class('UniformGridPartitioner'))
    UnsignedCharArray = property(lambda self: get_class('UnsignedCharArray'))
    UnsignedIntArray = property(lambda self: get_class('UnsignedIntArray'))
    UnsignedLongArray = property(lambda self: get_class('UnsignedLongArray'))
    UnsignedLongLongArray = property(lambda self: get_class('UnsignedLongLongArray'))
    UnsignedShortArray = property(lambda self: get_class('UnsignedShortArray'))
    UnstructuredGridGeometryFilter = property(lambda self: get_class('UnstructuredGridGeometryFilter'))
    UnstructuredGridReader = property(lambda self: get_class('UnstructuredGridReader'))
    VectorDot = property(lambda self: get_class('VectorDot'))
    VectorNorm = property(lambda self: get_class('VectorNorm'))
    VectorText = property(lambda self: get_class('VectorText'))
    VertexDegree = property(lambda self: get_class('VertexDegree'))
    VertexGlyphFilter = property(lambda self: get_class('VertexGlyphFilter'))
    VideoSource = property(lambda self: get_class('VideoSource'))
    Volume = property(lambda self: get_class('Volume'))
    VolumeCollection = property(lambda self: get_class('VolumeCollection'))
    VolumeContourSpectrumFilter = property(lambda self: get_class('VolumeContourSpectrumFilter'))
    VolumeOutlineSource = property(lambda self: get_class('VolumeOutlineSource'))
    VolumeReader = property(lambda self: get_class('VolumeReader'))
    VolumetricPass = property(lambda self: get_class('VolumetricPass'))
    Voxel = property(lambda self: get_class('Voxel'))
    VoxelContoursToSurfaceFilter = property(lambda self: get_class('VoxelContoursToSurfaceFilter'))
    VoxelModeller = property(lambda self: get_class('VoxelModeller'))
    WarpLens = property(lambda self: get_class('WarpLens'))
    WarpScalar = property(lambda self: get_class('WarpScalar'))
    WarpTo = property(lambda self: get_class('WarpTo'))
    WarpVector = property(lambda self: get_class('WarpVector'))
    Wedge = property(lambda self: get_class('Wedge'))
    WeightedTransformFilter = property(lambda self: get_class('WeightedTransformFilter'))
    WindBladeReader = property(lambda self: get_class('WindBladeReader'))
    WindowLevelLookupTable = property(lambda self: get_class('WindowLevelLookupTable'))
    WindowedSincPolyDataFilter = property(lambda self: get_class('WindowedSincPolyDataFilter'))
    XGMLReader = property(lambda self: get_class('XGMLReader'))
    XMLCompositeDataReader = property(lambda self: get_class('XMLCompositeDataReader'))
    XMLCompositeDataWriter = property(lambda self: get_class('XMLCompositeDataWriter'))
    XMLDataReader = property(lambda self: get_class('XMLDataReader'))
    XMLDataSetWriter = property(lambda self: get_class('XMLDataSetWriter'))
    XMLFileOutputWindow = property(lambda self: get_class('XMLFileOutputWindow'))
    XMLHyperOctreeWriter = property(lambda self: get_class('XMLHyperOctreeWriter'))
    XMLPDataReader = property(lambda self: get_class('XMLPDataReader'))
    XMLPDataWriter = property(lambda self: get_class('XMLPDataWriter'))
    XMLStructuredDataWriter = property(lambda self: get_class('XMLStructuredDataWriter'))
    XMLTreeReader = property(lambda self: get_class('XMLTreeReader'))
    XMLUnstructuredDataWriter = property(lambda self: get_class('XMLUnstructuredDataWriter'))
    XYPlotActor = property(lambda self: get_class('XYPlotActor'))
    YoungsMaterialInterface = property(lambda self: get_class('YoungsMaterialInterface'))
    AMRBaseReader = property(lambda self: get_class('AMRBaseReader'))
    AMREnzoParticlesReader = property(lambda self: get_class('AMREnzoParticlesReader'))
    AMRFlashParticlesReader = property(lambda self: get_class('AMRFlashParticlesReader'))
    AMRGaussianPulseSource = property(lambda self: get_class('AMRGaussianPulseSource'))
    AMRSliceFilter = property(lambda self: get_class('AMRSliceFilter'))
    AVIWriter = property(lambda self: get_class('AVIWriter'))
    AbstractPolygonalHandleRepresentation3D = property(lambda self: get_class('AbstractPolygonalHandleRepresentation3D'))
    AbstractVolumeMapper = property(lambda self: get_class('AbstractVolumeMapper'))
    AffineRepresentation2D = property(lambda self: get_class('AffineRepresentation2D'))
    AngleRepresentation2D = property(lambda self: get_class('AngleRepresentation2D'))
    AngleRepresentation3D = property(lambda self: get_class('AngleRepresentation3D'))
    AutoCorrelativeStatistics = property(lambda self: get_class('AutoCorrelativeStatistics'))
    AxisActor = property(lambda self: get_class('AxisActor'))
    BMPWriter = property(lambda self: get_class('BMPWriter'))
    BalloonWidget = property(lambda self: get_class('BalloonWidget'))
    BiDimensionalRepresentation2D = property(lambda self: get_class('BiDimensionalRepresentation2D'))
    BiomTableReader = property(lambda self: get_class('BiomTableReader'))
    ButterflySubdivisionFilter = property(lambda self: get_class('ButterflySubdivisionFilter'))
    CachedStreamingDemandDrivenPipeline = property(lambda self: get_class('CachedStreamingDemandDrivenPipeline'))
    CameraRepresentation = property(lambda self: get_class('CameraRepresentation'))
    CameraWidget = property(lambda self: get_class('CameraWidget'))
    CaptionRepresentation = property(lambda self: get_class('CaptionRepresentation'))
    CaptionWidget = property(lambda self: get_class('CaptionWidget'))
    CategoryLegend = property(lambda self: get_class('CategoryLegend'))
    CellLocatorInterpolatedVelocityField = property(lambda self: get_class('CellLocatorInterpolatedVelocityField'))
    CellPicker = property(lambda self: get_class('CellPicker'))
    CenteredSliderRepresentation = property(lambda self: get_class('CenteredSliderRepresentation'))
    ChartBox = property(lambda self: get_class('ChartBox'))
    ChartParallelCoordinates = property(lambda self: get_class('ChartParallelCoordinates'))
    ChartPie = property(lambda self: get_class('ChartPie'))
    ChartXY = property(lambda self: get_class('ChartXY'))
    ColorLegend = property(lambda self: get_class('ColorLegend'))
    CompassRepresentation = property(lambda self: get_class('CompassRepresentation'))
    CompositeCutter = property(lambda self: get_class('CompositeCutter'))
    CompositeDataPipeline = property(lambda self: get_class('CompositeDataPipeline'))
    CompositeDataProbeFilter = property(lambda self: get_class('CompositeDataProbeFilter'))
    CompositeDataWriter = property(lambda self: get_class('CompositeDataWriter'))
    ConstrainedPointHandleRepresentation = property(lambda self: get_class('ConstrainedPointHandleRepresentation'))
    ContingencyStatistics = property(lambda self: get_class('ContingencyStatistics'))
    ControlPointsItem = property(lambda self: get_class('ControlPointsItem'))
    CorrelativeStatistics = property(lambda self: get_class('CorrelativeStatistics'))
    CubeAxesActor = property(lambda self: get_class('CubeAxesActor'))
    DICOMImageReader = property(lambda self: get_class('DICOMImageReader'))
    DIMACSGraphWriter = property(lambda self: get_class('DIMACSGraphWriter'))
    DataSetWriter = property(lambda self: get_class('DataSetWriter'))
    DescriptiveStatistics = property(lambda self: get_class('DescriptiveStatistics'))
    DirectedAcyclicGraph = property(lambda self: get_class('DirectedAcyclicGraph'))
    DiscreteMarchingCubes = property(lambda self: get_class('DiscreteMarchingCubes'))
    DistanceRepresentation2D = property(lambda self: get_class('DistanceRepresentation2D'))
    DistanceRepresentation3D = property(lambda self: get_class('DistanceRepresentation3D'))
    EllipsoidTensorProbeRepresentation = property(lambda self: get_class('EllipsoidTensorProbeRepresentation'))
    EllipticalButtonSource = property(lambda self: get_class('EllipticalButtonSource'))
    EmptyRepresentation = property(lambda self: get_class('EmptyRepresentation'))
    EnSightMasterServerReader = property(lambda self: get_class('EnSightMasterServerReader'))
    EnSightReader = property(lambda self: get_class('EnSightReader'))
    ExtractHistogram2D = property(lambda self: get_class('ExtractHistogram2D'))
    ExtractSelectedBlock = property(lambda self: get_class('ExtractSelectedBlock'))
    ExtractSelectedFrustum = property(lambda self: get_class('ExtractSelectedFrustum'))
    ExtractSelectedIds = property(lambda self: get_class('ExtractSelectedIds'))
    ExtractSelectedLocations = property(lambda self: get_class('ExtractSelectedLocations'))
    ExtractSelectedThresholds = property(lambda self: get_class('ExtractSelectedThresholds'))
    ExtractSelection = property(lambda self: get_class('ExtractSelection'))
    ExtractUserDefinedPiece = property(lambda self: get_class('ExtractUserDefinedPiece'))
    FocalPlaneContourRepresentation = property(lambda self: get_class('FocalPlaneContourRepresentation'))
    Follower = property(lambda self: get_class('Follower'))
    GaussianCubeReader = property(lambda self: get_class('GaussianCubeReader'))
    GenericDataObjectWriter = property(lambda self: get_class('GenericDataObjectWriter'))
    GenericOpenGLRenderWindow = property(lambda self: get_class('GenericOpenGLRenderWindow'))
    GeoAlignedImageRepresentation = property(lambda self: get_class('GeoAlignedImageRepresentation'))
    GeoInteractorStyle = property(lambda self: get_class('GeoInteractorStyle'))
    GeoRandomGraphSource = property(lambda self: get_class('GeoRandomGraphSource'))
    Glyph2D = property(lambda self: get_class('Glyph2D'))
    GraphGeodesicPath = property(lambda self: get_class('GraphGeodesicPath'))
    GraphLayoutView = property(lambda self: get_class('GraphLayoutView'))
    GraphWeightEuclideanDistanceFilter = property(lambda self: get_class('GraphWeightEuclideanDistanceFilter'))
    GraphWriter = property(lambda self: get_class('GraphWriter'))
    HardwareSelectionPolyDataPainter = property(lambda self: get_class('HardwareSelectionPolyDataPainter'))
    HierarchicalDataExtractDataSets = property(lambda self: get_class('HierarchicalDataExtractDataSets'))
    HierarchicalDataExtractLevel = property(lambda self: get_class('HierarchicalDataExtractLevel'))
    HierarchicalDataSetGeometryFilter = property(lambda self: get_class('HierarchicalDataSetGeometryFilter'))
    HighestDensityRegionsStatistics = property(lambda self: get_class('HighestDensityRegionsStatistics'))
    IdentityTransform = property(lambda self: get_class('IdentityTransform'))
    ImageActor = property(lambda self: get_class('ImageActor'))
    ImageAppend = property(lambda self: get_class('ImageAppend'))
    ImageAppendComponents = property(lambda self: get_class('ImageAppendComponents'))
    ImageBSplineCoefficients = property(lambda self: get_class('ImageBSplineCoefficients'))
    ImageBlend = property(lambda self: get_class('ImageBlend'))
    ImageButterworthHighPass = property(lambda self: get_class('ImageButterworthHighPass'))
    ImageButterworthLowPass = property(lambda self: get_class('ImageButterworthLowPass'))
    ImageCast = property(lambda self: get_class('ImageCast'))
    ImageCheckerboard = property(lambda self: get_class('ImageCheckerboard'))
    ImageConvolve = property(lambda self: get_class('ImageConvolve'))
    ImageCorrelation = property(lambda self: get_class('ImageCorrelation'))
    ImageCursor3D = property(lambda self: get_class('ImageCursor3D'))
    ImageDifference = property(lambda self: get_class('ImageDifference'))
    ImageDivergence = property(lambda self: get_class('ImageDivergence'))
    ImageDotProduct = property(lambda self: get_class('ImageDotProduct'))
    ImageEuclideanToPolar = property(lambda self: get_class('ImageEuclideanToPolar'))
    ImageExtractComponents = property(lambda self: get_class('ImageExtractComponents'))
    ImageGaussianSmooth = property(lambda self: get_class('ImageGaussianSmooth'))
    ImageGradient = property(lambda self: get_class('ImageGradient'))
    ImageGradientMagnitude = property(lambda self: get_class('ImageGradientMagnitude'))
    ImageHSIToRGB = property(lambda self: get_class('ImageHSIToRGB'))
    ImageHSVToRGB = property(lambda self: get_class('ImageHSVToRGB'))
    ImageHistogram = property(lambda self: get_class('ImageHistogram'))
    ImageIdealHighPass = property(lambda self: get_class('ImageIdealHighPass'))
    ImageIdealLowPass = property(lambda self: get_class('ImageIdealLowPass'))
    ImageImportExecutive = property(lambda self: get_class('ImageImportExecutive'))
    ImageIterateFilter = property(lambda self: get_class('ImageIterateFilter'))
    ImageLaplacian = property(lambda self: get_class('ImageLaplacian'))
    ImageLogarithmicScale = property(lambda self: get_class('ImageLogarithmicScale'))
    ImageLogic = property(lambda self: get_class('ImageLogic'))
    ImageLuminance = property(lambda self: get_class('ImageLuminance'))
    ImageMagnify = property(lambda self: get_class('ImageMagnify'))
    ImageMagnitude = property(lambda self: get_class('ImageMagnitude'))
    ImageMapToColors = property(lambda self: get_class('ImageMapToColors'))
    ImageMapper = property(lambda self: get_class('ImageMapper'))
    ImageMapper3D = property(lambda self: get_class('ImageMapper3D'))
    ImageMask = property(lambda self: get_class('ImageMask'))
    ImageMaskBits = property(lambda self: get_class('ImageMaskBits'))
    ImageMathematics = property(lambda self: get_class('ImageMathematics'))
    ImageNonMaximumSuppression = property(lambda self: get_class('ImageNonMaximumSuppression'))
    ImageNormalize = property(lambda self: get_class('ImageNormalize'))
    ImagePadFilter = property(lambda self: get_class('ImagePadFilter'))
    ImagePlaneWidget = property(lambda self: get_class('ImagePlaneWidget'))
    ImageRGBToHSI = property(lambda self: get_class('ImageRGBToHSI'))
    ImageRGBToHSV = property(lambda self: get_class('ImageRGBToHSV'))
    ImageReader = property(lambda self: get_class('ImageReader'))
    ImageRectilinearWipe = property(lambda self: get_class('ImageRectilinearWipe'))
    ImageResize = property(lambda self: get_class('ImageResize'))
    ImageReslice = property(lambda self: get_class('ImageReslice'))
    ImageShiftScale = property(lambda self: get_class('ImageShiftScale'))
    ImageShrink3D = property(lambda self: get_class('ImageShrink3D'))
    ImageSlab = property(lambda self: get_class('ImageSlab'))
    ImageSpatialAlgorithm = property(lambda self: get_class('ImageSpatialAlgorithm'))
    ImageStack = property(lambda self: get_class('ImageStack'))
    ImageStencil = property(lambda self: get_class('ImageStencil'))
    ImageThreshold = property(lambda self: get_class('ImageThreshold'))
    ImageToAMR = property(lambda self: get_class('ImageToAMR'))
    ImageWeightedSum = property(lambda self: get_class('ImageWeightedSum'))
    ImplicitFunctionToImageStencil = property(lambda self: get_class('ImplicitFunctionToImageStencil'))
    ImplicitPlaneWidget = property(lambda self: get_class('ImplicitPlaneWidget'))
    IncrementalOctreePointLocator = property(lambda self: get_class('IncrementalOctreePointLocator'))
    InteractorStyleAreaSelectHover = property(lambda self: get_class('InteractorStyleAreaSelectHover'))
    InteractorStyleImage = property(lambda self: get_class('InteractorStyleImage'))
    InteractorStyleMultiTouchCamera = property(lambda self: get_class('InteractorStyleMultiTouchCamera'))
    InteractorStyleRubberBand3D = property(lambda self: get_class('InteractorStyleRubberBand3D'))
    InteractorStyleRubberBandPick = property(lambda self: get_class('InteractorStyleRubberBandPick'))
    InteractorStyleSwitch = property(lambda self: get_class('InteractorStyleSwitch'))
    InterpolatedVelocityField = property(lambda self: get_class('InterpolatedVelocityField'))
    IterativeClosestPointTransform = property(lambda self: get_class('IterativeClosestPointTransform'))
    JPEGReader = property(lambda self: get_class('JPEGReader'))
    JPEGWriter = property(lambda self: get_class('JPEGWriter'))
    KMeansStatistics = property(lambda self: get_class('KMeansStatistics'))
    LODActor = property(lambda self: get_class('LODActor'))
    LabelHierarchy = property(lambda self: get_class('LabelHierarchy'))
    LabelPlacementMapper = property(lambda self: get_class('LabelPlacementMapper'))
    LabeledDataMapper = property(lambda self: get_class('LabeledDataMapper'))
    LandmarkTransform = property(lambda self: get_class('LandmarkTransform'))
    LassoStencilSource = property(lambda self: get_class('LassoStencilSource'))
    LinearSubdivisionFilter = property(lambda self: get_class('LinearSubdivisionFilter'))
    LinesPainter = property(lambda self: get_class('LinesPainter'))
    LogoRepresentation = property(lambda self: get_class('LogoRepresentation'))
    LogoWidget = property(lambda self: get_class('LogoWidget'))
    LoopSubdivisionFilter = property(lambda self: get_class('LoopSubdivisionFilter'))
    MINCImageReader = property(lambda self: get_class('MINCImageReader'))
    MINCImageWriter = property(lambda self: get_class('MINCImageWriter'))
    Mapper = property(lambda self: get_class('Mapper'))
    MatrixToLinearTransform = property(lambda self: get_class('MatrixToLinearTransform'))
    MedicalImageReader2 = property(lambda self: get_class('MedicalImageReader2'))
    MemoryLimitImageDataStreamer = property(lambda self: get_class('MemoryLimitImageDataStreamer'))
    MetaImageReader = property(lambda self: get_class('MetaImageReader'))
    MetaImageWriter = property(lambda self: get_class('MetaImageWriter'))
    Molecule = property(lambda self: get_class('Molecule'))
    MoleculeToAtomBallFilter = property(lambda self: get_class('MoleculeToAtomBallFilter'))
    MoleculeToBondStickFilter = property(lambda self: get_class('MoleculeToBondStickFilter'))
    MultiBlockDataSet = property(lambda self: get_class('MultiBlockDataSet'))
    MultiCorrelativeStatistics = property(lambda self: get_class('MultiCorrelativeStatistics'))
    MultiPieceDataSet = property(lambda self: get_class('MultiPieceDataSet'))
    MutableDirectedGraph = property(lambda self: get_class('MutableDirectedGraph'))
    MutableUndirectedGraph = property(lambda self: get_class('MutableUndirectedGraph'))
    NIFTIImageReader = property(lambda self: get_class('NIFTIImageReader'))
    NIFTIImageWriter = property(lambda self: get_class('NIFTIImageWriter'))
    NetCDFCFReader = property(lambda self: get_class('NetCDFCFReader'))
    NewickTreeWriter = property(lambda self: get_class('NewickTreeWriter'))
    NonOverlappingAMR = property(lambda self: get_class('NonOverlappingAMR'))
    OBBDicer = property(lambda self: get_class('OBBDicer'))
    OggTheoraWriter = property(lambda self: get_class('OggTheoraWriter'))
    OpenGLActor = property(lambda self: get_class('OpenGLActor'))
    OpenGLCoincidentTopologyResolutionPainter = property(lambda self: get_class('OpenGLCoincidentTopologyResolutionPainter'))
    OpenGLLightingPainter = property(lambda self: get_class('OpenGLLightingPainter'))
    OpenGLRepresentationPainter = property(lambda self: get_class('OpenGLRepresentationPainter'))
    OpenGLTexture = property(lambda self: get_class('OpenGLTexture'))
    OrderStatistics = property(lambda self: get_class('OrderStatistics'))
    OrientedGlyphContourRepresentation = property(lambda self: get_class('OrientedGlyphContourRepresentation'))
    OutlineCornerSource = property(lambda self: get_class('OutlineCornerSource'))
    OverlappingAMR = property(lambda self: get_class('OverlappingAMR'))
    OverlappingAMRLevelIdScalars = property(lambda self: get_class('OverlappingAMRLevelIdScalars'))
    PCellDataToPointData = property(lambda self: get_class('PCellDataToPointData'))
    PChacoReader = property(lambda self: get_class('PChacoReader'))
    PComputeHistogram2DOutliers = property(lambda self: get_class('PComputeHistogram2DOutliers'))
    PDBReader = property(lambda self: get_class('PDBReader'))
    PExtractArraysOverTime = property(lambda self: get_class('PExtractArraysOverTime'))
    PImageWriter = property(lambda self: get_class('PImageWriter'))
    PLinearExtrusionFilter = property(lambda self: get_class('PLinearExtrusionFilter'))
    PMaskPoints = property(lambda self: get_class('PMaskPoints'))
    PNGReader = property(lambda self: get_class('PNGReader'))
    PNGWriter = property(lambda self: get_class('PNGWriter'))
    PNMWriter = property(lambda self: get_class('PNMWriter'))
    POpenFOAMReader = property(lambda self: get_class('POpenFOAMReader'))
    PPolyDataNormals = property(lambda self: get_class('PPolyDataNormals'))
    PProjectSphereFilter = property(lambda self: get_class('PProjectSphereFilter'))
    PReflectionFilter = property(lambda self: get_class('PReflectionFilter'))
    PSLACReader = property(lambda self: get_class('PSLACReader'))
    PSphereSource = property(lambda self: get_class('PSphereSource'))
    PYoungsMaterialInterface = property(lambda self: get_class('PYoungsMaterialInterface'))
    PairwiseExtractHistogram2D = property(lambda self: get_class('PairwiseExtractHistogram2D'))
    ParallelCoordinatesInteractorStyle = property(lambda self: get_class('ParallelCoordinatesInteractorStyle'))
    ParallelCoordinatesView = property(lambda self: get_class('ParallelCoordinatesView'))
    ParticlePathFilter = property(lambda self: get_class('ParticlePathFilter'))
    ParticleTracer = property(lambda self: get_class('ParticleTracer'))
    Path = property(lambda self: get_class('Path'))
    PlaneWidget = property(lambda self: get_class('PlaneWidget'))
    PlaybackRepresentation = property(lambda self: get_class('PlaybackRepresentation'))
    PlaybackWidget = property(lambda self: get_class('PlaybackWidget'))
    PlotBar = property(lambda self: get_class('PlotBar'))
    PlotBox = property(lambda self: get_class('PlotBox'))
    PlotFunctionalBag = property(lambda self: get_class('PlotFunctionalBag'))
    PlotHistogram2D = property(lambda self: get_class('PlotHistogram2D'))
    PlotParallelCoordinates = property(lambda self: get_class('PlotParallelCoordinates'))
    PlotPie = property(lambda self: get_class('PlotPie'))
    PlotPoints = property(lambda self: get_class('PlotPoints'))
    PlotPoints3D = property(lambda self: get_class('PlotPoints3D'))
    PlotStacked = property(lambda self: get_class('PlotStacked'))
    PlotSurface = property(lambda self: get_class('PlotSurface'))
    PointHandleRepresentation2D = property(lambda self: get_class('PointHandleRepresentation2D'))
    PointHandleRepresentation3D = property(lambda self: get_class('PointHandleRepresentation3D'))
    PointLocator = property(lambda self: get_class('PointLocator'))
    PointPicker = property(lambda self: get_class('PointPicker'))
    PointsPainter = property(lambda self: get_class('PointsPainter'))
    PolarAxesActor = property(lambda self: get_class('PolarAxesActor'))
    PolyData = property(lambda self: get_class('PolyData'))
    PolyDataMapper2D = property(lambda self: get_class('PolyDataMapper2D'))
    PolyDataToImageStencil = property(lambda self: get_class('PolyDataToImageStencil'))
    PolyDataWriter = property(lambda self: get_class('PolyDataWriter'))
    PolygonsPainter = property(lambda self: get_class('PolygonsPainter'))
    PostScriptWriter = property(lambda self: get_class('PostScriptWriter'))
    ProbeSelectedLocations = property(lambda self: get_class('ProbeSelectedLocations'))
    Prop3DAxisFollower = property(lambda self: get_class('Prop3DAxisFollower'))
    Prop3DButtonRepresentation = property(lambda self: get_class('Prop3DButtonRepresentation'))
    QuadricLODActor = property(lambda self: get_class('QuadricLODActor'))
    QuantizePolyDataPoints = property(lambda self: get_class('QuantizePolyDataPoints'))
    ROIStencilSource = property(lambda self: get_class('ROIStencilSource'))
    RectangularButtonSource = property(lambda self: get_class('RectangularButtonSource'))
    RectilinearGridWriter = property(lambda self: get_class('RectilinearGridWriter'))
    RenderedAreaPicker = property(lambda self: get_class('RenderedAreaPicker'))
    RenderedRepresentation = property(lambda self: get_class('RenderedRepresentation'))
    ResliceCursorLineRepresentation = property(lambda self: get_class('ResliceCursorLineRepresentation'))
    ResliceCursorPicker = property(lambda self: get_class('ResliceCursorPicker'))
    SLCReader = property(lambda self: get_class('SLCReader'))
    SMPContourGrid = property(lambda self: get_class('SMPContourGrid'))
    SMPContourGridManyPieces = property(lambda self: get_class('SMPContourGridManyPieces'))
    SMPWarpVector = property(lambda self: get_class('SMPWarpVector'))
    SQLiteToTableReader = property(lambda self: get_class('SQLiteToTableReader'))
    ScalarBarRepresentation = property(lambda self: get_class('ScalarBarRepresentation'))
    ScalarBarWidget = property(lambda self: get_class('ScalarBarWidget'))
    ScalarsToColorsItem = property(lambda self: get_class('ScalarsToColorsItem'))
    SimpleImageFilterExample = property(lambda self: get_class('SimpleImageFilterExample'))
    SliderRepresentation2D = property(lambda self: get_class('SliderRepresentation2D'))
    SliderRepresentation3D = property(lambda self: get_class('SliderRepresentation3D'))
    SphereHandleRepresentation = property(lambda self: get_class('SphereHandleRepresentation'))
    StreaklineFilter = property(lambda self: get_class('StreaklineFilter'))
    StreamLine = property(lambda self: get_class('StreamLine'))
    StreamPoints = property(lambda self: get_class('StreamPoints'))
    StructuredGrid = property(lambda self: get_class('StructuredGrid'))
    StructuredGridGhostDataGenerator = property(lambda self: get_class('StructuredGridGhostDataGenerator'))
    StructuredGridWriter = property(lambda self: get_class('StructuredGridWriter'))
    StructuredPoints = property(lambda self: get_class('StructuredPoints'))
    StructuredPointsGeometryFilter = property(lambda self: get_class('StructuredPointsGeometryFilter'))
    StructuredPointsWriter = property(lambda self: get_class('StructuredPointsWriter'))
    SynchronizedTemplatesCutter3D = property(lambda self: get_class('SynchronizedTemplatesCutter3D'))
    TIFFReader = property(lambda self: get_class('TIFFReader'))
    TIFFWriter = property(lambda self: get_class('TIFFWriter'))
    TStripsPainter = property(lambda self: get_class('TStripsPainter'))
    TableToSQLiteWriter = property(lambda self: get_class('TableToSQLiteWriter'))
    TableWriter = property(lambda self: get_class('TableWriter'))
    TemporalStreamTracer = property(lambda self: get_class('TemporalStreamTracer'))
    TextActor = property(lambda self: get_class('TextActor'))
    TextMapper = property(lambda self: get_class('TextMapper'))
    TextRepresentation = property(lambda self: get_class('TextRepresentation'))
    TextWidget = property(lambda self: get_class('TextWidget'))
    TexturedButtonRepresentation = property(lambda self: get_class('TexturedButtonRepresentation'))
    TexturedButtonRepresentation2D = property(lambda self: get_class('TexturedButtonRepresentation2D'))
    Transform = property(lambda self: get_class('Transform'))
    TransmitImageDataPiece = property(lambda self: get_class('TransmitImageDataPiece'))
    TransmitRectilinearGridPiece = property(lambda self: get_class('TransmitRectilinearGridPiece'))
    TransmitStructuredGridPiece = property(lambda self: get_class('TransmitStructuredGridPiece'))
    TreeAreaView = property(lambda self: get_class('TreeAreaView'))
    TreeWriter = property(lambda self: get_class('TreeWriter'))
    TypeFloat32Array = property(lambda self: get_class('TypeFloat32Array'))
    TypeFloat64Array = property(lambda self: get_class('TypeFloat64Array'))
    TypeInt16Array = property(lambda self: get_class('TypeInt16Array'))
    TypeInt32Array = property(lambda self: get_class('TypeInt32Array'))
    TypeInt64Array = property(lambda self: get_class('TypeInt64Array'))
    TypeInt8Array = property(lambda self: get_class('TypeInt8Array'))
    TypeUInt16Array = property(lambda self: get_class('TypeUInt16Array'))
    TypeUInt32Array = property(lambda self: get_class('TypeUInt32Array'))
    TypeUInt64Array = property(lambda self: get_class('TypeUInt64Array'))
    TypeUInt8Array = property(lambda self: get_class('TypeUInt8Array'))
    UniformGrid = property(lambda self: get_class('UniformGrid'))
    UniformGridGhostDataGenerator = property(lambda self: get_class('UniformGridGhostDataGenerator'))
    UnstructuredGridBase = property(lambda self: get_class('UnstructuredGridBase'))
    UnstructuredGridWriter = property(lambda self: get_class('UnstructuredGridWriter'))
    ValuePainter = property(lambda self: get_class('ValuePainter'))
    ValuePass = property(lambda self: get_class('ValuePass'))
    Volume16Reader = property(lambda self: get_class('Volume16Reader'))
    VolumeRayCastSpaceLeapingImageFilter = property(lambda self: get_class('VolumeRayCastSpaceLeapingImageFilter'))
    Win32OpenGLRenderWindow = property(lambda self: get_class('Win32OpenGLRenderWindow'))
    Win32VideoSource = property(lambda self: get_class('Win32VideoSource'))
    XMLGenericDataObjectReader = property(lambda self: get_class('XMLGenericDataObjectReader'))
    XMLHyperOctreeReader = property(lambda self: get_class('XMLHyperOctreeReader'))
    XMLImageDataWriter = property(lambda self: get_class('XMLImageDataWriter'))
    XMLMultiBlockDataReader = property(lambda self: get_class('XMLMultiBlockDataReader'))
    XMLMultiBlockDataWriter = property(lambda self: get_class('XMLMultiBlockDataWriter'))
    XMLPDataSetWriter = property(lambda self: get_class('XMLPDataSetWriter'))
    XMLPStructuredDataReader = property(lambda self: get_class('XMLPStructuredDataReader'))
    XMLPStructuredDataWriter = property(lambda self: get_class('XMLPStructuredDataWriter'))
    XMLPUnstructuredDataReader = property(lambda self: get_class('XMLPUnstructuredDataReader'))
    XMLPUnstructuredDataWriter = property(lambda self: get_class('XMLPUnstructuredDataWriter'))
    XMLPolyDataWriter = property(lambda self: get_class('XMLPolyDataWriter'))
    XMLRectilinearGridWriter = property(lambda self: get_class('XMLRectilinearGridWriter'))
    XMLStructuredDataReader = property(lambda self: get_class('XMLStructuredDataReader'))
    XMLStructuredGridWriter = property(lambda self: get_class('XMLStructuredGridWriter'))
    XMLUniformGridAMRReader = property(lambda self: get_class('XMLUniformGridAMRReader'))
    XMLUniformGridAMRWriter = property(lambda self: get_class('XMLUniformGridAMRWriter'))
    XMLUnstructuredDataReader = property(lambda self: get_class('XMLUnstructuredDataReader'))
    XMLUnstructuredGridWriter = property(lambda self: get_class('XMLUnstructuredGridWriter'))
    XYZMolReader = property(lambda self: get_class('XYZMolReader'))
    AMREnzoReader = property(lambda self: get_class('AMREnzoReader'))
    AMRFlashReader = property(lambda self: get_class('AMRFlashReader'))
    AxisFollower = property(lambda self: get_class('AxisFollower'))
    BMPReader = property(lambda self: get_class('BMPReader'))
    CPExodusIIElementBlock = property(lambda self: get_class('CPExodusIIElementBlock'))
    ChartHistogram2D = property(lambda self: get_class('ChartHistogram2D'))
    ColorTransferControlPointsItem = property(lambda self: get_class('ColorTransferControlPointsItem'))
    ColorTransferFunctionItem = property(lambda self: get_class('ColorTransferFunctionItem'))
    CompositePolyDataMapper = property(lambda self: get_class('CompositePolyDataMapper'))
    DashedStreamLine = property(lambda self: get_class('DashedStreamLine'))
    DataSetMapper = property(lambda self: get_class('DataSetMapper'))
    DijkstraGraphGeodesicPath = property(lambda self: get_class('DijkstraGraphGeodesicPath'))
    Dynamic2DLabelMapper = property(lambda self: get_class('Dynamic2DLabelMapper'))
    EnSight6BinaryReader = property(lambda self: get_class('EnSight6BinaryReader'))
    EnSight6Reader = property(lambda self: get_class('EnSight6Reader'))
    EnSightGoldBinaryReader = property(lambda self: get_class('EnSightGoldBinaryReader'))
    EnSightGoldReader = property(lambda self: get_class('EnSightGoldReader'))
    GESignaReader = property(lambda self: get_class('GESignaReader'))
    Glyph3DMapper = property(lambda self: get_class('Glyph3DMapper'))
    GraphMapper = property(lambda self: get_class('GraphMapper'))
    HierarchicalBoxDataSet = property(lambda self: get_class('HierarchicalBoxDataSet'))
    HierarchicalGraphView = property(lambda self: get_class('HierarchicalGraphView'))
    IcicleView = property(lambda self: get_class('IcicleView'))
    ImageAnisotropicDiffusion2D = property(lambda self: get_class('ImageAnisotropicDiffusion2D'))
    ImageAnisotropicDiffusion3D = property(lambda self: get_class('ImageAnisotropicDiffusion3D'))
    ImageConstantPad = property(lambda self: get_class('ImageConstantPad'))
    ImageContinuousDilate3D = property(lambda self: get_class('ImageContinuousDilate3D'))
    ImageContinuousErode3D = property(lambda self: get_class('ImageContinuousErode3D'))
    ImageDecomposeFilter = property(lambda self: get_class('ImageDecomposeFilter'))
    ImageDilateErode3D = property(lambda self: get_class('ImageDilateErode3D'))
    ImageFlip = property(lambda self: get_class('ImageFlip'))
    ImageHistogramStatistics = property(lambda self: get_class('ImageHistogramStatistics'))
    ImageHybridMedian2D = property(lambda self: get_class('ImageHybridMedian2D'))
    ImageMapToRGBA = property(lambda self: get_class('ImageMapToRGBA'))
    ImageMapToWindowLevelColors = property(lambda self: get_class('ImageMapToWindowLevelColors'))
    ImageMedian3D = property(lambda self: get_class('ImageMedian3D'))
    ImageMirrorPad = property(lambda self: get_class('ImageMirrorPad'))
    ImagePermute = property(lambda self: get_class('ImagePermute'))
    ImageRange3D = property(lambda self: get_class('ImageRange3D'))
    ImageResample = property(lambda self: get_class('ImageResample'))
    ImageResliceMapper = property(lambda self: get_class('ImageResliceMapper'))
    ImageResliceToColors = property(lambda self: get_class('ImageResliceToColors'))
    ImageSkeleton2D = property(lambda self: get_class('ImageSkeleton2D'))
    ImageSlabReslice = property(lambda self: get_class('ImageSlabReslice'))
    ImageSliceMapper = property(lambda self: get_class('ImageSliceMapper'))
    ImageSobel2D = property(lambda self: get_class('ImageSobel2D'))
    ImageSobel3D = property(lambda self: get_class('ImageSobel3D'))
    ImageVariance3D = property(lambda self: get_class('ImageVariance3D'))
    ImageWrapPad = property(lambda self: get_class('ImageWrapPad'))
    InteractorStyleTrackball = property(lambda self: get_class('InteractorStyleTrackball'))
    InteractorStyleTreeMapHover = property(lambda self: get_class('InteractorStyleTreeMapHover'))
    LabeledContourMapper = property(lambda self: get_class('LabeledContourMapper'))
    LabeledTreeMapDataMapper = property(lambda self: get_class('LabeledTreeMapDataMapper'))
    LevelIdScalars = property(lambda self: get_class('LevelIdScalars'))
    LookupTableItem = property(lambda self: get_class('LookupTableItem'))
    MergePoints = property(lambda self: get_class('MergePoints'))
    MoleculeMapper = property(lambda self: get_class('MoleculeMapper'))
    NonMergingPointLocator = property(lambda self: get_class('NonMergingPointLocator'))
    NrrdReader = property(lambda self: get_class('NrrdReader'))
    OpenGLFreeTypeTextMapper = property(lambda self: get_class('OpenGLFreeTypeTextMapper'))
    OpenGLImageMapper = property(lambda self: get_class('OpenGLImageMapper'))
    OpenGLPolyDataMapper2D = property(lambda self: get_class('OpenGLPolyDataMapper2D'))
    OrientedGlyphFocalPlaneContourRepresentation = property(lambda self: get_class('OrientedGlyphFocalPlaneContourRepresentation'))
    OrientedPolygonalHandleRepresentation3D = property(lambda self: get_class('OrientedPolygonalHandleRepresentation3D'))
    PCAStatistics = property(lambda self: get_class('PCAStatistics'))
    PDataSetWriter = property(lambda self: get_class('PDataSetWriter'))
    PExtractHistogram2D = property(lambda self: get_class('PExtractHistogram2D'))
    PNMReader = property(lambda self: get_class('PNMReader'))
    PPairwiseExtractHistogram2D = property(lambda self: get_class('PPairwiseExtractHistogram2D'))
    PProbeFilter = property(lambda self: get_class('PProbeFilter'))
    ParallelCoordinatesRepresentation = property(lambda self: get_class('ParallelCoordinatesRepresentation'))
    PiecewiseControlPointsItem = property(lambda self: get_class('PiecewiseControlPointsItem'))
    PiecewiseFunctionItem = property(lambda self: get_class('PiecewiseFunctionItem'))
    PlotBag = property(lambda self: get_class('PlotBag'))
    PlotLine = property(lambda self: get_class('PlotLine'))
    PlotLine3D = property(lambda self: get_class('PlotLine3D'))
    PolyDataMapper = property(lambda self: get_class('PolyDataMapper'))
    PolygonalHandleRepresentation3D = property(lambda self: get_class('PolygonalHandleRepresentation3D'))
    ReebGraph = property(lambda self: get_class('ReebGraph'))
    RenderedGraphRepresentation = property(lambda self: get_class('RenderedGraphRepresentation'))
    RenderedSurfaceRepresentation = property(lambda self: get_class('RenderedSurfaceRepresentation'))
    RenderedTreeAreaRepresentation = property(lambda self: get_class('RenderedTreeAreaRepresentation'))
    ResliceCursorThickLineRepresentation = property(lambda self: get_class('ResliceCursorThickLineRepresentation'))
    SMPTransform = property(lambda self: get_class('SMPTransform'))
    ScaledTextActor = property(lambda self: get_class('ScaledTextActor'))
    SimplePointsWriter = property(lambda self: get_class('SimplePointsWriter'))
    ThreadedCompositeDataPipeline = property(lambda self: get_class('ThreadedCompositeDataPipeline'))
    Tree = property(lambda self: get_class('Tree'))
    TreeMapView = property(lambda self: get_class('TreeMapView'))
    TreeRingView = property(lambda self: get_class('TreeRingView'))
    UnstructuredGrid = property(lambda self: get_class('UnstructuredGrid'))
    UnstructuredGridVolumeMapper = property(lambda self: get_class('UnstructuredGridVolumeMapper'))
    VolumeMapper = property(lambda self: get_class('VolumeMapper'))
    VolumePicker = property(lambda self: get_class('VolumePicker'))
    XMLHierarchicalBoxDataReader = property(lambda self: get_class('XMLHierarchicalBoxDataReader'))
    XMLHierarchicalBoxDataWriter = property(lambda self: get_class('XMLHierarchicalBoxDataWriter'))
    XMLImageDataReader = property(lambda self: get_class('XMLImageDataReader'))
    XMLMultiGroupDataReader = property(lambda self: get_class('XMLMultiGroupDataReader'))
    XMLPImageDataReader = property(lambda self: get_class('XMLPImageDataReader'))
    XMLPImageDataWriter = property(lambda self: get_class('XMLPImageDataWriter'))
    XMLPMultiBlockDataWriter = property(lambda self: get_class('XMLPMultiBlockDataWriter'))
    XMLPPolyDataReader = property(lambda self: get_class('XMLPPolyDataReader'))
    XMLPPolyDataWriter = property(lambda self: get_class('XMLPPolyDataWriter'))
    XMLPRectilinearGridReader = property(lambda self: get_class('XMLPRectilinearGridReader'))
    XMLPRectilinearGridWriter = property(lambda self: get_class('XMLPRectilinearGridWriter'))
    XMLPStructuredGridReader = property(lambda self: get_class('XMLPStructuredGridReader'))
    XMLPStructuredGridWriter = property(lambda self: get_class('XMLPStructuredGridWriter'))
    XMLPUniformGridAMRWriter = property(lambda self: get_class('XMLPUniformGridAMRWriter'))
    XMLPUnstructuredGridReader = property(lambda self: get_class('XMLPUnstructuredGridReader'))
    XMLPUnstructuredGridWriter = property(lambda self: get_class('XMLPUnstructuredGridWriter'))
    XMLPolyDataReader = property(lambda self: get_class('XMLPolyDataReader'))
    XMLRectilinearGridReader = property(lambda self: get_class('XMLRectilinearGridReader'))
    XMLStructuredGridReader = property(lambda self: get_class('XMLStructuredGridReader'))
    XMLUnstructuredGridReader = property(lambda self: get_class('XMLUnstructuredGridReader'))
    CompositeControlPointsItem = property(lambda self: get_class('CompositeControlPointsItem'))
    CompositeTransferFunctionItem = property(lambda self: get_class('CompositeTransferFunctionItem'))
    DijkstraImageGeodesicPath = property(lambda self: get_class('DijkstraImageGeodesicPath'))
    FixedPointVolumeRayCastMapper = property(lambda self: get_class('FixedPointVolumeRayCastMapper'))
    FixedSizeHandleRepresentation3D = property(lambda self: get_class('FixedSizeHandleRepresentation3D'))
    GPUVolumeRayCastMapper = property(lambda self: get_class('GPUVolumeRayCastMapper'))
    HAVSVolumeMapper = property(lambda self: get_class('HAVSVolumeMapper'))
    HierarchicalDataLevelFilter = property(lambda self: get_class('HierarchicalDataLevelFilter'))
    HierarchicalPolyDataMapper = property(lambda self: get_class('HierarchicalPolyDataMapper'))
    ImageCityBlockDistance = property(lambda self: get_class('ImageCityBlockDistance'))
    ImageEuclideanDistance = property(lambda self: get_class('ImageEuclideanDistance'))
    ImageFourierCenter = property(lambda self: get_class('ImageFourierCenter'))
    ImageFourierFilter = property(lambda self: get_class('ImageFourierFilter'))
    ImageSeparableConvolution = property(lambda self: get_class('ImageSeparableConvolution'))
    OpenGLGlyph3DMapper = property(lambda self: get_class('OpenGLGlyph3DMapper'))
    OpenGLImageSliceMapper = property(lambda self: get_class('OpenGLImageSliceMapper'))
    OpenGLLabeledContourMapper = property(lambda self: get_class('OpenGLLabeledContourMapper'))
    OpenGLPolyDataMapper = property(lambda self: get_class('OpenGLPolyDataMapper'))
    PainterPolyDataMapper = property(lambda self: get_class('PainterPolyDataMapper'))
    ParallelCoordinatesHistogramRepresentation = property(lambda self: get_class('ParallelCoordinatesHistogramRepresentation'))
    ProjectedAAHexahedraMapper = property(lambda self: get_class('ProjectedAAHexahedraMapper'))
    ProjectedTetrahedraMapper = property(lambda self: get_class('ProjectedTetrahedraMapper'))
    RTXMLPolyDataReader = property(lambda self: get_class('RTXMLPolyDataReader'))
    RenderedHierarchyRepresentation = property(lambda self: get_class('RenderedHierarchyRepresentation'))
    SMPMergePoints = property(lambda self: get_class('SMPMergePoints'))
    SmartVolumeMapper = property(lambda self: get_class('SmartVolumeMapper'))
    UnstructuredGridVolumeRayCastMapper = property(lambda self: get_class('UnstructuredGridVolumeRayCastMapper'))
    UnstructuredGridVolumeZSweepMapper = property(lambda self: get_class('UnstructuredGridVolumeZSweepMapper'))
    VolumeRayCastMapper = property(lambda self: get_class('VolumeRayCastMapper'))
    VolumeTextureMapper = property(lambda self: get_class('VolumeTextureMapper'))
    VolumeTextureMapper3D = property(lambda self: get_class('VolumeTextureMapper3D'))
    XMLHierarchicalDataReader = property(lambda self: get_class('XMLHierarchicalDataReader'))
    XMLPHierarchicalBoxDataWriter = property(lambda self: get_class('XMLPHierarchicalBoxDataWriter'))
    CompositePolyDataMapper2 = property(lambda self: get_class('CompositePolyDataMapper2'))
    ImageFFT = property(lambda self: get_class('ImageFFT'))
    ImageRFFT = property(lambda self: get_class('ImageRFFT'))
    OpenGLGPUVolumeRayCastMapper = property(lambda self: get_class('OpenGLGPUVolumeRayCastMapper'))
    OpenGLHAVSVolumeMapper = property(lambda self: get_class('OpenGLHAVSVolumeMapper'))
    OpenGLProjectedAAHexahedraMapper = property(lambda self: get_class('OpenGLProjectedAAHexahedraMapper'))
    OpenGLProjectedTetrahedraMapper = property(lambda self: get_class('OpenGLProjectedTetrahedraMapper'))
    OpenGLVolumeTextureMapper3D = property(lambda self: get_class('OpenGLVolumeTextureMapper3D'))
    VolumeTextureMapper2D = property(lambda self: get_class('VolumeTextureMapper2D'))
    OpenGLVolumeTextureMapper2D = property(lambda self: get_class('OpenGLVolumeTextureMapper2D'))
