# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

class TypedArray(tvtk_base.TVTKBase):
    """
    TypedArray - Provides a type-specific interface to N-way arrays
    
    Superclass: Array
    
    TypedArray provides an interface for retrieving and updating data
    in an arbitrary-dimension array.  It derives from Array and is
    templated on the type of value stored in the array.
    
    Methods are provided for retrieving and updating array values based
    either on their array coordinates, or on a 1-dimensional integer
    index.  The latter approach can be used to iterate over the values in
    an array in arbitrary order, which is useful when writing filters
    that operate efficiently on sparse arrays and arrays that can have
    any number of dimensions.
    
    Special overloaded methods provide simple access for arrays with one,
    two, or three dimensions.
    
    See Also:
    
    Array, DenseArray, SparseArray
    
    Thanks:
    
    Developed by Timothy M. Shead (tshead@sandia.gov) at Sandia National
    Laboratories.
    
    
    Provided Types:
    
      TypedArray[char] => TypedArray<char>
      TypedArray[int8] => TypedArray<signed char>
      TypedArray[uint8] => TypedArray<unsigned char>
      TypedArray[int16] => TypedArray<short>
      TypedArray[uint16] => TypedArray<unsigned short>
      TypedArray[int32] => TypedArray<int>
      TypedArray[uint32] => TypedArray<unsigned int>
      TypedArray[int] => TypedArray<long>
      TypedArray[uint] => TypedArray<unsigned long>
      TypedArray[int64] => TypedArray<long long>
      TypedArray[uint64] => TypedArray<unsigned long long>
      TypedArray[float32] => TypedArray<float>
      TypedArray[float64] => TypedArray<double>
      TypedArray[str] => TypedArray<vtkStdString>
      TypedArray[unicode] => TypedArray<vtkUnicodeString>
      TypedArray[vtkVariant] => TypedArray<vtkVariant>
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTypedArray, obj, update, **traits)
    
    _updateable_traits_ = \
    ()
    
    _full_traitnames_list_ = \
    ([])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(TypedArray, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit TypedArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], []),
            title='Edit TypedArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit TypedArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

