# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.array import Array


class TypedArray_I12vtkStdStringE(Array):
    """
    TypedArray - Provides a type-specific interface to N-way arrays
    
    Superclass: Array
    
    TypedArray provides an interface for retrieving and updating data
    in an arbitrary-dimension array.  It derives from Array and is
    templated on the type of value stored in the array.
    
    Methods are provided for retrieving and updating array values based
    either on their array coordinates, or on a 1-dimensional integer
    index.  The latter approach can be used to iterate over the values in
    an array in arbitrary order, which is useful when writing filters
    that operate efficiently on sparse arrays and arrays that can have
    any number of dimensions.
    
    Special overloaded methods provide simple access for arrays with one,
    two, or three dimensions.
    
    See Also:
    
    Array, DenseArray, SparseArray
    
    Thanks:
    
    Developed by Timothy M. Shead (tshead@sandia.gov) at Sandia National
    Laboratories.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTypedArray_I12vtkStdStringE, obj, update, **traits)
    
    value_n = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), help=\
        """
        Overwrites the n-th value stored in the array, where n is in the
        range [0, get_non_null_size()).  This is useful for efficiently
        visiting every value in the array.  Note that the order in which
        values are visited is undefined, but is guaranteed to match the
        order used by Array::GetCoordinatesN().
        """
    )
    def _value_n_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetValueN,
                        self.value_n)

    def get_variant_value(self, *args):
        """
        V.get_variant_value(int) -> Variant
        C++: Variant GetVariantValue(IdType i)
        V.get_variant_value(int, int) -> Variant
        C++: Variant GetVariantValue(IdType i, IdType j)
        V.get_variant_value(int, int, int) -> Variant
        C++: Variant GetVariantValue(IdType i, IdType j,
            IdType k)
        V.get_variant_value(ArrayCoordinates) -> Variant
        C++: virtual Variant GetVariantValue(
            const ArrayCoordinates &coordinates)"""
        my_args = deref_array(args, [['int'], ('int', 'int'), ('int', 'int', 'int'), ['vtkArrayCoordinates']])
        ret = self._wrap_call(self._vtk_obj.GetVariantValue, *my_args)
        return wrap_vtk(ret)

    def set_variant_value(self, *args):
        """
        V.set_variant_value(int, Variant)
        C++: void SetVariantValue(IdType i, const Variant &value)
        V.set_variant_value(int, int, Variant)
        C++: void SetVariantValue(IdType i, IdType j,
            const Variant &value)
        V.set_variant_value(int, int, int, Variant)
        C++: void SetVariantValue(IdType i, IdType j, IdType k,
            const Variant &value)
        V.set_variant_value(ArrayCoordinates, Variant)
        C++: virtual void SetVariantValue(
            const ArrayCoordinates &coordinates,
            const Variant &value)"""
        my_args = deref_array(args, [('int', 'vtkVariant'), ('int', 'int', 'vtkVariant'), ('int', 'int', 'int', 'vtkVariant'), ('vtkArrayCoordinates', 'vtkVariant')])
        ret = self._wrap_call(self._vtk_obj.SetVariantValue, *my_args)
        return ret

    value = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), help=\
        """
        Overwrites the value stored in the array at the given
        coordinates. Note that the number of dimensions in the supplied
        coordinates must match the number of dimensions in the array.
        """
    )
    def _value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetValue,
                        self.value)

    def get_variant_value_n(self, *args):
        """
        V.get_variant_value_n(int) -> Variant
        C++: virtual Variant GetVariantValueN(const SizeT n)"""
        ret = self._wrap_call(self._vtk_obj.GetVariantValueN, *args)
        return wrap_vtk(ret)

    def set_variant_value_n(self, *args):
        """
        V.set_variant_value_n(int, Variant)
        C++: virtual void SetVariantValueN(const SizeT n,
            const Variant &value)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetVariantValueN, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('value_n', 'GetValueN'), ('dimension_label',
    'GetDimensionLabel'), ('name', 'GetName'), ('reference_count',
    'GetReferenceCount'), ('value', 'GetValue'),
    ('global_warning_display', 'GetGlobalWarningDisplay'))
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'dimension_label', 'name',
    'value', 'value_n'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(TypedArray_I12vtkStdStringE, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit TypedArray_I12vtkStdStringE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], ['dimension_label', 'name', 'value',
            'value_n']),
            title='Edit TypedArray_I12vtkStdStringE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit TypedArray_I12vtkStdStringE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

