# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.standard_poly_data_painter import StandardPolyDataPainter


class ValuePainter(StandardPolyDataPainter):
    """
    ValuePainter - painter that renders arrays encoded into
    
    Superclass: StandardPolyDataPainter
    
    ValuePainter renders polygonal geometry where data values are
    encoded into 24 bit integers and send to the screen. The pixel colors
    can then be read and converted back into values later.
    
    See Also:
    
    ValuePass, ValuePasses
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkValuePainter, obj, update, **traits)
    
    def ARRAY_COMPONENT(self):
        """
        V.array__component() -> InformationIntegerKey
        C++: static InformationIntegerKey *ARRAY_COMPONENT()
        Optionally passed down from render_pass pipeline to controls what
        data array to draw.
        """
        ret = wrap_vtk(self._vtk_obj.ARRAY_COMPONENT())
        return ret
        

    def ARRAY_ID(self):
        """
        V.array__id() -> InformationIntegerKey
        C++: static InformationIntegerKey *ARRAY_ID()
        Optionally passed down from render_pass pipeline to controls what
        data array to draw.
        """
        ret = wrap_vtk(self._vtk_obj.ARRAY_ID())
        return ret
        

    def ARRAY_NAME(self):
        """
        V.array__name() -> InformationStringKey
        C++: static InformationStringKey *ARRAY_NAME()
        Optionally passed down from render_pass pipeline to controls what
        data array to draw.
        """
        ret = wrap_vtk(self._vtk_obj.ARRAY_NAME())
        return ret
        

    def color_to_value(self, *args):
        """
        V.color_to_value([int, ...], float, float, float)
        C++: static void ColorToValue(unsigned char *color, double min,
            double scale, double &value)"""
        ret = self._wrap_call(self._vtk_obj.ColorToValue, *args)
        return ret

    def SCALAR_MODE(self):
        """
        V.scalar__mode() -> InformationIntegerKey
        C++: static InformationIntegerKey *SCALAR_MODE()
        Optionally passed down from render_pass pipeline to controls what
        data array to draw.
        """
        ret = wrap_vtk(self._vtk_obj.SCALAR_MODE())
        return ret
        

    def SCALAR_RANGE(self):
        """
        V.scalar__range() -> InformationDoubleVectorKey
        C++: static InformationDoubleVectorKey *SCALAR_RANGE()
        Optionally passed down from render_pass pipeline to controls what
        data array to draw.
        """
        ret = wrap_vtk(self._vtk_obj.SCALAR_RANGE())
        return ret
        

    def set_input_array_to_process(self, *args):
        """
        V.set_input_array_to_process(int, string)
        C++: void SetInputArrayToProcess(int fieldAssociation,
            const char *name)
        V.set_input_array_to_process(int, int)
        C++: void SetInputArrayToProcess(int fieldAssociation,
            int fieldAttributeType)
        Set the array to be drawn. By default point scalars are used.
        Arguments are same as those passed to
        Algorithm::SetInputArrayToProcess except the first 3 arguments
        i.e. idx, port, connection.
        """
        ret = self._wrap_call(self._vtk_obj.SetInputArrayToProcess, *args)
        return ret

    def set_input_component_to_process(self, *args):
        """
        V.set_input_component_to_process(int)
        C++: void SetInputComponentToProcess(int comp)
        Set the component (0..numcomponents-1) of the specified array to
        be drawn. If input array is not a multicomponent array or
        component is otherwise out of range the painter uses the 0'th
        component instead.
        """
        ret = self._wrap_call(self._vtk_obj.SetInputComponentToProcess, *args)
        return ret

    def set_scalar_range(self, *args):
        """
        V.set_scalar_range(float, float)
        C++: void SetScalarRange(double min, double max)
        Use the provided scalar range instead of the range of the input
        data array.
        """
        ret = self._wrap_call(self._vtk_obj.SetScalarRange, *args)
        return ret

    def value_to_color(self, *args):
        """
        V.value_to_color(float, float, float, [int, ...])
        C++: static void ValueToColor(double value, double min,
            double scale, unsigned char *color)
        Internal convenience method to convert a value to a color TODO:
        make this templated and programmable
        """
        ret = self._wrap_call(self._vtk_obj.ValueToColor, *args)
        return ret

    _updateable_traits_ = \
    (('reference_count', 'GetReferenceCount'), ('progress',
    'GetProgress'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('debug', 'GetDebug'))
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ValuePainter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit ValuePainter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View(([], [], []),
            title='Edit ValuePainter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ValuePainter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

