# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.xml_structured_data_writer import XMLStructuredDataWriter


class XMLRectilinearGridWriter(XMLStructuredDataWriter):
    """
    XMLRectilinearGridWriter - Write VTK XML rectilinear_grid files.
    
    Superclass: XMLStructuredDataWriter
    
    XMLRectilinearGridWriter writes the VTK XML rectilinear_grid file
    format.  One rectilinear grid input can be written into one file in
    any number of streamed pieces.  The standard extension for this
    writer's file format is "vtr".  This writer is also used to write a
    single piece of the parallel file format.
    
    See Also:
    
    XMLPRectilinearGridWriter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkXMLRectilinearGridWriter, obj, update, **traits)
    
    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, help=\
        """
        Get/Set the writer's input.
        """
    )

    _updateable_traits_ = \
    (('byte_order', 'GetByteOrder'), ('file_name', 'GetFileName'),
    ('data_mode', 'GetDataMode'), ('write_to_output_string',
    'GetWriteToOutputString'), ('id_type', 'GetIdType'), ('ghost_level',
    'GetGhostLevel'), ('time_step', 'GetTimeStep'), ('block_size',
    'GetBlockSize'), ('write_extent', 'GetWriteExtent'),
    ('number_of_time_steps', 'GetNumberOfTimeSteps'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('header_type',
    'GetHeaderType'), ('reference_count', 'GetReferenceCount'),
    ('progress_text', 'GetProgressText'), ('time_step_range',
    'GetTimeStepRange'), ('abort_execute', 'GetAbortExecute'),
    ('write_piece', 'GetWritePiece'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'), ('progress',
    'GetProgress'), ('number_of_pieces', 'GetNumberOfPieces'),
    ('encode_appended_data', 'GetEncodeAppendedData'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'encode_appended_data',
    'global_warning_display', 'release_data_flag',
    'write_to_output_string', 'byte_order', 'data_mode', 'header_type',
    'id_type', 'block_size', 'file_name', 'ghost_level',
    'number_of_pieces', 'number_of_time_steps', 'progress_text',
    'time_step', 'time_step_range', 'write_extent', 'write_piece'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(XMLRectilinearGridWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit XMLRectilinearGridWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['encode_appended_data', 'write_to_output_string'],
            ['byte_order', 'data_mode', 'header_type', 'id_type'], ['block_size',
            'file_name', 'ghost_level', 'number_of_pieces',
            'number_of_time_steps', 'time_step', 'time_step_range',
            'write_extent', 'write_piece']),
            title='Edit XMLRectilinearGridWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit XMLRectilinearGridWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

