# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui import api as traitsui

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

from tvtk.tvtk_classes.xml_unstructured_data_writer import XMLUnstructuredDataWriter


class XMLUnstructuredGridWriter(XMLUnstructuredDataWriter):
    """
    XMLUnstructuredGridWriter - Write VTK XML unstructured_grid files.
    
    Superclass: XMLUnstructuredDataWriter
    
    XMLUnstructuredGridWriter writes the VTK XML unstructured_grid file
    format.  One unstructured grid input can be written into one file in
    any number of streamed pieces (if supported by the rest of the
    pipeline).  The standard extension for this writer's file format is
    "vtu".  This writer is also used to write a single piece of the
    parallel file format.
    
    See Also:
    
    XMLPUnstructuredGridWriter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkXMLUnstructuredGridWriter, obj, update, **traits)
    
    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, help=\
        """
        Get/Set the writer's input.
        """
    )

    _updateable_traits_ = \
    (('byte_order', 'GetByteOrder'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('write_to_output_string',
    'GetWriteToOutputString'), ('file_name', 'GetFileName'), ('time_step',
    'GetTimeStep'), ('abort_execute', 'GetAbortExecute'),
    ('progress_text', 'GetProgressText'), ('debug', 'GetDebug'),
    ('id_type', 'GetIdType'), ('header_type', 'GetHeaderType'),
    ('time_step_range', 'GetTimeStepRange'), ('number_of_time_steps',
    'GetNumberOfTimeSteps'), ('write_piece', 'GetWritePiece'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('progress',
    'GetProgress'), ('reference_count', 'GetReferenceCount'),
    ('ghost_level', 'GetGhostLevel'), ('block_size', 'GetBlockSize'),
    ('number_of_pieces', 'GetNumberOfPieces'), ('data_mode',
    'GetDataMode'), ('encode_appended_data', 'GetEncodeAppendedData'))
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'encode_appended_data',
    'global_warning_display', 'release_data_flag',
    'write_to_output_string', 'byte_order', 'data_mode', 'header_type',
    'id_type', 'block_size', 'file_name', 'ghost_level',
    'number_of_pieces', 'number_of_time_steps', 'progress_text',
    'time_step', 'time_step_range', 'write_piece'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(XMLUnstructuredGridWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            traitsui.View((traitsui.Item("handler._full_traits_list",show_label=False)),
            title='Edit XMLUnstructuredGridWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            traitsui.View((['encode_appended_data', 'write_to_output_string'],
            ['byte_order', 'data_mode', 'header_type', 'id_type'], ['block_size',
            'file_name', 'ghost_level', 'number_of_pieces',
            'number_of_time_steps', 'time_step', 'time_step_range',
            'write_piece']),
            title='Edit XMLUnstructuredGridWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            traitsui.View((traitsui.HGroup(traitsui.spring, "handler.view_type", show_border=True), 
            traitsui.Item("handler.info.object", editor = traitsui.InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit XMLUnstructuredGridWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

